//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  File:  ioctl_cfg.h
//
//  Configuration file for the IOCTL component.
//
#ifndef __IOCTL_CFG_H
#define __IOCTL_CFG_H

#if __cplusplus
extern "C" {
#endif

//------------------------------------------------------------------------------
//  RESTRICTION
//
//  This file is a configuration file for the IOCTL component.
//
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
//
//  Define:  IOCTL_PLATFORM_TYPE/OEM
//
//  Defines the platform type and OEM string.
//
#define IOCTL_PLATFORM_NAME             (L"SMDKV210 Board")
#define IOCTL_PLATFORM_OEM              (L"Samsung Electronics")
#define IOCTL_PLATFORM_MANUFACTURER     IOCTL_PLATFORM_OEM

//------------------------------------------------------------------------------
//  Define:  IOCTL_PROCESSOR_VENDOR/NAME/CORE
//
//  Defines the processor information
//

#define IOCTL_PROCESSOR_VENDOR    (L"Samsung Electronics")
#define IOCTL_PROCESSOR_NAME        (L"S5PV210")
#define IOCTL_PROCESSOR_CORE        (L"Cortex A-8")

//------------------------------------------------------------------------------
//
//  Define:  IOCTL_PROCESSOR_INSTRUCTION_SET
//
//  Defines the processor instruction set information
//
#define IOCTL_PROCESSOR_INSTRUCTION_SET     (0)
#define IOCTL_PROCESSOR_CLOCK_SPEED         (800000000)  //Default Setting. This Value is recongiured in OEMInit().

//------------------------------------------------------------------------------
//
//  Define:  IOCTL_HAL_GET_CPUID
//
//  Defines the processor identification code request
//
#define HAL_BSP_FID	2100

//-------------------------------------------------------------------------
// BSP IOCTLs (2100 ~ 2107)
//-------------------------------------------------------------------------
#define IOCTL_HAL_GET_CPUID             CTL_CODE(FILE_DEVICE_UNKNOWN, (HAL_BSP_FID+0), METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_HAL_SET_SYSTEM_LEVEL      CTL_CODE(FILE_DEVICE_UNKNOWN, (HAL_BSP_FID+1), METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_HAL_PROFILE_DVFS          CTL_CODE(FILE_DEVICE_UNKNOWN, (HAL_BSP_FID+2), METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_HAL_CHECK_LPAUDIO			CTL_CODE(FILE_DEVICE_UNKNOWN, (HAL_BSP_FID+3), METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_HAL_QUERY_DRVLOG			CTL_CODE(FILE_DEVICE_HAL, (HAL_BSP_FID+4), METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_HAL_QUERY_DRVMASK			CTL_CODE(FILE_DEVICE_HAL, (HAL_BSP_FID+5), METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_HAL_CHANGE_DRVMASK		CTL_CODE(FILE_DEVICE_HAL, (HAL_BSP_FID+6), METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_HAL_GET_SYSTEM_CLOCK      CTL_CODE(FILE_DEVICE_UNKNOWN, (HAL_BSP_FID+7), METHOD_BUFFERED, FILE_ANY_ACCESS)    
#define IOCTL_GET_EBOOT_CONFIG		    CTL_CODE(FILE_DEVICE_HAL, (HAL_BSP_FID+8), METHOD_BUFFERED, FILE_ANY_ACCESS)	
#define IOCTL_SET_EBOOT_CONFIG			CTL_CODE(FILE_DEVICE_HAL, (HAL_BSP_FID+9), METHOD_BUFFERED, FILE_ANY_ACCESS)	

//------------------------------------------------------------------------------

#if __cplusplus
}
#endif

#endif
