;//------------------------------------------------------------------------------
;//  NAMING CONVENTION
;//
;//  The IMAGE_ naming convention ...
;//
;//  IMAGE_<NAME>_<SECTION>_<MEMORY_DEVICE>_[OFFSET|SIZE|START|END]
;//
;//      <NAME>          - WINCE, BOOT, SHARE
;//      <SECTION>       - section name: user defined
;//      <MEMORY_DEVICE> - the memory device the block resides on
;//      OFFSET          - number of bytes from memory device start address
;//      SIZE            - maximum size of the block
;//      START           - start address of block    (device address + offset)
;//      END             - end address of block      (start address  + size - 1)
;//
;//------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; ONEDRAM 
;------------------------------------------------------------------------------
ONEDRAM_BASE_PA_START        EQU    (0x20000000)
ONEDRAM_BASE_CA_START        EQU    (0x88000000)
ONEDRAM_BASE_UA_START        EQU    (0xA8000000)

;------------------------------------------------------------------------------
; SDRAM  
;------------------------------------------------------------------------------
DRAM0_BASE_PA_START        EQU    (0x20000000)
DRAM0_BASE_CA_START        EQU    (0x88000000)
DRAM0_BASE_UA_START        EQU    (0xA8000000)
DRAM0_SIZE                 EQU    (0x08000000)

;------------------------------------------------------------------------------
; SDRAM  
;------------------------------------------------------------------------------
DRAM_BASE_PA_START        EQU    (0x40000000)
DRAM_BASE_CA_START        EQU    (0x80000000)
DRAM_BASE_UA_START        EQU    (0xA0000000)
DRAM_SIZE                 EQU    (0x08000000)

;------------------------------------------------------------------------------
; Extra DRAM for V210
;------------------------------------------------------------------------------
DRAM_EXTRA_BASE_PA_START  EQU    (0x48000000)
DRAM_EXTRA_BASE_CA_START  EQU    (0x99600000)
DRAM_EXTRA_BASE_UA_START  EQU    (0xB9500000)
DRAM_EXTRA_SIZE           EQU    (0x04a00000) ;(0x06B00000) modified by terry 20120616
;------------------------------------------------------------------------------
; Extra DM9000 for X210
;------------------------------------------------------------------------------
DRAM_DM9000_BASE_PA_START  EQU    (0x88000000)
DRAM_DM9000_BASE_CA_START  EQU    (0x9e000000)
;DRAM_DM9000_BASE_UA_START  EQU    (0xB9500000)
;DRAM_DM9000_SIZE           EQU    (0x02000000) ;




;------------------------------------------------------------------------------
; BL1 AREA (Stepping stone)
;------------------------------------------------------------------------------
IMAGE_STEPLOADER_PA_START EQU    (0xD0030000)
IMAGE_STEPLOADER_SIZE     EQU    (0x00001000)
IMAGE_IRAM_SIZE           EQU    (0x10000)

;------------------------------------------------------------------------------
; NBL1
;------------------------------------------------------------------------------
IMAGE_NBL1_PA_START       EQU    (IMAGE_STEPLOADER_PA_START)
IMAGE_NBL1_SIZE           EQU    (0x2000)     ; ONBL1 size is 8KB (4*page = 4*2KB = 8KB)

;------------------------------------------------------------------------------
; NBL2
;------------------------------------------------------------------------------
IMAGE_NBL2_OFFSET         EQU    (0x076C4000)
IMAGE_NBL2_PA_START       EQU    (DRAM_BASE_PA_START+IMAGE_NBL2_OFFSET)
IMAGE_NBL2_START_PAGE     EQU    (4)     ; (IMAGE_NBL1_SIZE/ONENAND_PAGE_SIZE)

;------------------------------------------------------------------------------
; Eboot
;------------------------------------------------------------------------------
IMAGE_EBOOT_OFFSET        EQU    (0x07700000)
IMAGE_EBOOT_PA_START      EQU    (DRAM_BASE_PA_START+IMAGE_EBOOT_OFFSET)
IMAGE_EBOOT_CA_START      EQU    (DRAM_BASE_CA_START+IMAGE_EBOOT_OFFSET)
IMAGE_EBOOT_UA_START      EQU    (DRAM_BASE_UA_START+IMAGE_EBOOT_OFFSET)

;------------------------------------------------------------------------------
; Boot RAM
;------------------------------------------------------------------------------
IMAGE_BL_RAM_CA_OFFSET EQU    (0x07800000)
IMAGE_BL_RAM_PA_START  EQU    (DRAM_BASE_PA_START+IMAGE_BL_RAM_CA_OFFSET)
IMAGE_BL_RAM_CA_START  EQU    (DRAM_BASE_CA_START+IMAGE_BL_RAM_CA_OFFSET)
IMAGE_BL_RAM_SIZE      EQU    (0x00700000)

;------------------------------------------------------------------------------
; NK
;------------------------------------------------------------------------------
IMAGE_NK_OFFSET           EQU    (0x00020000)
IMAGE_NK_PA_START         EQU    (DRAM_BASE_PA_START+IMAGE_NK_OFFSET)
IMAGE_NK_CA_START         EQU    (DRAM_BASE_CA_START+IMAGE_NK_OFFSET)
IMAGE_NK_UA_START         EQU    (DRAM_BASE_UA_START+IMAGE_NK_OFFSET)
IMAGE_NK_SIZE             EQU    (0x040E0000)

;------------------------------------------------------------------------------
; Sleep Data
;------------------------------------------------------------------------------
IMAGE_SLEEP_DATA_OFFSET   EQU    (0x00000400)
IMAGE_SLEEP_DATA_PA_START EQU    (DRAM_BASE_PA_START+IMAGE_SLEEP_DATA_OFFSET)
IMAGE_SLEEP_DATA_CA_START EQU    (DRAM_BASE_CA_START+IMAGE_SLEEP_DATA_OFFSET)
IMAGE_SLEEP_DATA_UA_START EQU    (DRAM_BASE_UA_START+IMAGE_SLEEP_DATA_OFFSET)
IMAGE_SLEEP_DATA_SIZE     EQU    (0x00000400)

;------------------------------------------------------------------------------
; Deep Idle Data( samse as sleep data because of sharing region)
;------------------------------------------------------------------------------
IMAGE_DEEPIDLE_DATA_OFFSET   EQU    (0x00000400)
IMAGE_DEEPIDLE_DATA_PA_START EQU    (DRAM_BASE_PA_START+IMAGE_DEEPIDLE_DATA_OFFSET)
IMAGE_DEEPIDLE_DATA_CA_START EQU    (DRAM_BASE_CA_START+IMAGE_DEEPIDLE_DATA_OFFSET)
IMAGE_DEEPIDLE_DATA_UA_START EQU    (DRAM_BASE_UA_START+IMAGE_DEEPIDLE_DATA_OFFSET)
IMAGE_DEEPIDLE_DATA_SIZE     EQU    (0x00000400)

;------------------------------------------------------------------------------
; BSPArgs
;------------------------------------------------------------------------------
IMAGE_SHARE_ARGS_OFFSET              EQU    (0x00000800)
IMAGE_SHARE_ARGS_UPDATEMODE_OFFSET   EQU    (0x00000044)
IMAGE_SHARE_ARGS_ULDRREBOOT_OFFSET   EQU    (0x00000048)
IMAGE_SHARE_ARGS_PA_START            EQU    (DRAM_BASE_PA_START+IMAGE_SHARE_ARGS_OFFSET)
IMAGE_SHARE_ARGS_CA_START            EQU    (DRAM_BASE_CA_START+IMAGE_SHARE_ARGS_OFFSET)
IMAGE_SHARE_ARGS_UA_START            EQU    (DRAM_BASE_UA_START+IMAGE_SHARE_ARGS_OFFSET)
IMAGE_SHARE_ARGS_PA_UPDATEMODE       EQU    (IMAGE_SHARE_ARGS_PA_START+IMAGE_SHARE_ARGS_UPDATEMODE_OFFSET)
IMAGE_SHARE_ARGS_PA_ULDRREBOOT       EQU    (IMAGE_SHARE_ARGS_PA_START+IMAGE_SHARE_ARGS_ULDRREBOOT_OFFSET)
IMAGE_SHARE_ARGS_SIZE                EQU    (0x00001000)

;------------------------------------------------------------------------------
; MMU Page Table
;------------------------------------------------------------------------------
PT_1ST_OFFSET             EQU         (0x00004000)
PT_1ST_BASE               EQU         (DRAM_BASE_PA_START+PT_1ST_OFFSET) ; 1st level page table address (PHYBASE + 0x4000)
PT_1ST_ENTRY_CNB          EQU         (DRAM_BASE_PA_START+0x0000040E)
PT_1ST_ENTRY_NCNB         EQU         (DRAM_BASE_PA_START+0x00000402)
PTR_1ST_PTE	              EQU         ((DRAM_BASE_PA_START>>16)/4)
BANK_SHIFT                EQU         20

;------------------------------------------------------------------------------
; Stack
;------------------------------------------------------------------------------
TOP_OF_STACKS_PHYSICAL    EQU    (DRAM_BASE_PA_START+0x00008000)    ; Stack Top is in front of NK Image
TOP_OF_STACKS_VIRTUAL     EQU    (DRAM_BASE_CA_START+0x00008000)

; Stack Size of Each Mode : total 64KB
FIQStackSize              EQU     0x00000100
IRQStackSize              EQU     0x00000100
AbortStackSize            EQU     0x00000100
UndefStackSize            EQU     0x00000100
SVCStackSize              EQU     0x0000FB00
UserStackSize             EQU     0x00000100
StackTotalSize            EQU     0x00010000

; Stack Location of Each Mode (in Physical Address)
FIQStack_PA               EQU    (TOP_OF_STACKS_PHYSICAL + StackTotalSize)
IRQStack_PA               EQU    (FIQStack_PA - FIQStackSize)
AbortStack_PA             EQU    (IRQStack_PA - IRQStackSize)
UndefStack_PA             EQU    (AbortStack_PA - AbortStackSize)
SVCStack_PA               EQU    (UndefStack_PA - UndefStackSize)
UserStack_PA              EQU    (SVCStack_PA - SVCStackSize)

; Stack Location of Each Mode (in Physical Address)
FIQStack_VA               EQU    (TOP_OF_STACKS_VIRTUAL + StackTotalSize)
IRQStack_VA               EQU    (FIQStack_VA - FIQStackSize)
AbortStack_VA             EQU    (IRQStack_VA - IRQStackSize)
UndefStack_VA             EQU    (AbortStack_VA - AbortStackSize)
SVCStack_VA               EQU    (UndefStack_VA - UndefStackSize)
UserStack_VA              EQU    (SVCStack_VA - SVCStackSize)

;------------------------------------------------------------------------------
;    Sleep Data Layout
;------------------------------------------------------------------------------
WORD_SIZE   EQU    (4)
SleepState_Data_Start     EQU    (0)
SleepState_WakeAddr       EQU    (SleepState_Data_Start)
SleepState_SYSCTL         EQU    (SleepState_WakeAddr   + WORD_SIZE )
SleepState_MMUTTB0        EQU    (SleepState_SYSCTL     + WORD_SIZE )
SleepState_MMUTTB1        EQU    (SleepState_MMUTTB0    + WORD_SIZE )
SleepState_MMUTTBCTL      EQU    (SleepState_MMUTTB1    + WORD_SIZE )
SleepState_MMUDOMAIN      EQU    (SleepState_MMUTTBCTL  + WORD_SIZE )
SleepState_SVC_SP         EQU    (SleepState_MMUDOMAIN  + WORD_SIZE )
SleepState_SVC_SPSR       EQU    (SleepState_SVC_SP     + WORD_SIZE )
SleepState_FIQ_SPSR       EQU    (SleepState_SVC_SPSR   + WORD_SIZE )
SleepState_FIQ_R8         EQU    (SleepState_FIQ_SPSR   + WORD_SIZE )
SleepState_FIQ_R9         EQU    (SleepState_FIQ_R8     + WORD_SIZE )
SleepState_FIQ_R10        EQU    (SleepState_FIQ_R9     + WORD_SIZE )
SleepState_FIQ_R11        EQU    (SleepState_FIQ_R10    + WORD_SIZE )
SleepState_FIQ_R12        EQU    (SleepState_FIQ_R11    + WORD_SIZE )
SleepState_FIQ_SP         EQU    (SleepState_FIQ_R12    + WORD_SIZE )
SleepState_FIQ_LR         EQU    (SleepState_FIQ_SP     + WORD_SIZE )
SleepState_ABT_SPSR       EQU    (SleepState_FIQ_LR     + WORD_SIZE )
SleepState_ABT_SP         EQU    (SleepState_ABT_SPSR   + WORD_SIZE )
SleepState_ABT_LR         EQU    (SleepState_ABT_SP     + WORD_SIZE )
SleepState_IRQ_SPSR       EQU    (SleepState_ABT_LR     + WORD_SIZE )
SleepState_IRQ_SP         EQU    (SleepState_IRQ_SPSR   + WORD_SIZE )
SleepState_IRQ_LR         EQU    (SleepState_IRQ_SP     + WORD_SIZE )
SleepState_UND_SPSR       EQU    (SleepState_IRQ_LR     + WORD_SIZE )
SleepState_UND_SP         EQU    (SleepState_UND_SPSR   + WORD_SIZE )
SleepState_UND_LR         EQU    (SleepState_UND_SP     + WORD_SIZE )
SleepState_SYS_SP         EQU    (SleepState_UND_LR     + WORD_SIZE )
SleepState_SYS_LR         EQU    (SleepState_SYS_SP     + WORD_SIZE )
SleepState_Data_End       EQU    (SleepState_SYS_LR     + WORD_SIZE )
SLEEPDATA_SIZE            EQU    ((SleepState_Data_End - SleepState_Data_Start) / 4)

;------------------------------------------------------------------------------
;    Deep Idle Data Layout(same as Sleep data layout because of sharing region
;------------------------------------------------------------------------------
DeepIdleState_Data_Start     EQU    (0)
DeepIdleState_WakeAddr       EQU    (DeepIdleState_Data_Start)
DeepIdleState_SYSCTL         EQU    (DeepIdleState_WakeAddr   + WORD_SIZE )
DeepIdleState_MMUTTB0        EQU    (DeepIdleState_SYSCTL     + WORD_SIZE )
DeepIdleState_MMUTTB1        EQU    (DeepIdleState_MMUTTB0    + WORD_SIZE )
DeepIdleState_MMUTTBCTL      EQU    (DeepIdleState_MMUTTB1    + WORD_SIZE )
DeepIdleState_MMUDOMAIN      EQU    (DeepIdleState_MMUTTBCTL  + WORD_SIZE )
DeepIdleState_SVC_SP         EQU    (DeepIdleState_MMUDOMAIN  + WORD_SIZE )
DeepIdleState_SVC_SPSR       EQU    (DeepIdleState_SVC_SP     + WORD_SIZE )
DeepIdleState_FIQ_SPSR       EQU    (DeepIdleState_SVC_SPSR   + WORD_SIZE )
DeepIdleState_FIQ_R8         EQU    (DeepIdleState_FIQ_SPSR   + WORD_SIZE )
DeepIdleState_FIQ_R9         EQU    (DeepIdleState_FIQ_R8     + WORD_SIZE )
DeepIdleState_FIQ_R10        EQU    (DeepIdleState_FIQ_R9     + WORD_SIZE )
DeepIdleState_FIQ_R11        EQU    (DeepIdleState_FIQ_R10    + WORD_SIZE )
DeepIdleState_FIQ_R12        EQU    (DeepIdleState_FIQ_R11    + WORD_SIZE )
DeepIdleState_FIQ_SP         EQU    (DeepIdleState_FIQ_R12    + WORD_SIZE )
DeepIdleState_FIQ_LR         EQU    (DeepIdleState_FIQ_SP     + WORD_SIZE )
DeepIdleState_ABT_SPSR       EQU    (DeepIdleState_FIQ_LR     + WORD_SIZE )
DeepIdleState_ABT_SP         EQU    (DeepIdleState_ABT_SPSR   + WORD_SIZE )
DeepIdleState_ABT_LR         EQU    (DeepIdleState_ABT_SP     + WORD_SIZE )
DeepIdleState_IRQ_SPSR       EQU    (DeepIdleState_ABT_LR     + WORD_SIZE )
DeepIdleState_IRQ_SP         EQU    (DeepIdleState_IRQ_SPSR   + WORD_SIZE )
DeepIdleState_IRQ_LR         EQU    (DeepIdleState_IRQ_SP     + WORD_SIZE )
DeepIdleState_UND_SPSR       EQU    (DeepIdleState_IRQ_LR     + WORD_SIZE )
DeepIdleState_UND_SP         EQU    (DeepIdleState_UND_SPSR   + WORD_SIZE )
DeepIdleState_UND_LR         EQU    (DeepIdleState_UND_SP     + WORD_SIZE )
DeepIdleState_SYS_SP         EQU    (DeepIdleState_UND_LR     + WORD_SIZE )
DeepIdleState_SYS_LR         EQU    (DeepIdleState_SYS_SP     + WORD_SIZE )
DeepIdleState_Data_End       EQU    (DeepIdleState_SYS_LR     + WORD_SIZE )
DEEPIDLEDATA_SIZE            EQU    ((DeepIdleState_Data_End - DeepIdleState_Data_Start) / 4)
;//------------------------------------------------------------------------------

    END

