//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this sample source code is subject to the terms of the Microsoft
// license agreement under which you licensed this sample source code. If
// you did not accept the terms of the license agreement, you are not
// authorized to use this sample source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the LICENSE.RTF on your install media or the root of your tools installation.
// THE SAMPLE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES.
//
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
// PARTICULAR PURPOSE.
// 
// Module Name:  
//     COhcd.hpp
// 
// Abstract:  COhcd implements the HCDI interface. It mostly
//            just passes requests on to other objects, which
//            do the real work.
//     
// Notes: 
//
#ifndef __COHCD_HPP__
#define __COHCD_HPP__

//#include <new>
#include <globals.hpp>

class COhcd;
#include "Chw.hpp"
#include "CDevice.hpp"
#include "CPipe.hpp"


// this class gets passed into the COhcd Initialize routine
class CPhysMem;
// this class is our access point to all USB devices
//class CRootHub;

class COhcd : public CHW, public CHCCAera
{
public:
    // ****************************************************
    // Public Functions for COhcd
    // ****************************************************
    COhcd( IN LPVOID pvOhcdPddObject,
                     IN CPhysMem * pCPhysMem,
                     IN LPCWSTR szDriverRegistryKey,
                     IN REGISTER portBase,
                     IN DWORD dwSysIntr);

    ~COhcd();

    // These functions are called by the HCDI interface
    virtual BOOL DeviceInitialize(void);
    virtual void DeviceDeInitialize( void );
    virtual void SignalCheckForDoneTransfers( DWORD paDoneHead ) { CHCCAera::SignalCheckForDoneTransfers(paDoneHead); };
       
    // ****************************************************
    // Public Variables for COhcd
    // ****************************************************

    // no public variables

private:
    // ****************************************************
    // Private Functions for COhcd
    // ****************************************************

    // ****************************************************
    // Private Variables for COhcd
    // ****************************************************
                                            // the built-in hardware USB ports
    DWORD           m_dwSysIntr;
    REGISTER        m_portBase;
};

#endif // __COHCD_HPP__

