//
// Copyright  2009 Samsung Electronics Co; Ltd. All Rights Reserved.
//
//
//
//------------------------------------------------------------------------------
//
//  Header: tvout_stda_interrupt.h
//
//  Defines macros, structures, pre-defined functions, and etc for the tvout interrupt.
//
#ifndef __STDA_INTERRUPT_H
#define __STDA_INTERRUPT_H

#if __cplusplus
	extern "C"
	{
#endif

/*============================================================================*/
// Pre-defined functions
/*============================================================================*/

// initialization
//  - iniization functions are only called under stopping tvout interrupt
//BOOL STDA_interrupt_initialize_register_address(void *pGpioReg);
BOOL STDA_interrupt_initialize_interrupt(void);
void STDA_interrupt_deinitialize_interrupt(void);
BOOL STDA_interrupt_initialize_thread(void);
void STDA_interrupt_deinitialize_thread(void);


// set
//  - set functions are only called under running tvout interrupt

// etc
//  -
DWORD STDA_interrupt_vmixer_intr_thread(void);
DWORD STDA_interrupt_sdout_intr_thread(void);
DWORD STDA_interrupt_hdmi_Intr_thread(void);
DWORD STDA_interrupt_hpd_Intr_thread(void);
DWORD STDA_interrupt_hdmi_i2c_Intr_thread(void);
DWORD STDA_interrupt_wait_vmixer_cmd_done(void);
DWORD STDA_interrupt_wait_sdout_cmd_done(void);
DWORD STDA_interrupt_wait_hdmi_cmd_done(void);
DWORD STDA_interrupt_wait_hpd_cmd_done(DWORD dwWaitTime);
DWORD STDA_interrupt_wait_hpdVP_cmd_done(DWORD dwWaitTime);
DWORD STDA_interrupt_wait_hpdGRP0_cmd_done(DWORD dwWaitTime);
DWORD STDA_interrupt_wait_hpdGRP1_cmd_done(DWORD dwWaitTime);
DWORD STDA_interrupt_wait_hdmi_i2c_cmd_done(void);


// start
//  - start functions are only called under stopping tvout interrupt


// stop
//  - stop functions are only called under running tvout interrupt


// interrupt
//  - for debug

/*============================================================================*/



#if __cplusplus
	}
#endif

#endif    // __STDA_INTERRUPT_H
