//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
//
//
//------------------------------------------------------------------------------
//
//  Header: stda_context.h
//
//  Defines macros, structures, pre-defined functions, and etc for the STDA.
//
#ifndef __STDA_CONTEXT_H
#define __STDA_CONTEXT_H

#if __cplusplus
	extern "C"
	{
#endif

#define USE_VMIXER_INTERRUPT		TRUE
#define USE_SDOUT_INTERRUPT		FALSE
#define USE_HDMI_INTERRUPT			TRUE
#define USE_VMIXER_VSYNC_INTERRUPT		FALSE

/*============================================================================*/
// Pre-defined functions
/*============================================================================*/

/*============================================================================*/
// STDA context functions
/*============================================================================*/


BOOL STDA_initialize_tvout_engine(void);
void STDA_deinitialize_tvout_engine(void);
void STDA_initialize_context(void);
void STDA_deinitialize_context(void);
STDAContext* STDA_get_context(void);
STDAPowerContext* STDA_get_power_context(void);
BOOL STDA_map_device_address(void);
void STDA_unmap_device_address(void);
DWORD STDA_get_api_function_code(DWORD dwCode);
DWORD STDA_get_driver_signature(void);
DWORD STDA_add_open_context(void);
BOOL STDA_remove_open_context(DWORD dwOpenContext);
DWORD STDA_get_current_open_count(void);


/*============================================================================*/
// STDA power context functions
/*============================================================================*/

void STDA_initialize_power_context(void);
void STDA_deinitialize_power_context(void);
BOOL STDA_tvout_sleep(void);
BOOL STDA_tvout_wakeup(void);

/*============================================================================*/



#if __cplusplus
	}
#endif

#endif    // __STDA_CONTEXT_H
