//
// Copyright  2009 Samsung Electronics Co; Ltd. All Rights Reserved.
//
//
//
//------------------------------------------------------------------------------
//
//  Header: tvout_power_internal.h
//
//  Defines macros, structures, pre-defined functions, and etc for the TVout power.
//
#ifndef __TVOUT_POWER_INTERNAL_H
#define __TVOUT_POWER_INTERNAL_H

#if __cplusplus
	extern "C"
	{
#endif

#define USE_POWERCON_FUNCTION

// NORMAL_CFG
#define TVPWR_SUBSYSTEM_ACTIVE (1<<4)
#define TVPWR_SUBSYSTEM_LP     (0<<4)

// MTC_STABLE
#define TVPWR_MTC_COUNTER_CLEAR(a) (((~0xf)<<16)&a)
#define TVPWR_MTC_COUNTER_SET(a)   ((0xf&a)<<16)

// BLK_PWR_STAT
#define TVPWR_TV_BLOCK_STATUS(a)    ((0x1<<4)&a)

// OTHERS
#define TVPWR_DAC_STATUS(a)   ((0x1<<26)&a)
#define TVPWR_DAC_ON    (1<<26)

//V210
//HDMI_CON
#define HDMI_CON_SET_DIV(a,b) ((a) & ~(0x3ff<<16) | (b)<<16)
#define HDMI_CON_SET_EN (1<<0)


// global variables
//static volatile PSYSCON_PM_REG g_pPwrConConfig = NULL; // PowerCon Register
static volatile PPMU_PM_REG g_pPmuPm = NULL;
static volatile PPMU_MISC_REG g_pPmuMisc = NULL;
static BOOL g_bDacPwrOn = FALSE; // DAC Power

#ifdef USE_POWERCON_FUNCTION
static HANDLE g_hPowerCon = NULL;
#endif

#if __cplusplus
	}
#endif

#endif    // __TVOUT_POWER_INTERNAL_H

