//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
//
//
//------------------------------------------------------------------------------
//
//  Header: tvout_internal.h
//
//  Defines macros, structures, API functions, and etc for the TVout Driver for using only internaly.
//
#ifndef __TVOUT_INTERNAL_H
#define __TVOUT_INTERNAL_H

#if __cplusplus
	extern "C"
	{
#endif

#include "tvd_api.h"

/*============================================================================*/
// enum
/*============================================================================*/

// common

typedef enum
{
	TVOUT_POL_ACTIVE_LOW,
	TVOUT_POL_ACTIVE_HIGH
}TVOUT_ACTIVE_POLARITY;

typedef enum
{
	TVOUT_YUV_Y,
	TVOUT_YUV_CB,
	TVOUT_YUV_CR
}TVOUT_YUV_FORMAT_COMPONENT;


// power



// clock

typedef enum
{
	TVOUT_CLK_HPLL_REF_27M,
	TVOUT_CLK_HPLL_REF_SRCLK
}TVOUT_CLK_HPLL_REF;

typedef enum
{
	TVOUT_CLK_MOUT_HPLL_27M,
	TVOUT_CLK_MOUT_HPLL_FOUT_HPLL
}TVOUT_CLK_MOUT_HPLL;

typedef enum
{
	TVOUT_CLK_VMIXER_SRCCLK_CLK27M,
	TVOUT_CLK_VMIXER_SRCCLK_VCLK_54,
	TVOUT_CLK_VMIXER_SRCCLK_MOUT_HPLL
}TVOUT_CLK_VMIEXR_SRCCLK;

typedef enum
{
	TVOUT_CLK_SRCCLK_VCLK_54,
	TVOUT_CLK_SRCCLK_HDMI_PHY
}TVOUT_CLK_SRCCLK;

typedef enum
{
	TVOUT_MIXER_CLK_SRCCLK_VCLK_54,
	TVOUT_MIXER_CLK_SRCCLK_HDMI_PHY
}TVOUT_MIXER_CLK_SRCCLK;


// video processor

#define TILE_WIDTH 0x40

typedef enum
{
	VPROC_SHARPNESS_NO     = 0,
	VPROC_SHARPNESS_MIN    = 1,
	VPROC_SHARPNESS_MOD    = 2,
	VPROC_SHARPNESS_MAX    = 3
}VPROC_SHARPNESS_CONTROL;

typedef enum
{
	VPROC_LINEAR_MODE,
	VPROC_2D_TILE_MODE
}VPROC_MEM_MODE;

typedef enum
{
	VPROC_USING_C_TOP,
	VPROC_USING_C_TOP_BOTTOM
}VPROC_CHROMA_EXPANSION;

typedef enum
{
	VPROC_FILED_ID_TOGGLE_USER,
	VPROC_FILED_ID_TOGGLE_VSYNC
}VPROC_FILED_ID_TOGGLE;

typedef enum
{
	VPROC_TOP_FIELD,
	VPROC_BOTTOM_FIELD
}VPROC_FIELD_ID;

typedef enum
{
	VPROC_POLY8_Y0_LL = 0,
	VPROC_POLY8_Y0_LH,
	VPROC_POLY8_Y0_HL,
	VPROC_POLY8_Y0_HH,
	VPROC_POLY8_Y1_LL,
	VPROC_POLY8_Y1_LH,
	VPROC_POLY8_Y1_HL,
	VPROC_POLY8_Y1_HH,
	VPROC_POLY8_Y2_LL,
	VPROC_POLY8_Y2_LH,
	VPROC_POLY8_Y2_HL,
	VPROC_POLY8_Y2_HH,
	VPROC_POLY8_Y3_LL,
	VPROC_POLY8_Y3_LH,
	VPROC_POLY8_Y3_HL,
	VPROC_POLY8_Y3_HH,
	VPROC_POLY4_Y0_LL = 32,
	VPROC_POLY4_Y0_LH,
	VPROC_POLY4_Y0_HL,
	VPROC_POLY4_Y0_HH,
	VPROC_POLY4_Y1_LL,
	VPROC_POLY4_Y1_LH,
	VPROC_POLY4_Y1_HL,
	VPROC_POLY4_Y1_HH,
	VPROC_POLY4_Y2_LL,
	VPROC_POLY4_Y2_LH,
	VPROC_POLY4_Y2_HL,
	VPROC_POLY4_Y2_HH,
	VPROC_POLY4_Y3_LL,
	VPROC_POLY4_Y3_LH,
	VPROC_POLY4_Y3_HL,
	VPROC_POLY4_Y3_HH,
	VPROC_POLY4_C0_LL,
	VPROC_POLY4_C0_LH,
	VPROC_POLY4_C0_HL,
	VPROC_POLY4_C0_HH,
	VPROC_POLY4_C1_LL,
	VPROC_POLY4_C1_LH,
	VPROC_POLY4_C1_HL,
	VPROC_POLY4_C1_HH
}VPROC_POLY_COEFFICIENT;

typedef enum
{
	VPROC_CSC_Y2Y_COEF = 0,
	VPROC_CSC_CB2Y_COEF,
	VPROC_CSC_CR2Y_COEF,
	VPROC_CSC_Y2CB_COEF,
	VPROC_CSC_CB2CB_COEF,
	VPROC_CSC_CR2CB_COEF,
	VPROC_CSC_Y2CR_COEF,
	VPROC_CSC_CB2CR_COEF,
	VPROC_CSC_CR2CR_COEF
}VPROC_CSC_COEFFICIENT;

typedef enum
{
	VPROC_CSC_SD_HD,
	VPROC_CSC_HD_SD
}VPROC_CSC_TYPE;

typedef enum
{
	/* Don't change the order and the value */
	VPROC_PP_H_NORMAL = 0,
	VPROC_PP_H_8_9,        /* 720 to 640 */
	VPROC_PP_H_1_2,
	VPROC_PP_H_1_3,
	VPROC_PP_H_1_4
}VPROC_FILTER_H_PP;

typedef enum
{
	/* Don't change the order and the value */
	VPROC_PP_V_NORMAL = 0,
	VPROC_PP_V_5_6,        /* PAL to NTSC */
	VPROC_PP_V_3_4,
	VPROC_PP_V_1_2,
	VPROC_PP_V_1_3,
	VPROC_PP_V_1_4
}VPROC_FILTER_V_PP;



// video mixer

typedef enum
{
	VM_BURST_8 =0,
	VM_BURST_16 = 1
}VMIXER_BURST_MODE;

typedef enum
{
	VMIXER_INTERLACED_MODE =0,
	VMIXER_PROGRESSIVE_MODE = 1
}VMIXER_SCAN_MODE;

typedef enum
{
	VM_VIDEO_LAYER = 2,
	VM_GPR0_LAYER = 0,
	VM_GPR1_LAYER = 1
}VMIXER_LAYER;

typedef enum
{
	VMIXER_BG_COLOR_0=0,
	VMIXER_BG_COLOR_1=1,
	VMIXER_BG_COLOR_2=2
}VMIXER_BG_COLOR_NUM;

typedef enum
{
	VMIXER_COEF_Y_NARROW = 0,
	VMIXER_COEF_Y_WIDE = 1
}VMIXER_COEF_Y_MODE;

typedef enum
{
	VMIXER_CSC_RGB_TO_YUV601_LR,
	VMIXER_CSC_RGB_TO_YUV601_FR,
	VMIXER_CSC_RGB_TO_YUV709_LR,
	VMIXER_CSC_RGB_TO_YUV709_FR
}VMIXER_CSC_TYPE;

typedef enum
{
	VMIXER_RGB601_0_255,
	VMIXER_RGB601_16_235,
	VMIXER_RGB706_0_255,
	VMIXER_RGB706_16_235
}VMIXER_RGB_FORMAT;

typedef enum
{
	VMIXER_YUV444,
	VMIXER_RGB888
}VMIXER_RGB_OUT_TYPE;


// TV encoder

typedef enum
{
	SDOUT_LEVEL_0IRE,
	SDOUT_LEVEL_75IRE
}SDOUT_LEVEL;

typedef enum
{
	SDOUT_VTOS_RATIO_10_4,
	SDOUT_VTOS_RATIO_7_3
}SDOUT_VIDEO_SYNC_RATIO;

typedef enum
{
	SDOUT_SYNC_SIG_NO,
	SDOUT_SYNC_SIG_YG,
	SDOUT_SYNC_SIG_ALL
}SDOUT_SYNC_SIG_PIN;

typedef enum
{
	SDOUT_NO_INS,
	SDOUT_INS_1,
	SDOUT_INS_2,
	SDOUT_INS_OTHERS
}SDOUT_CLOSED_CAPTION_INS;

typedef enum
{
	SDOUT_CHANNEL_0=0,
	SDOUT_CHANNEL_1=1,
	SDOUT_CHANNEL_2=2
}SDOUT_CHANNEL_SEL;

typedef enum
{
	SDOUT_VESA_RGB_SYNC_COMPOSITE,
	SDOUT_VESA_RGB_SYNC_SEPARATE
}SDOUT_VESA_RGB_SYNC_TYPE;

typedef enum
{
	SDO_525_COPY_PERMIT,
	SDO_525_ONECOPY_PERMIT,
	SDO_525_NOCOPY_PERMIT
}SDOUT_525_DATA_COPY_PERMIT_MODE;

typedef enum
{
	SDO_525_MV_PSP_OFF,
	SDO_525_MV_PSP_ON_2LINE_BURST,
	SDO_525_MV_PSP_ON_BURST_OFF,
	SDO_525_MV_PSP_ON_4LINE_BURST,
}SDOUT_525_DATA_MV_PSP_MODE;

typedef enum
{
	SDO_525_COPY_INFO,
	SDO_525_DEFAULT,
}SDOUT_525_DATA_COPY_INFO_MODE;

typedef enum
{
	SDO_525_4_3_NORMAL,
	SDO_525_16_9_ANAMORPIC,
	SDO_525_4_3_LETTERBOX
}SDOUT_525_DATA_DISPLAY_ASPECT_RATIO;

typedef enum
{
	SDO_625_NO_OPEN_SUBTITLES,
	SDO_625_INACT_OPEN_SUBTITLES,
	SDO_625_OUTACT_OPEN_SUBTITLES
}SDOUT_625_DATA_OPEN_SUBTITLES;

typedef enum
{
	SDO_625_CAMERA,
	SDO_625_FILM
}SDOUT_625_DATA_CAMERA_FILM_MODE;

typedef enum
{
	SDO_625_NORMAL_PAL,
	SDO_625_MOTION_ADAPTIVE_COLORPLUS
}SDOUT_625_DATA_COLOR_ENCODING;

typedef enum
{
	SDO_625_4_3_FULL_576,
	SDO_625_14_9_LETTERBOX_CENTER_504,
	SDO_625_14_9_LETTERBOX_TOP_504,
	SDO_625_16_9_LETTERBOX_CENTER_430,
	SDO_625_16_9_LETTERBOX_TOP_430,
	SDO_625_16_9_LETTERBOX_CENTER,
	SDO_625_14_9_FULL_CENTER_576,
	SDO_625_16_9_ANAMORPIC_576
}SDOUT_625_DATA_DISPLAY_ASPECT_RATIO;



// HDMI

typedef enum
{
	HDMI_CSC_YUV601_TO_RGB_LR,
	HDMI_CSC_YUV601_TO_RGB_FR,
	HDMI_CSC_YUV709_TO_RGB_LR,
	HDMI_CSC_YUV709_TO_RGB_FR,
	HDMI_CSC_YUV601_TO_YUV709,
	HDMI_CSC_RGB_FR_TO_RGB_LR,
	HDMI_CSC_RGB_FR_TO_YUV601,
	HDMI_CSC_RGB_FR_TO_YUV709,
	HDMI_BYPASS
}HDMI_CSC_TYPE;



// STDA




/*============================================================================*/
// structure
/*============================================================================*/



/*============================================================================*/
// Video Layer Data

typedef struct _STDA_ARG_VIDEO_OP_MODE
{
	BOOL bLineSkip;
	BOOL b2D_IPC;
	VPROC_MEM_MODE memMode;
	VPROC_CHROMA_EXPANSION chromaExp;
	VPROC_FILED_ID_TOGGLE toggleID;
}STDA_ARG_VIDEO_OP_MODE, *pSTDA_ARG_VIDEO_OP_MODE;

typedef struct _STDA_ARG_VIDEO_SHARPNESS
{
	unsigned int uiThHNoise;
	VPROC_SHARPNESS_CONTROL sharpness;
}STDA_ARG_VIDEO_SHARPNESS, *pSTDA_ARG_VIDEO_SHARPNESS;

typedef struct _STDA_ARG_VIDEO_CSC_CONTROL
{
	BOOL bSubYOffsetEn;
	BOOL bCscEn;
}STDA_ARG_VIDEO_CSC_CONTROL, *pSTDA_ARG_VIDEO_CSC_CONTROL;

typedef struct _STDA_ARG_VIDEO_POLY_FILTER_COEF
{
	VPROC_POLY_COEFFICIENT polyCoeff;
	signed char ch0;
	signed char ch1;
	signed char ch2;
	signed char ch3;
}STDA_ARG_VIDEO_POLY_FILTER_COEF, *pSTDA_ARG_VIDEO_POLY_FILTER_COEF;

typedef struct _STDA_ARG_VIDEO_CSC_COEF
{
	VPROC_CSC_COEFFICIENT cscCoeff;
	unsigned int uiCoeff;
}STDA_ARG_VIDEO_CSC_COEF, *PSTDA_ARG_VIDEO_CSC_COEF;



/*============================================================================*/
// GRP Layer Data



/*============================================================================*/
// Video Mixer Data

typedef struct _STDA_ARG_VM_CSC_COEF
{
	TVOUT_YUV_FORMAT_COMPONENT component;
	VMIXER_COEF_Y_MODE mode;
	unsigned int uiCoeff_0;
	unsigned int uiCoeff_1;
	unsigned int uiCoeff_2;
}STDA_ARG_VM_CSC_COEF, *pSTDA_ARG_VM_CSC_COEF;



/*============================================================================*/
// SDout Data

typedef struct _STDA_ARG_SDOUT_VIDEO_SCALE_CFG
{
	SDOUT_LEVEL componentLevel;
	SDOUT_VIDEO_SYNC_RATIO componentRatio;
	SDOUT_LEVEL compositeLevel;
	SDOUT_VIDEO_SYNC_RATIO compositeRatio;
}STDA_ARG_SDOUT_VIDEO_SCALE_CFG, *pSTDA_ARG_SDOUT_VIDEO_SCALE_CFG;

typedef struct _STDA_ARG_SDOUT_VBI
{
	BOOL bWssCVBS;
	SDOUT_CLOSED_CAPTION_INS captionCVBS;
	BOOL bWssYSideo;
	SDOUT_CLOSED_CAPTION_INS captionYSideo;
	BOOL bCgmsaRGB;
	BOOL bWssRGB;
	SDOUT_CLOSED_CAPTION_INS captionRGB;
	BOOL bCgmsaYPbPr;
	BOOL bWssYPbPr;
	SDOUT_CLOSED_CAPTION_INS captionYPbPr;
}STDA_ARG_SDOUT_VBI, *pSTDA_ARG_SDOUT_VBI;

typedef struct _STDA_ARG_SDOUT_OFFSET_GAIN
{
	SDOUT_CHANNEL_SEL channel;
	unsigned int uiOffset;
	unsigned int uiGain;
}STDA_ARG_SDOUT_OFFSET_GAIN, *pSTDA_ARG_SDOUT_OFFSET_GAIN;

typedef struct _STDA_ARG_SDOUT_DELAY
{
	unsigned int uiDelayY;
	unsigned int uiOffsetVideoStart;
	unsigned int uiOffsetVideoEnd;
}STDA_ARG_SDOUT_DELAY, *pSTDA_ARG_SDOUT_DELAY;

typedef struct _STDA_ARG_SDOUT_BRIGHTNESS_HUE_SATURATION
{
	BOOL bBriHueSatAdj;
	unsigned int uiGainBrightness;
	unsigned int uiOffsetBrightness;
	unsigned int uiGain0CbHueSaturation;
	unsigned int uiGain1CbHueSaturation;
	unsigned int uiGain0CrHueSaturation;
	unsigned int uiGain1CrHueSaturation;
	unsigned int uiOffsetCbHueSaturation;
	unsigned int uiOffsetCrHueSaturation;
}STDA_ARG_SDOUT_BRIGHTNESS_HUE_SATURATION, *pSTDA_ARG_SDOUT_BRIGHTNESS_HUE_SATURATION;

typedef struct _STDA_ARG_SDOUT_RGB_COLOR_COMPENSATON
{
	BOOL bRGBcolorCompensation;
	unsigned int uiMaxRGBCube;
	unsigned int uiMinRGBCube;
}STDA_ARG_SDOUT_RGB_COLOR_COMPENSATON, *pSTDA_ARG_SDOUT_RGB_COLOR_COMPENSATON;

typedef struct _STDA_ARG_SDOUT_CVBS_COLOR_COMPENSATON
{
	BOOL bCVBSCcolorCompensaton;
	unsigned int uiYLowerMid;
	unsigned int uiYBottom;
	unsigned int uiYTop;
	unsigned int uiYUpperMid;
	unsigned int uiRadius;
}STDA_ARG_SDOUT_CVBS_COLOR_COMPENSATON, *pSTDA_ARG_SDOUT_CVBS_COLOR_COMPENSATON;

typedef struct _STDA_ARG_SDOUT_SVIDEO_COLOR_COMPENSATON
{
	BOOL bYCcolorCompensaton;
	unsigned int uiYTop;
	unsigned int uiYBottom;
	unsigned int uiYCCylinder;
}STDA_ARG_SDOUT_SVIDEO_COLOR_COMPENSATON, *pSTDA_ARG_SDOUT_SVIDEO_COLOR_COMPENSATON;

typedef struct _STDA_ARG_SDOUT_COMPONENT_PORCH
{
	unsigned int ui525Back;
	unsigned int ui525Front;
	unsigned int ui625Back;
	unsigned int ui625Front;
}STDA_ARG_SDOUT_COMPONENT_PORCH, *pSTDA_ARG_SDOUT_COMPONENT_PORCH;

typedef struct _STDA_ARG_SDOUT_VESA_RGB_SYNC
{
	SDOUT_VESA_RGB_SYNC_TYPE syncType;
	TVOUT_ACTIVE_POLARITY vsyncActive;
	TVOUT_ACTIVE_POLARITY hsyncActive;
}STDA_ARG_SDOUT_VESA_RGB_SYNC, *pSTDA_ARG_SDOUT_VESA_RGB_SYNC;

typedef struct _STDA_ARG_SDOUT_CHANNEL_XTALK_CANCELLATION_COEFF
{
	SDOUT_CHANNEL_SEL channel;
	unsigned int uiCoeff2;
	unsigned int uiCoeff1;
}STDA_ARG_SDOUT_CHANNEL_XTALK_CANCELLATION_COEFF, *pSTDA_ARG_SDOUT_CHANNEL_XTALK_CANCELLATION_COEFF;

typedef struct _STDA_ARG_SDOUT_CLOSED_CAPTION
{
	unsigned int uiDisplayCC;
	unsigned int uiNonDisplayCC;
}STDA_ARG_SDOUT_CLOSED_CAPTION, *pSTDA_ARG_SDOUT_CLOSED_CAPTION;

typedef struct _STDA_ARG_SDOUT_525_DATA
{
	SDOUT_525_DATA_COPY_PERMIT_MODE copyPermit;
	SDOUT_525_DATA_MV_PSP_MODE mvPsp;
	SDOUT_525_DATA_COPY_INFO_MODE copyInfo;
	BOOL bAnalogOn;
	SDOUT_525_DATA_DISPLAY_ASPECT_RATIO displayRatio;
}STDA_ARG_SDOUT_525_DATA, *pSTDA_ARG_SDOUT_525_DATA;

typedef struct _STDA_ARG_SDOUT_625_DATA
{
	BOOL bSurrounfSound;
	BOOL bCopyright;
	BOOL bCopyProtection;
	BOOL bTextSubtitles;
	SDOUT_625_DATA_OPEN_SUBTITLES openSubtitles;
	SDOUT_625_DATA_CAMERA_FILM_MODE cameraFilm;
	SDOUT_625_DATA_COLOR_ENCODING colorEncoding;
	BOOL bHelperSignal;
	SDOUT_625_DATA_DISPLAY_ASPECT_RATIO displayRatio;
}STDA_ARG_SDOUT_625_DATA, *pSTDA_ARG_SDOUT_625_DATA;



/*============================================================================*/
// HDMI video Data

typedef struct _STDA_ARG_HDMI_VIDEO_BLUESCREEN
{
	BOOL bEn;
	unsigned char ucCbB;
	unsigned char ucYG;
	unsigned char ucCrR;
}STDA_ARG_HDMI_VIDEO_BLUESCREEN, *pSTDA_ARG_HDMI_VIDEO_BLUESCREEN;

typedef struct _STDA_ARG_HDMI_COLOR_RANGE
{
	unsigned char ucYMin;
	unsigned char ucYMax;
	unsigned char ucCMin;
	unsigned char ucCMax;
}STDA_ARG_HDMI_COLOR_RANGE, *pSTDA_ARG_HDMI_COLOR_RANGE;

typedef struct _STDA_ARG_HDMI_VIDEO_INFOFRAME
{
	HDMI_TRANSMIT_TYPE transType;
	unsigned char ucCheckSum;
	unsigned char *pucData;
}STDA_ARG_HDMI_VIDEO_INFOFRAME, *pSTDA_ARG_HDMI_VIDEO_INFOFRAME;

typedef struct _STDA_ARG_HDMI_TG_CMD
{
	BOOL bTimingCorrectionEn;
	BOOL bBT656SyncEn;
	BOOL bTgEn;
}STDA_ARG_HDMI_TG_CMD, *pSTDA_ARG_HDMI_TG_CMD;



/*============================================================================*/
// HDMI Data


#if __cplusplus
	}
#endif

#endif    // __TVOUT_INTERNAL_H



