//
// Copyright  2009 Samsung Electronics Co; Ltd. All Rights Reserved.
//
//
//
//------------------------------------------------------------------------------
//
//  Header: tvout_clock.h
//
//  Defines macros, structures, pre-defined functions, and etc for the Video Mixer.
//
#ifndef __TVOUT_CLOCK_H
#define __TVOUT_CLOCK_H

#if __cplusplus
	extern "C"
	{
#endif

#include "tvout_internal.h"


/*============================================================================*/
// Pre-defined functions
/*============================================================================*/

// initialization
//  - iniization functions are only called under stopping tvout clock
TVOUT_CLK_ERROR Tvout_clk_initialize_register_address(void * pCmuClkCon, void* pCmuMiscCon);

TVOUT_CLK_ERROR Tvout_clk_set_clk_src_onoff(TVOUT_CLK_SRCCLK srcClk, BOOL bEn);
void Tvout_clk_set_clk_mask_onoff(BOOL bEn);

void Tvout_clk_initialize_vpll(unsigned int uiLockTime,
                                unsigned int uiMdiv,
                                unsigned int uiPdiv,
                                unsigned int uiSdiv);
void Tvout_clk_vpll_onoff(BOOL bEn);
TVOUT_CLK_ERROR Tvout_clk_initialize_href(TVOUT_CLK_HPLL_REF hpllRef);
TVOUT_CLK_ERROR Tvout_clk_initialize_mout_hpll(TVOUT_CLK_MOUT_HPLL moutHpll);
TVOUT_CLK_ERROR Tvout_clk_initialize_video_mixer(TVOUT_CLK_VMIEXR_SRCCLK srcClk);
void Tvout_clk_initialize_hdmi_ratio(unsigned int uiClkDiv);

TVOUT_CLK_ERROR Tvout_clk_set_clk_src_init();
TVOUT_CLK_ERROR Tvout_clk_set_mixer_src(TVOUT_MIXER_CLK_SRCCLK srcClk);



// set
//  - set functions are only called under running tvout clock
void Tvout_clk_set_vp_clk_onoff(BOOL bClkOn);

void Tvout_clk_set_vmixer_clk_onoff(BOOL bClkOn);

void Tvout_clk_set_tvenc_clk_onoff(BOOL bClkOn);

void Tvout_clk_set_tvblock_on_off(BOOL bClkOn);

void Tvout_clk_set_hdmi_clk_onoff(BOOL bClkOn);
void Tvout_clk_set_ddc_clk_onoff(BOOL bClkOn);
void TVout_clk_set_hdmi_i2c_phy_clk_onoff(BOOL bClkOn);
void TVout_clk_set_hdmi_phy_con_onoff();

void Tvout_clk_set_hdmi_hclk_onoff(BOOL bClkOn);
void Tvout_clk_set_hdmi_sclk_onoff(BOOL bClkOn);

void Tvout_clk_set_hdmi_i2c_clk_onoff(BOOL bClkOn);

void Tvout_clk_print();

// etc
//  -


// start
//  - start functions are only called under stopping tvout clock
void Tvout_clk_start(BOOL bVideoProcessorHclkOn,BOOL bSDoutHclkOn,BOOL bHDMIHclkOn);


// stop
//  - stop functions are only called under running tvout clock
void Tvout_clk_stop(void);


/*============================================================================*/


#if __cplusplus
	}
#endif

#endif    // __TVOUT_CLOCK_H
