//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header: hdmi_video.h
//
//  Defines macros, structures, pre-defined functions, and etc for the HDMI VIDEO.
//
#ifndef __HDMI_VIDEO_H
#define __HDMI_VIDEO_H

#if __cplusplus
    extern "C"
    {
#endif

#include "tvout_internal.h"

/*============================================================================*/
// Pre-defined functions
/*============================================================================*/

// initialization
//  - iniization functions are only called under stopping HDMI
HDMI_ERROR HDMI_video_initialize_register_address(void *pHDMISSReg,
                            void *pHDMICoreReg,
                             void *pHDMITGReg);

HDMI_ERROR HDMI_video_initialize_display_mode(TVOUT_DISPLAY_MODE dispMode,
                                                TVOUT_OUTPUT_MODE outMode);
void HDMI_video_initialize_bluescreen(BOOL bEn, unsigned char ucCbB,
                                      unsigned char ucYG, unsigned char ucCrR);
void HDMI_video_initialize_color_range(unsigned char ucYMin,
                                       unsigned char ucYMax,
                                       unsigned char ucCMin,
                                       unsigned char ucCMax);
HDMI_ERROR HDMI_video_initialize_csc(HDMI_CSC_TYPE cscType);
HDMI_ERROR HDMI_video_initialize_avi_infoframe(HDMI_TRANSMIT_TYPE transType,
                                               unsigned char ucCheckSum,
                                               unsigned char *pucAviData);
HDMI_ERROR HDMI_video_initialize_mpg_infoframe(HDMI_TRANSMIT_TYPE transType,
                                               unsigned char ucCheckSum,
                                               unsigned char *pucMpgData);
void HDMI_video_initialize_tg_cmd(BOOL bTimingCorrectionEn,
                                  BOOL bBT656SyncEn,
                                  TVOUT_DISPLAY_MODE dispMode,
                                  BOOL bTgEn);


// set
//  - set functions are only called under running HDMI
void HDMI_video_set_bluescreen(BOOL bEn, unsigned char ucCbB,
                                    unsigned char ucYG, unsigned char ucCrR);



// etc
//  -


// start
//  - start functions are only called under stopping HDMI
//void HDMI_video_start(void);


// stop
//  - stop functions are only called under running HDMI
//void HDMI_video_stop(void);


// reset
//  - reset function


// interrupt
//  -


/*============================================================================*/

#if __cplusplus
    }
#endif

#endif    // __HDMI_VIDEO_H


