//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
//------------------------------------------------------------------------------
//
//  Header: hdmi.h
//
//  Defines macros, structures, pre-defined functions, and etc for the HDMI.
//
#ifndef __HDMI_H
#define __HDMI_H

#if __cplusplus
    extern "C"
    {
#endif

#include "tvout_internal.h"
#include <video.h>
#include <audio.h>

/*============================================================================*/
// Pre-defined functions
/*============================================================================*/

// initialization
//  - iniization functions are only called under stopping HDMI
HDMI_ERROR HDMI_initialize_register_address
                            (void *pHDMISSReg,
                            void *pHDMICoreReg,
                            void *pHDCPReg,
                            void *pGPIOReg,
                            void *pSysConReg,
                            void *pIICReg,
                            void *pTGReg);

//void PhyCon(int mode);
//void PhyCon(int mode, ColorDepth ColorDep);
void HDMI_TG_Setting(int mode);
void HDMI_TG_OnOff(BOOL bOn);

#ifdef HDMI_HW_TEST
void HDMI_mixer_test(int mode);
#endif

/*
HDMI_ERROR HDMI_initialize_spd_infoframe(HDMI_TRANSMIT_TYPE transType,
                                         unsigned char *pucSpdHeader,
                                         unsigned char *pucSpdData);
void HDMI_initialize_hpd_onoff(BOOL bOnOff);
void HDMI_set_hpd_onoff(BOOL bOnOff);

BOOL HDMI_start(HDMI_AUDIO_TYPE hdmiAudioType, BOOL bHDCPEn, TVOUT_OUTPUT_MODE outMode);
void HDMI_stop(void);
void HDMI_Enable(BOOL bEn);
*/



#if __cplusplus
    }
#endif

#endif    // __HDMI_H


