//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:    hdcp.h

Abstract:       Implementation of HDCP Library
                This header file belongs to HDCP module implementing HDCP spec 1.1

Notes:

--*/
#ifndef __HDCP_H__
#define __HDCP_H__
#include <tvd_api.h>

BOOL HDCP_initialize_register_address(void *pHDMIReg, void *pHDCPReg, void *pHAESReg);
BOOL StartHdcp(TVOUT_OUTPUT_MODE outMode);
BOOL HandleEventForHdcp(unsigned int **puiWaitTime);
BOOL StopHdcp(void);

#undef  HDCP_IIC_MDD_DRV
#define HDCP_IIC_MDD_DRV  0
#undef  HDCP_IIC_MDD_FUNCTION
#define HDCP_IIC_MDD_FUNCTION  0
#undef  HDCP_IIC_MDD_ERROR
#define HDCP_IIC_MDD_ERROR  1
#undef  HDCP_IIC_PDD_DRV
#define HDCP_IIC_PDD_DRV  0
#undef  HDCP_IIC_PDD_FUNCTION
#define HDCP_IIC_PDD_FUNCTION  0
#undef  HDCP_IIC_PDD_ERROR
#define HDCP_IIC_PDD_ERROR  1
#endif

