//
// Copyright (c) Samsung Electronics Corporation.  All rights reserved.
//

//------------------------------------------------------------------------------
//
//  Header: hdmi_macro.h
//
//  Defines macros for the HDMI.
//

#ifndef __HDMI_MACRO_H
#define __HDMI_MACRO_H

#if __cplusplus
    extern "C"
    {
#endif

// HDMI_CON0
#define BLUE_SCR_EN     (1<<5)
#define BLUE_SCR_DIS    (0<<5)
#define ASP_EN          (1<<2)
#define ASP_DIS         (0<<2)
#define PWDN_ENB_NORMAL (1<<1)
#define PWDN_ENB_PD     (0<<1)
#define HDMI_EN         (1)
#define HDMI_DIS        (0)

// HDMI_CON1
#define PX_LMT_CTRL_BYPASS      (0<<5)
#define PX_LMT_CTRL_RGB         (1<<5)
#define PX_LMT_CTRL_YPBPR       (2<<5)
#define PX_LMT_CTRL_RESERVED    (3<<5)

// HDMI_CON2
#define VID_PREAMBLE_EN   (0<<5)
#define VID_PREAMBLE_DIS  (1<<5)
#define GUARD_BAND_EN     (0<<1)
#define GUARD_BAND_DIS    (1<<1)

// HDMI_SIM_MODE

// HDMI_STATUS
#define AUTHEN_ACK_AUTH         (1<<7)
#define AUTHEN_ACK_NOT          (0<<7)
#define AUD_FIFO_OVF_FULL       (1<<6)
#define AUD_FIFO_OVF_NOT        (0<<6)
#define UPDATE_RI_INT_OCC       (1<<4)
#define UPDATE_RI_INT_NOT       (0<<4)
#define UPDATE_RI_INT_CLEAR     (1<<4)
#define UPDATE_PJ_INT_OCC       (1<<3)
#define UPDATE_PJ_INT_NOT       (0<<3)
#define UPDATE_PJ_INT_CLEAR     (1<<3)
#define EXCHANGEKSV_INT_OCC     (1<<2)
#define EXCHANGEKSV_INT_NOT     (0<<2)
#define EXCHANGEKSV_INT_CLEAR   (1<<2)
#define WATCHDOG_INT_OCC        (1<<1)
#define WATCHDOG_INT_NOT        (0<<1)
#define WATCHDOG_INT_CLEAR      (1<<1)
#define WTFORACTIVERX_INT_OCC   (1)
#define WTFORACTIVERX_INT_NOT   (0)
#define WTFORACTIVERX_INT_CLEAR (1)

// HDMI_STATUS_EN
#define AUD_FIFO_OVF_EN         (1<<6)
#define AUD_FIFO_OVF_DIS        (0<<6)
#define UPDATE_RI_INT_EN        (1<<4)
#define UPDATE_RI_INT_DIS       (0<<4)
#define UPDATE_PJ_INT_EN        (1<<3)
#define UPDATE_PJ_INT_DIS       (0<<3)
#define EXCHANGEKSV_INT_EN      (1<<2)
#define EXCHANGEKSV_INT_DIS     (0<<2)
#define WATCHDOG_INT_EN         (1<<1)
#define WATCHDOG_INT_DIS        (0<<1)
#define WTFORACTIVERX_INT_EN    (1)
#define WTFORACTIVERX_INT_DIS   (0)

// HDMI_HPD
#define SW_HPD_PLUGGED      (1<<1)
#define SW_HPD_UNPLUGGED    (0<<1)

// HDMI_MODE_SEL
#define HDMI_MODE_EN    (1<<1)
#define HDMI_MODE_DIS   (0<<1)
#define DVI_MODE_EN     (1)
#define DVI_MODE_DIS    (0)

// HDCP_ENC_EN
#define HDCP_ENC_ENABLE     (1)
#define HDCP_ENC_DISABLE    (0)

// HDMI_BLUE_SCREEN0
#define SET_BLUESCREEN_0(a) (0xff&(a))

// HDMI_BLUE_SCREEN1
#define SET_BLUESCREEN_1(a) (0xff&(a))

// HDMI_BLUE_SCREEN2
#define SET_BLUESCREEN_2(a) (0xff&(a))

// HDMI_YMAX
#define SET_HDMI_YMAX(a)    (0xff&(a))

// HDMI_YMIN
#define SET_HDMI_YMIN(a)    (0xff&(a))

// HDMI_CMAX
#define SET_HDMI_CMAX(a)    (0xff&(a))

// HDMI_CMIN
#define SET_HDMI_CMIN(a)    (0xff&(a))

// HDMI_DI_PREFIX

// HDMI_VBI_ST_MG
#define SET_VBI_ST_MG(a)    (0xff&(a))

// HDMI_VBI_END_MG
#define SET_VBI_END_MG(a)   (0xff&(a))

// HDMI_VACT_ST_MG
#define SET_VACT_ST_MG(a)   (0xff&(a))

// HDMI_VACT_END_MG
// HDMI_AUTH_ST_MG0
// HDMI_AUTH_ST_MG1
// HDMI_AUTH_END_MG0
// HDMI_AUTH_END_MG1

// HDMI_H_BLANK0
#define SET_H_BLANK_L(a)    (0xff&(a))

// HDMI_H_BLANK1
#define SET_H_BLANK_H(a)    (0x7&((a)>>8))

// HDMI_V_BLANK0
#define SET_V2_BLANK_L(a)   (0xff&(a))

// HDMI_V_BLANK1
#define SET_V1_BLANK_L(a)   ((0x1f&(a))<<3)
#define SET_V2_BLANK_H(a)   (0x7&((a)>>8))

// HDMI_V_BLANK2
#define SET_V1_BLANK_H(a)   (0x3f&((a)>>5))

// HDMI_H_V_LINE0
#define SET_V_LINE_L(a) (0xff&(a))

// HDMI_H_V_LINE1
#define SET_H_LINE_L(a) ((0xf&(a))<<4)
#define SET_V_LINE_H(a) (0xf&((a)>>8))

// HDMI_H_V_LINE2
#define SET_H_LINE_H(a) (0xff&((a)>>4))

// HDMI_SYNC_MODE
#define V_SYNC_POL_ACT_LOW  (1)
#define V_SYNC_POL_ACT_HIGH (0)

// HDMI_INT_PRO_MODE
#define INT_PRO_MODE_INTERLACE      (1)
#define INT_PRO_MODE_PROGRESSIVE    (0)

// HDMI_SEND_PER_START0
#define SET_SEND_START0(a)  (0xff&(a))
// HDMI_SEND_PER_START1
#define SET_SEND_START1(a)  (0xff&((a)>>8))
// HDMI_SEND_PER_END0
#define SET_SEND_END_PD_L(a)  (0xff&(a))
// HDMI_SEND_PER_END1
#define SET_SEND_END_ENC_L(a)  ((0x3f&(a))<<2)
#define SET_SEND_END_PD_H(a)   (0x3&((a)>>8))
// HDMI_SEND_PER_END2
#define SET_SEND_END_ENC_H(a)  (0xff&((a)>>6))

// HDMI_V_BLANK_INTERLACE0
#define SET_V_BOT_ST_L(a)   (0xff&(a))
// HDMI_V_BLANK_INTERLACE1
#define SET_V_BOT_END_L(a)  ((0x1f&(a))<<3)
#define SET_V_BOT_ST_H(a)   (0x7&((a)>>8))
// HDMI_V_BLANK_INTERLACE2
#define SET_V_BOT_END_H(a)  (0x3f&((a)>>5))

// HDMI_H_SYNC_GEN0
#define SET_HSYNC_START_L(a)    (0xff&(a))

// HDMI_H_SYNC_GEN1
#define SET_HSYNC_END_L(a)      ((0x3f&(a))<<2)
#define SET_HSYNC_START_H(a)    (0x3&((a)>>8))

// HDMI_H_SYNC_GEN2
#define SET_HSYNC_POL_ACT_LOW   (1<<4)
#define SET_HSYNC_POL_ACT_HIGH  (0<<4)
#define SET_HSYNC_END_H(a)      (0xf&((a)>>6))

// HDMI_V_SYNC_GEN1_0
#define SET_VSYNC_T_END_L(a)    (0xff&(a))

// HDMI_V_SYNC_GEN1_1
#define SET_VSYNC_T_ST_L(a)     ((0xf&(a))<<4)
#define SET_VSYNC_T_END_H(a)    (0xf&((a)>>8))

// HDMI_V_SYNC_GEN1_2
#define SET_VSYNC_T_ST_H(a)     (0xff&((a)>>4))

// HDMI_V_SYNC_GEN2_0
#define SET_VSYNC_B_END_L(a)    (0xff&(a))

// HDMI_V_SYNC_GEN2_1
#define SET_VSYNC_B_ST_L(a)     ((0xf&(a))<<4)
#define SET_VSYNC_B_END_H(a)    (0xf&((a)>>8))

// HDMI_V_SYNC_GEN2_2
#define SET_VSYNC_B_ST_H(a)     (0xff&((a)>>4))


// HDMI_V_SYNC_GEN3_0
#define SET_VSYNC_H_POST_END_L(a)   (0xff&(a))

// HDMI_V_SYNC_GEN3_1
#define SET_VSYNC_H_POST_ST_L(a)    ((0xf&(a))<<4)
#define SET_VSYNC_H_POST_END_H(a)   (0xf&((a)>>8))

// HDMI_V_SYNC_GEN3_2
#define SET_VSYNC_H_POST_ST_H(a)    (0xff&((a)>>4))


// Audio releated packet register
// HDMI_ASP_CON
#define SACD_EN     (1<<5)
#define SACD_DIS    (0<<5)
#define AUD_MODE_MULTI_CH   (1<<4)
#define AUD_MODE_2_CH       (0<<4)
#define SET_SP_PRE(a)       (0xf&(a))

// HDMI_ASP_SP_FLAT
#define SET_SP_FLAT(a)      (0xf&(a))

// HDMI_ASP_CHCFG0
// HDMI_ASP_CHCFG1
// HDMI_ASP_CHCFG2
// HDMI_ASP_CHCFG3
#define SPK3R_SEL_I_PCM0L  (0<<27)
#define SPK3R_SEL_I_PCM0R  (1<<27)
#define SPK3R_SEL_I_PCM1L  (2<<27)
#define SPK3R_SEL_I_PCM1R  (3<<27)
#define SPK3R_SEL_I_PCM2L  (4<<27)
#define SPK3R_SEL_I_PCM2R  (5<<27)
#define SPK3R_SEL_I_PCM3L  (6<<27)
#define SPK3R_SEL_I_PCM3R  (7<<27)
#define SPK3L_SEL_I_PCM0L  (0<<24)
#define SPK3L_SEL_I_PCM0R  (1<<24)
#define SPK3L_SEL_I_PCM1L  (2<<24)
#define SPK3L_SEL_I_PCM1R  (3<<24)
#define SPK3L_SEL_I_PCM2L  (4<<24)
#define SPK3L_SEL_I_PCM2R  (5<<24)
#define SPK3L_SEL_I_PCM3L  (6<<24)
#define SPK3L_SEL_I_PCM3R  (7<<24)
#define SPK2R_SEL_I_PCM0L  (0<<19)
#define SPK2R_SEL_I_PCM0R  (1<<19)
#define SPK2R_SEL_I_PCM1L  (2<<19)
#define SPK2R_SEL_I_PCM1R  (3<<19)
#define SPK2R_SEL_I_PCM2L  (4<<19)
#define SPK2R_SEL_I_PCM2R  (5<<19)
#define SPK2R_SEL_I_PCM3L  (6<<19)
#define SPK2R_SEL_I_PCM3R  (7<<19)
#define SPK2L_SEL_I_PCM0L  (0<<16)
#define SPK2L_SEL_I_PCM0R  (1<<16)
#define SPK2L_SEL_I_PCM1L  (2<<16)
#define SPK2L_SEL_I_PCM1R  (3<<16)
#define SPK2L_SEL_I_PCM2L  (4<<16)
#define SPK2L_SEL_I_PCM2R  (5<<16)
#define SPK2L_SEL_I_PCM3L  (6<<16)
#define SPK2L_SEL_I_PCM3R  (7<<16)
#define SPK1R_SEL_I_PCM0L  (0<<11)
#define SPK1R_SEL_I_PCM0R  (1<<11)
#define SPK1R_SEL_I_PCM1L  (2<<11)
#define SPK1R_SEL_I_PCM1R  (3<<11)
#define SPK1R_SEL_I_PCM2L  (4<<11)
#define SPK1R_SEL_I_PCM2R  (5<<11)
#define SPK1R_SEL_I_PCM3L  (6<<11)
#define SPK1R_SEL_I_PCM3R  (7<<11)
#define SPK1L_SEL_I_PCM0L  (0<<8)
#define SPK1L_SEL_I_PCM0R  (1<<8)
#define SPK1L_SEL_I_PCM1L  (2<<8)
#define SPK1L_SEL_I_PCM1R  (3<<8)
#define SPK1L_SEL_I_PCM2L  (4<<8)
#define SPK1L_SEL_I_PCM2R  (5<<8)
#define SPK1L_SEL_I_PCM3L  (6<<8)
#define SPK1L_SEL_I_PCM3R  (7<<8)
#define SPK0R_SEL_I_PCM0L  (0<<3)
#define SPK0R_SEL_I_PCM0R  (1<<3)
#define SPK0R_SEL_I_PCM1L  (2<<3)
#define SPK0R_SEL_I_PCM1R  (3<<3)
#define SPK0R_SEL_I_PCM2L  (4<<3)
#define SPK0R_SEL_I_PCM2R  (5<<3)
#define SPK0R_SEL_I_PCM3L  (6<<3)
#define SPK0R_SEL_I_PCM3R  (7<<3)
#define SPK0L_SEL_I_PCM0L  (0)
#define SPK0L_SEL_I_PCM0R  (1)
#define SPK0L_SEL_I_PCM1L  (2)
#define SPK0L_SEL_I_PCM1R  (3)
#define SPK0L_SEL_I_PCM2L  (4)
#define SPK0L_SEL_I_PCM2R  (5)
#define SPK0L_SEL_I_PCM3L  (6)
#define SPK0L_SEL_I_PCM3R  (7)

// HDMI_ACR_CON
#define ALT_CTS_RATE_CTS_1      (0<<3)
#define ALT_CTS_RATE_CTS_11     (1<<3)
#define ALT_CTS_RATE_CTS_21     (2<<3)
#define ALT_CTS_RATE_CTS_31     (3<<3)
#define ACR_TX_MODE_NO_TX       (0)
#define ACR_TX_MODE_TX_ONCE     (1)
#define ACR_TX_MODE_TXCNT_VBI   (2)
#define ACR_TX_MODE_TX_VPC      (3)
#define ACR_TX_MODE_MESURE_CTS  (4)

// HDMI_ACR_MCTS0
// HDMI_ACR_MCTS1
// HDMI_ACR_MCTS2
#define SET_ACR_MCTS(a) (0xfffff&(a))

// HDMI_ACR_CTS0
// HDMI_ACR_CTS1
// HDMI_ACR_CTS2
#define SET_ACR_CTS(a)  (0xfffff&(a))

// HDMI_ACR_N0
// HDMI_ACR_N1
// HDMI_ACR_N2
#define SET_ACR_N(a)    (0xfffff&(a))

// HDMI_ACR_LSB2
#define SET_ACR_LSB2(a) (0xff&(a))

// HDMI_ACR_TXCNT
#define SET_ACR_TXCNT(a)    (0x1f&(a))

// HDMI_ACR_TXINTERNAL
#define SET_ACR_TX_INTERNAL(a)  (0xff&(a))

// HDMI_ACR_CTS_OFFSET
#define SET_ACR_CTS_OFFSET(a)   (0xff&(a))

// HDMI_GCP_CON
#define GCP_CON_NO_TRAN             (0)
#define GCP_CON_TRANS_ONCE          (1)
#define GCP_CON_TRANS_EVERY_VSYNC   (2)

// HDMI_GCP_BYTE1
#define SET_GCP_BYTE1(a)    (0xff&(a))


// ACP and ISRC1/2 packet registers
// HDMI_ACP_CON
#define SET_ACP_FR_RATE(a)          ((0x1f&(a))<<3)
#define ACP_CON_NO_TRAN             (0)
#define ACP_CON_TRANS_ONCE          (1)
#define ACP_CON_TRANS_EVERY_VSYNC   (2)

// HDMI_ACP_TYPE
#define SET_ACP_TYPE(a)     (0xff&(a))


// HDMI_ACP_DATA0
// HDMI_ACP_DATA1
// HDMI_ACP_DATA2
// HDMI_ACP_DATA3
// HDMI_ACP_DATA4
// HDMI_ACP_DATA5
// HDMI_ACP_DATA6
// HDMI_ACP_DATA7
// HDMI_ACP_DATA8
// HDMI_ACP_DATA9
// HDMI_ACP_DATA10
// HDMI_ACP_DATA11
// HDMI_ACP_DATA12
// HDMI_ACP_DATA13
// HDMI_ACP_DATA14
// HDMI_ACP_DATA15
// HDMI_ACP_DATA16
#define SET_ACP_DATA(a)     (0xff&(a))


// HDMI_ISRC_CON
#define SET_ISRC_FR_RATE(a)             ((0x1f&(a))<<3)
#define ISRC_EN                         (1<<2)
#define ISRC_DIS                        (0<<2)
#define ISRC_TX_CON_NO_TRANS            (0)
#define ISRC_TX_CON_TRANS_ONCE          (1)
#define ISRC_TX_CON_TRANS_EVERY_VSYNC   (2)

// HDMI_ISRC1_HEADER1
#define SET_ISRC1_HEADER(a) (0xff&(a))

// HDMI_ISRC1_DATA0
// HDMI_ISRC1_DATA1
// HDMI_ISRC1_DATA2
// HDMI_ISRC1_DATA3
// HDMI_ISRC1_DATA4
// HDMI_ISRC1_DATA5
// HDMI_ISRC1_DATA6
// HDMI_ISRC1_DATA7
// HDMI_ISRC1_DATA8
// HDMI_ISRC1_DATA9
// HDMI_ISRC1_DATA10
// HDMI_ISRC1_DATA11
// HDMI_ISRC1_DATA12
// HDMI_ISRC1_DATA13
// HDMI_ISRC1_DATA14
// HDMI_ISRC1_DATA15
#define SET_ISRC1_DATA(a)   (0xff&(a))


// HDMI_ISRC2_DATA0
// HDMI_ISRC2_DATA1
// HDMI_ISRC2_DATA2
// HDMI_ISRC2_DATA3
// HDMI_ISRC2_DATA4
// HDMI_ISRC2_DATA5
// HDMI_ISRC2_DATA6
// HDMI_ISRC2_DATA7
// HDMI_ISRC2_DATA8
// HDMI_ISRC2_DATA9
// HDMI_ISRC2_DATA10
// HDMI_ISRC2_DATA11
// HDMI_ISRC2_DATA12
// HDMI_ISRC2_DATA13
// HDMI_ISRC2_DATA14
// HDMI_ISRC2_DATA15
#define SET_ISRC2_DATA(a)   (0xff&(a))


// AVI info-frame registers
// HDMI_AVI_CON
#define AVI_TX_CON_NO_TRANS             (0)
#define AVI_TX_CON_TRANS_ONCE           (1)
#define AVI_TX_CON_TRANS_EVERY_VSYNC    (2)


// HDMI_AVI_CHECK_SUM
#define SET_AVI_CHECK_SUM(a)    (0xff&(a))


// HDMI_AVI_BYTE1
// HDMI_AVI_BYTE2
// HDMI_AVI_BYTE3
// HDMI_AVI_BYTE4
// HDMI_AVI_BYTE5
// HDMI_AVI_BYTE6
// HDMI_AVI_BYTE7
// HDMI_AVI_BYTE8
// HDMI_AVI_BYTE9
// HDMI_AVI_BYTE10
// HDMI_AVI_BYTE11
// HDMI_AVI_BYTE12
// HDMI_AVI_BYTE13
#define SET_AVI_BYTE(a)     (0xff&(a))


// Audio info-frame registers
// HDMI_AUI_CON
#define AUI_TX_CON_NO_TRANS             (0)
#define AUI_TX_CON_TRANS_ONCE           (1)
#define AUI_TX_CON_TRANS_EVERY_VSYNC    (2)


// HDMI_AUI_CHECK_SUM
// HDMI_AVI_CHECK_SUM
#define SET_AUI_CHECK_SUM(a)    (0xff&(a))


// HDMI_AUI_BYTE1
// HDMI_AUI_BYTE2
// HDMI_AUI_BYTE3
// HDMI_AUI_BYTE4
// HDMI_AUI_BYTE5
#define SET_AUI_BYTE(a)     (0xff&(a))


// MPEG source info-frame registers
// HDMI_MPG_CON
#define MPG_TX_CON_NO_TRANS             (0)
#define MPG_TX_CON_TRANS_ONCE           (1)
#define MPG_TX_CON_TRANS_EVERY_VSYNC    (2)


// HDMI_MPG_CHECK_SUM
#define SET_MPG_CHECK_SUM(a)    (0xff&(a))

// HDMI_MPG_BYTE1
// HDMI_MPG_BYTE2
// HDMI_MPG_BYTE3
// HDMI_MPG_BYTE4
// HDMI_MPG_BYTE5
#define SET_MPG_BYTE(a)     (0xff&(a))


// Souerce product desciptor info-f
// HDMI_SPD_CON
#define SPD_TX_CON_NO_TRANS             (0)
#define SPD_TX_CON_TRANS_ONCE           (1)
#define SPD_TX_CON_TRANS_EVERY_VSYNC    (2)


// HDMI_SPD_HEADER0
// HDMI_SPD_HEADER1
// HDMI_SPD_HEADER2
#define SET_SPD_HEADER(a)   (0xff&(a))


// HDMI_SPD_DATA0
// HDMI_SPD_DATA1
// HDMI_SPD_DATA2
// HDMI_SPD_DATA3
// HDMI_SPD_DATA4
// HDMI_SPD_DATA5
// HDMI_SPD_DATA6
// HDMI_SPD_DATA7
// HDMI_SPD_DATA8
// HDMI_SPD_DATA9
// HDMI_SPD_DATA10
// HDMI_SPD_DATA11
// HDMI_SPD_DATA12
// HDMI_SPD_DATA13
// HDMI_SPD_DATA14
// HDMI_SPD_DATA15
// HDMI_SPD_DATA16
// HDMI_SPD_DATA17
// HDMI_SPD_DATA18
// HDMI_SPD_DATA19
// HDMI_SPD_DATA20
// HDMI_SPD_DATA21
// HDMI_SPD_DATA22
// HDMI_SPD_DATA23
// HDMI_SPD_DATA24
// HDMI_SPD_DATA25
// HDMI_SPD_DATA26
// HDMI_SPD_DATA27
#define SET_SPD_DATA(a)     (0xff&(a))


// HDMI_CSC_CON
#define OUT_OFFSET_SEL_RGB_FR   (0<<4)
#define OUT_OFFSET_SEL_RGB_LR   (2<<4)
#define OUT_OFFSET_SEL_YCBCR    (3<<4)
#define IN_CLIP_EN              (1<<2)
#define IN_CLIP_DIS             (0<<2)
#define IN_OFFSET_SEL_RGB_FR    (0)
#define IN_OFFSET_SEL_RGB_LR    (2)
#define IN_OFFSET_SEL_YCBCR     (3)

// HDMI_Y_G_COEF_L
// HDMI_Y_G_COEF_H
// HDMI_Y_B_COEF_L
// HDMI_Y_B_COEF_H
// HDMI_Y_R_COEF_L
// HDMI_Y_R_COEF_H
// HDMI_CB_G_COEF_L
// HDMI_CB_G_COEF_H
// HDMI_CB_B_COEF_L
// HDMI_CB_B_COEF_H
// HDMI_CB_R_COEF_L
// HDMI_CB_R_COEF_H
// HDMI_CR_G_COEF_L
// HDMI_CR_G_COEF_H
// HDMI_CR_B_COEF_L
// HDMI_CR_B_COEF_H
// HDMI_CR_R_COEF_L
// HDMI_CR_R_COEF_H
#define SET_HDMI_CSC_COEF_L(a)    (0xff&(a))
#define SET_HDMI_CSC_COEF_H(a)    (0x3&((a)>>8))


// Test pattern generation register
// HDMI_TPGEN_0
// HDMI_TPGEN_1
// HDMI_TPGEN_2
// HDMI_TPGEN_3
// HDMI_TPGEN_4
// HDMI_TPGEN_5
// HDMI_TPGEN_6


// HDCP_RX_SHA_1_0_0
// HDCP_RX_SHA_1_0_1
// HDCP_RX_SHA_1_0_2
// HDCP_RX_SHA_1_0_3
// HDCP_RX_SHA_1_1_0
// HDCP_RX_SHA_1_1_1
// HDCP_RX_SHA_1_1_2
// HDCP_RX_SHA_1_1_3
// HDCP_RX_SHA_1_2_0
// HDCP_RX_SHA_1_2_1
// HDCP_RX_SHA_1_2_2
// HDCP_RX_SHA_1_2_3
// HDCP_RX_SHA_1_3_0
// HDCP_RX_SHA_1_3_1
// HDCP_RX_SHA_1_3_2
// HDCP_RX_SHA_1_3_3
// HDCP_RX_SHA_1_4_0
// HDCP_RX_SHA_1_4_1
// HDCP_RX_SHA_1_4_2
// HDCP_RX_SHA_1_4_3
#define SET_HDMI_SHA1(a)    (0xff&(a))


// HDCP_RX_KSV_0_0
// HDCP_RX_KSV_0_1
// HDCP_RX_KSV_0_2
// HDCP_RX_KSV_0_3
// HDCP_RX_KSV_1_0
// HDCP_RX_KSV_1_1

// HDCP_AUTH_STAT

// HDCP_CTRL

// HDCP_CHECK_RESULT

// HDCP_BKSV0_0
// HDCP_BKSV0_1
// HDCP_BKSV0_2
// HDCP_BKSV0_3
// HDCP_BKSV1
// HDCP_AKSV0_0
// HDCP_AKSV0_1
// HDCP_AKSV0_2
// HDCP_AKSV0_3
// HDCP_AKSV1

// HDCP_AN0_0
// HDCP_AN0_1
// HDCP_AN0_2
// HDCP_AN0_3
// HDCP_AN1_0
// HDCP_AN1_1
// HDCP_AN1_2
// HDCP_AN1_3

// HDCP_BCAPS
// HDCP_BSTATUS0
// HDCP_BSTATUS1

// HDCP_RI_0
// HDCP_RI_1
// HDCP_PJ

// HDCP_OFFSET_TX0
// HDCP_OFFSET_TX1
// HDCP_OFFSET_TX2
// HDCP_OFFSET_TX3
// HDCP_CYCLE_AA
// HDCP_I2C_INT
// HDCP_AN_INT
// HDCP_WATCHDOG_INT
// HDCP_RI_INT
// HDCP_PJ_INT


// TG SFR
// TG_CMD
#define GETSYNC_TYPE_EN     (1<<4)
#define GETSYNC_TYPE_DIS    (0<<4)
#define GETSYNC_EN          (1<<3)
#define GETSYNC_DIS         (0<<3)
#define FIELD_EN            (1<<2)
#define FIELD_DIS           (0<<2)
#define TG_EN               (1)
#define TG_DIS              (0)

// TG_CFG
// TG_CB_SZ
// TG_INDELAY_L
// TG_INDELAY_H
// TG_POL_CTRL

// TG_H_FSZ_L
#define SET_TG_H_FSZ_L(a)   (0xff&(a))

// TG_H_FSZ_H
#define SET_TG_H_FSZ_H(a)   (0x1f&((a)>>8))

// TG_HACT_ST_L
#define SET_TG_HACT_ST_L(a) (0xff&(a))

// TG_HACT_ST_H
#define SET_TG_HACT_ST_H(a) (0xf&((a)>>8))

// TG_HACT_SZ_L
#define SET_TG_HACT_SZ_L(a) (0xff&(a))

// TG_HACT_SZ_H
#define SET_TG_HACT_SZ_H(a) (0xf&((a)>>8))

// TG_V_FSZ_L
#define SET_TG_V_FSZ_L(a)   (0xff&(a))

// TG_V_FSZ_H
#define SET_TG_V_FSZ_H(a)   (0x7&((a)>>8))

// TG_VSYNC_L
#define SET_TG_VSYNC_L(a)   (0xff&(a))

// TG_VSYNC_H
#define SET_TG_VSYNC_H(a)   (0x7&((a)>>8))

// TG_VSYNC2_L
#define SET_TG_VSYNC2_L(a)  (0xff&(a))

// TG_VSYNC2_H
#define SET_TG_VSYNC2_H(a)  (0x7&((a)>>8))

// TG_VACT_ST_L
#define SET_TG_VACT_ST_L(a) (0xff&(a))

// TG_VACT_ST_H
#define SET_TG_VACT_ST_H(a) (0x7&((a)>>8))

// TG_VACT_SZ_L
#define SET_TG_VACT_SZ_L(a) (0xff&(a))

// TG_VACT_SZ_H
#define SET_TG_VACT_SZ_H(a) (0x7&((a)>>8))

// TG_FIELD_CHG_L
#define SET_TG_FIELD_CHG_L(a)   (0xff&(a))

// TG_FIELD_CHG_H
#define SET_TG_FIELD_CHG_H(a)   (0x7&((a)>>8))

// TG_VACT_ST2_L
#define SET_TG_VACT_ST2_L(a)    (0xff&(a))

// TG_VACT_ST2_H
#define SET_TG_VACT_ST2_H(a)    (0x7&((a)>>8))

// TG_VACT_SC_ST_L
// TG_VACT_SC_ST_H
// TG_VACT_SC_SZ_L
// TG_VACT_SC_SZ_H

// TG_VSYNC_TOP_HDMI_L
#define SET_TG_VSYNC_TOP_HDMI_L(a)  (0xff&(a))

// TG_VSYNC_TOP_HDMI_H
#define SET_TG_VSYNC_TOP_HDMI_H(a)  (0x7&((a)>>8))

// TG_VSYNC_BOT_HDMI_L
#define SET_TG_VSYNC_BOT_HDMI_L(a)  (0xff&(a))

// TG_VSYNC_BOT_HDMI_H
#define SET_TG_VSYNC_BOT_HDMI_H(a)  (0x7&((a)>>8))

// TG_FILED_TOP_HDMI_L
#define SET_TG_FILED_TOP_HDMI_L(a)  (0xff&(a))

// TG_FILED_TOP_HDMI_H
#define SET_TG_FILED_TOP_HDMI_H(a)  (0x7&((a)>>8))

// TG_FILED_BOT_HDMI_L
#define SET_TG_FILED_BOT_HDMI_L(a)  (0xff&(a))

// TG_FILED_BOT_HDMI_H
#define SET_TG_FILED_BOT_HDMI_H(a)  (0x7&((a)>>8))

// TG_HSYNC_HDOUT_ST_L
// TG_HSYNC_HDOUT_ST_H
// TG_HSYNC_HDOUT_END_L
// TG_HSYNC_HDOUT_END_H
// TG_VSYNC_HDOUT_ST_L
// TG_VSYNC_HDOUT_ST_H
// TG_VSYNC_HDOUT_END_L
// TG_VSYNC_HDOUT_END_H
// TG_VSYNC_HDOUT_DLY_L
// TG_VSYNC_HDOUT_DLY_H
// TG_BT_ERR_RANGE
// TG_BT_ERR_RESULT
// TG_COR_THR
// TG_COR_NUM
// TG_BT_CON
// TG_BT_H_FSZ_L
// TG_BT_H_FSZ_H
// TG_BT_HSYNC_ST
// TG_BT_HSYNC_SZ
// TG_BT_FSZ_L
// TG_BT_FSZ_H
// TG_BT_VACT_T_ST_L
// TG_BT_VACT_T_ST_H
// TG_BT_VACT_B_ST_L
// TG_BT_VACT_B_ST_H
// TG_BT_VACT_SZ_L
// TG_BT_VACT_SZ_H
// TG_BT_VSYNC_SZ

// SPDIFIN_CLK_CTRL
// SPDIFIN_OP_CTRL
// SPDIFIN_IRQ_MASK
// SPDIFIN_IRQ_STATUS
// SPDIFIN_CONFIG_1
// SPDIFIN_CONFIG_2
// SPDIFIN_USER_VALUE_1
// SPDIFIN_USER_VALUE_2
// SPDIFIN_USER_VALUE_3
// SPDIFIN_USER_VALUE_4
// SPDIFIN_CH_STATUS_0_1
// SPDIFIN_CH_STATUS_0_2
// SPDIFIN_CH_STATUS_0_3
// SPDIFIN_CH_STATUS_0_4
// SPDIFIN_CH_STATUS_1
// SPDIFIN_FRAME_PERIOD_1
// SPDIFIN_FRAME_PERIOD_2
// SPDIFIN_PC_INFO_1
// SPDIFIN_PC_INFO_2
// SPDIFIN_PD_INFO_1
// SPDIFIN_PD_INFO_2
// SPDIFIN_DATA_BUF_0_1
// SPDIFIN_DATA_BUF_0_2
// SPDIFIN_DATA_BUF_0_3
// SPDIFIN_USER_BUF_0
// SPDIFIN_USER_BUF_1_1
// SPDIFIN_USER_BUF_1_2
// SPDIFIN_USER_BUF_1_3
// SPDIFIN_USER_BUF_1

// HAES_START
// HAES_DATA_SIZE_L
// HAES_DATA_SIZE_H
// HAES_DATA

#if __cplusplus
    }
#endif

#endif    // __HDMI_MACRO_H

