//
//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
//
//
/*++

Module Name:    hdmi.c

Abstract:       Implementation of hdmi Library
                This module implements Low Level HW control

Functions:


Notes:


--*/

#include <windows.h>
#include <bsp_cfg.h>    // for reference HCLK, ECLK
#include <register_map.h>
#include <hdmireg.h>
#include "tvout_message.h"
#include "hdmi_video.h"
#include "hdmi_audio.h"
#include "hdcp.h"
#include "hdmi.h"
#include "hdmi_internal.h"

#include <video.h>
#include <audio.h>

#ifdef HDMI_HW_TEST
static int ParamMode = 1;
static PIXEL_ASPECT_RATIO ePixelAspectRatio= HDMI_PIXEL_RATIO_4_3;
static ColorDepth cd = HDMI_CD_24;
#endif 

// initialization
//  - iniization functions are only called under stopping HDMI
HDMI_ERROR
HDMI_initialize_register_address
(void *pHDMISSReg,
void *pHDMICoreReg,
void *pHDCPReg,
void *pGPIOReg,
void *pSysConReg,
void *pIICReg,
void *pTGReg)
{
    RETAILMSG(TVOUT_ZONE_HDMI,(_T("[HDMI]++HDMI_initialize_register_address(0x%08x,0x%08x,0x%08x)\n\r"), pHDMISSReg, pHDMICoreReg, pHDCPReg));

    if (pHDMISSReg == NULL || pHDMICoreReg == NULL || pHDCPReg == NULL)
    {
        RETAILMSG(TVOUT_ZONE_ERROR,(_T("[HDMI:ERR] HDMI_initialize_register_address() : NULL pointer parameter\n\r")));
        return HDMI_ERROR_INVALID_PARAM;
    }
    else
    {
        g_pHDMISSConfig = (PHDMI_SS_REG)pHDMISSReg;
        g_pHDMICoreConfig = (PHDMI_CORE_REG)pHDMICoreReg;
        g_pHDCPConfig = (PHDMI_HDCP_REG)pHDCPReg;

        g_pGPIOReg = (PGPIO_REG)pGPIOReg;
        g_pSysConReg = (PCMU_CLK_REG)pSysConReg;
        g_pIICReg        = (PIIC_REG)pIICReg;
        g_pHDMITGConfig = (PHDMI_TG_REG)pTGReg;
        
////        RETAILMSG(TVOUT_ZONE_HDMI,(_T("[HDMI]--HDMI_initialize_register_address(0x%08x,0x%08x,0x%08x)\n\r"), g_pHDMISSConfig,g_pHDMICoreConfig, g_pHDCPConfig));
    }

    return HDMI_NO_ERROR;
}

/*
void PhyCon(int mode, ColorDepth ColorDep)
{
//	ParamMode = mode;

	RETAILMSG(1,(_T("PhyCon mode = %d, %d\n\r"),mode, ColorDep));

    if (PHYConfig(aVideoParams[mode].PixelClock, ColorDep,g_pHDMICoreConfig, g_pSysConReg, g_pIICReg) == 0)
    {
        RETAILMSG(TVOUT_ZONE_HDMI,(_T("[HDMI] PhyConfig Error\n\r")));
        return ;
    }	

}
*/

void HDMI_TG_Setting(int mode)
{

	
	UINT16 	usTemp;
	UINT8	ucTG_cmd;

//	ParamMode = mode;
	
	// set Horizontal Full Size
	usTemp = oHDMI_TG_Param[mode].tg_H_FSZ;
//	HdmiOutp8(rTG_H_FSZ_L, (u8)(usTemp&0xff) );
//	HdmiOutp8(rTG_H_FSZ_H, (u8)(usTemp >> 8) );
        g_pHDMITGConfig->TG_H_FSZ_L = (UINT8)(usTemp&0xff);
        g_pHDMITGConfig->TG_H_FSZ_H = (UINT8)(usTemp>>8);
        
	//set Horizontal Active Start Position
	usTemp = oHDMI_TG_Param[mode].tg_HACT_ST;
//	HdmiOutp8(rTG_HACT_ST_L, (u8)(usTemp&0xff) );
//	HdmiOutp8(rTG_HACT_ST_H, (u8)(usTemp >> 8) );
        g_pHDMITGConfig->TG_HACT_ST_L  = (UINT8)(usTemp&0xff);
        g_pHDMITGConfig->TG_HACT_ST_H = (UINT8)(usTemp>>8);

	// set Horizontal Active Size
	usTemp = oHDMI_TG_Param[mode].tg_HACT_SZ;
//	HdmiOutp8(rTG_HACT_SZ_L, (u8)(usTemp&0xff) );
//	HdmiOutp8(rTG_HACT_SZ_H, (u8)(usTemp >> 8) );	
        g_pHDMITGConfig->TG_HACT_SZ_L  = (UINT8)(usTemp&0xff);
        g_pHDMITGConfig->TG_HACT_SZ_H = (UINT8)(usTemp>>8);
        

	// set Vertical Full Size
	usTemp = oHDMI_TG_Param[mode].tg_V_FSZ;
//	HdmiOutp8(rTG_V_FSZ_L, (u8)(usTemp&0xff) );
//	HdmiOutp8(rTG_V_FSZ_H, (u8)(usTemp >> 8) );
        g_pHDMITGConfig->TG_V_FSZ_L= (UINT8)(usTemp&0xff);
        g_pHDMITGConfig->TG_V_FSZ_H= (UINT8)(usTemp>>8);

	// set VSYNC Position
	usTemp = oHDMI_TG_Param[mode].tg_VSYNC;
//	HdmiOutp8(rTG_VSYNC_L, (u8)(usTemp&0xff) );
//	HdmiOutp8(rTG_VSYNC_H, (u8)(usTemp >> 8) );	
        g_pHDMITGConfig->TG_VSYNC_L  = (UINT8)(usTemp&0xff);
        g_pHDMITGConfig->TG_VSYNC_H = (UINT8)(usTemp>>8);

	// set Bottom Field VSYNC Position
	usTemp = oHDMI_TG_Param[mode].tg_VSYNC2;
//	HdmiOutp8(rTG_VSYNC2_L, (u8)(usTemp&0xff) );
//	HdmiOutp8(rTG_VSYNC2_H, (u8)(usTemp >> 8) );		
        g_pHDMITGConfig->TG_VSYNC2_L  = (UINT8)(usTemp&0xff);
        g_pHDMITGConfig->TG_VSYNC2_H = (UINT8)(usTemp>>8);

	// set Vertical Active Start Position
	usTemp = oHDMI_TG_Param[mode].tg_VACT_ST;
//	HdmiOutp8(rTG_VACT_ST_L, (u8)(usTemp&0xff) );
//	HdmiOutp8(rTG_VACT_ST_H, (u8)(usTemp >> 8) );		
        g_pHDMITGConfig->TG_VACT_ST_L = (UINT8)(usTemp&0xff);
        g_pHDMITGConfig->TG_VACT_ST_H = (UINT8)(usTemp>>8);

	// set Vertical Active Size
	usTemp = oHDMI_TG_Param[mode].tg_VACT_SZ;
//	HdmiOutp8(rTG_VACT_SZ_L, (u8)(usTemp&0xff) );
//	HdmiOutp8(rTG_VACT_SZ_H, (u8)(usTemp >> 8) );	
        g_pHDMITGConfig->TG_VACT_SZ_L  = (UINT8)(usTemp&0xff);
        g_pHDMITGConfig->TG_VACT_SZ_H = (UINT8)(usTemp>>8);

	// set Field Change Position
	usTemp = oHDMI_TG_Param[mode].tg_FIELD_CHG;
//	HdmiOutp8(rTG_FIELD_CHG_L, (u8)(usTemp&0xff) );
//	HdmiOutp8(rTG_FIELD_CHG_H, (u8)(usTemp >> 8) );
        g_pHDMITGConfig->TG_FIELD_CHG_L = (UINT8)(usTemp&0xff);
        g_pHDMITGConfig->TG_FIELD_CHG_H = (UINT8)(usTemp>>8);


	// set Bottom Field Vertical Active Start Position
	usTemp = oHDMI_TG_Param[mode].tg_VACT_ST2;
//	HdmiOutp8(rTG_VACT_ST2_L, (u8)(usTemp&0xff) );
//	HdmiOutp8(rTG_VACT_ST2_H, (u8)(usTemp >> 8) );
        g_pHDMITGConfig->TG_VACT_ST2_L= (UINT8)(usTemp&0xff);
        g_pHDMITGConfig->TG_VACT_ST2_H = (UINT8)(usTemp>>8);

	// set VSYNC Position for HDMI
	usTemp = oHDMI_TG_Param[mode].tg_VSYNC_TOP_HDMI;
//	HdmiOutp8(rTG_VSYNC_TOP_HDMI_L, (u8)(usTemp&0xff) );
//	HdmiOutp8(rTG_VSYNC_TOP_HDMI_H, (u8)(usTemp >> 8) );	
        g_pHDMITGConfig->TG_VSYNC_TOP_HDMI_L  = (UINT8)(usTemp&0xff);
        g_pHDMITGConfig->TG_VSYNC_TOP_HDMI_H = (UINT8)(usTemp>>8);

	// set Bottom Field VSYNC Position
	usTemp = oHDMI_TG_Param[mode].tg_VSYNC_BOT_HDMI;
//	HdmiOutp8(rTG_VSYNC_BOT_HDMI_L, (u8)(usTemp&0xff) );
//	HdmiOutp8(rTG_VSYNC_BOT_HDMI_H, (u8)(usTemp >> 8) );	
        g_pHDMITGConfig->TG_VSYNC_BOT_HDMI_L  = (UINT8)(usTemp&0xff);
        g_pHDMITGConfig->TG_VSYNC_BOT_HDMI_H = (UINT8)(usTemp>>8);

	// set Top Field Change Position for HDMI
	usTemp = oHDMI_TG_Param[mode].tg_FIELD_TOP_HDMI;
//	HdmiOutp8(rTG_FIELD_TOP_HDMI_L, (u8)(usTemp&0xff) );
//	HdmiOutp8(rTG_FIELD_TOP_HDMI_H, (u8)(usTemp >> 8) );	
        g_pHDMITGConfig->TG_FIELD_TOP_HDMI_L = (UINT8)(usTemp&0xff);
        g_pHDMITGConfig->TG_FIELD_TOP_HDMI_H = (UINT8)(usTemp>>8);

	// set Bottom Field Change Position for HDMI
	usTemp = oHDMI_TG_Param[mode].tg_FIELD_BOT_HDMI;
//	HdmiOutp8(rTG_FIELD_BOT_HDMI_L, (u8)(usTemp&0xff) );
//	HdmiOutp8(rTG_FIELD_BOT_HDMI_H, (u8)(usTemp >> 8) );	
        g_pHDMITGConfig->TG_FIELD_BOT_HDMI_L = (UINT8)(usTemp&0xff);
        g_pHDMITGConfig->TG_FIELD_BOT_HDMI_H = (UINT8)(usTemp>>8);


//	ucTG_cmd = HdmiInp8(rTG_CMD);
	ucTG_cmd = g_pHDMITGConfig->TG_CMD;

	if(aVideoParams[mode].interlaced == 1)
		ucTG_cmd |= (1<<1);			//Field Mode enable(interlace mode)
	else
		ucTG_cmd &= ~(1<<1);			//Field Mode disable

//	HdmiOutp8(rTG_CMD, ucTG_cmd);
	g_pHDMITGConfig->TG_CMD = ucTG_cmd;

}

void HDMI_TG_OnOff(BOOL bOn)
{
	UINT32 ucTG_cmd;

	ucTG_cmd = g_pHDMITGConfig->TG_CMD;

	if(bOn)
		ucTG_cmd |= (1<<0);
	else
		ucTG_cmd &= ~(1<<0);

	g_pHDMITGConfig->TG_CMD = ucTG_cmd;
}


#ifdef HDMI_HW_TEST
//CommentTemp 

void HDMI_SetColorDepth(ColorDepth cd)
{
	switch (cd)
	{
		case HDMI_CD_36:
//			HdmiOutp8(rHDMI_GCP_BYTE2,GCP_CD_36BPP);
			// set DC register
//			HdmiOutp8(rHDMI_DC_CONTROL,HDMI_DC_CTL_12);
			break;
			
		case HDMI_CD_30:
//			HdmiOutp8(rHDMI_GCP_BYTE2,GCP_CD_30BPP);
			// set DC register
//			HdmiOutp8(rHDMI_DC_CONTROL,HDMI_DC_CTL_10);
			break;
			
		case HDMI_CD_24:
                    g_pHDMICoreConfig->HDMI_GCP_BYTE2 = (UINT8)GCP_CD_24BPP;
                    g_pHDMICoreConfig->HDMI_DC_CONTROL = (UINT8)HDMI_DC_CTL_8;
                    g_pHDMICoreConfig->HDMI_GCP_CON = (UINT8)HPD_DO_NOT_TRANSMIT;
                    break;
			
		default:
//			UART_Printf("HDMI core does not support requested Deep Color mode\n");
			return ;
	}

    
}

void HDMI_mixer_test(int mode)
{

	ParamMode = mode;

    //HDMI_SetMode()
    g_pHDMICoreConfig->HDMI_MODE_SEL = HDMI_MODE_SEL_HDMI;
    g_pHDMICoreConfig->HDMI_CON2 = SYSCON2_HDMI;

    //HDMI_SetColorSpace
    {
//        UINT8 ucTempCon0;
        UINT8 ucTempAVIYY;
        UINT8 ucTempBlueScr0, ucTempBlueScr1, ucTempBlueScr2;

        // for AVI_BYTE1
//      ucTempAVIYY = HdmiInp8(rHDMI_AVI_BYTE1);
        ucTempAVIYY = g_pHDMICoreConfig->HDMI_AVI_BYTE1;
        
        // clear YY field
        ucTempAVIYY &= ~(1<<5 | 1<<6);

#if 1
        // check colorSpace
        ucTempAVIYY |= AVI_CS_Y444;

        // set black screen value for YCBCR
        ucTempBlueScr0 = 255;
        ucTempBlueScr1 = 29;
        ucTempBlueScr2 = 107;
#else
        // check colorSpace
        ucTempAVIYY |= AVI_CS_RGB;

        // set black screen value for YCBCR
        ucTempBlueScr0 = 255;
        ucTempBlueScr1 = 0;
        ucTempBlueScr2 = 0;


#endif
        // set HDMI_CON_1 register
        ///	HdmiOutp8(rHDMI_CON_0 , ucTempCon0);
        // set AVI packet
//        HdmiOutp8(rHDMI_AVI_BYTE1 , ucTempAVIYY);

        g_pHDMICoreConfig->HDMI_AVI_BYTE1 = ucTempAVIYY;

        // set blue scr register 
//        HdmiOutp8(rHDMI_BLUE_SCREEN_0, ucTempBlueScr0);
//        HdmiOutp8(rHDMI_BLUE_SCREEN_1, ucTempBlueScr1);
//        HdmiOutp8(rHDMI_BLUE_SCREEN_2, ucTempBlueScr2);

        g_pHDMICoreConfig->HDMI_BLUE_SCREEN0 = ucTempBlueScr0;
        g_pHDMICoreConfig->HDMI_BLUE_SCREEN1 = ucTempBlueScr1;
        g_pHDMICoreConfig->HDMI_BLUE_SCREEN2 = ucTempBlueScr2 ;       
    }

    //HDMI_SetPixelLimit
    {
        UINT8 ucTempAVIQQ, ucTempCon1;

        ucTempAVIQQ = g_pHDMICoreConfig->HDMI_AVI_BYTE3;
        ucTempAVIQQ &= ~(1<<3|1<<2);

        ucTempCon1 = g_pHDMICoreConfig->HDMI_CON1;
        ucTempCon1 &= ~(1<<6|1<<5);

#if 1
        ucTempCon1 |= (1<<6);//CON1_YCBCR_LIMIT;
        ucTempAVIQQ |= (1<<2);//AVI_QUANTIZATION_LIMITED;
#else
        ucTempCon1 |= (1<<5);//CON1_RGB_LIMIT;
        ucTempAVIQQ |= (1<<2);//AVI_QUANTIZATION_LIMITED;
#endif

        g_pHDMICoreConfig->HDMI_AVI_BYTE3 = ucTempAVIQQ;
        g_pHDMICoreConfig->HDMI_AVI_BYTE3 = ucTempCon1;
        
    }

    //HDMI_SetVideoMode
    {
	UINT8  ucTemp8;
	UINT16 usTemp16;
	UINT32 uTemp32, uvSYNC2Temp, uvSYNC3Temp;

	//rb1004...TG register setting
	HDMI_TG_Setting(ParamMode);

	// set HBlank
	usTemp16 = aVideoParams[ParamMode].vHBlank;
//	HdmiOutp8(rHDMI_H_BLANK_0, (u8)(usTemp16&0xff) );
//	HdmiOutp8(rHDMI_H_BLANK_1, (u8)(usTemp16 >> 8) );
        g_pHDMICoreConfig->HDMI_H_BLANK0 = (UINT8)(usTemp16&0xff);
        g_pHDMICoreConfig->HDMI_H_BLANK1 = (UINT8)(usTemp16 >> 8);
        
	// set VBlank
//	uTemp32 = aVideoParams[mode].vVBlank;
//	HdmiOutp8(rHDMI_V_BLANK_0, (u8)(uTemp32&0xff) );
//	HdmiOutp8(rHDMI_V_BLANK_1, (u8)(uTemp32 >> 8) );
//	HdmiOutp8(rHDMI_V_BLANK_2, (u8)(uTemp32 >> 16) );
	uTemp32 = aVideoParams[ParamMode].vVBlank;
        g_pHDMICoreConfig->HDMI_V_BLANK0 = (UINT8)(uTemp32&0xff);
        g_pHDMICoreConfig->HDMI_V_BLANK1 = (UINT8)(uTemp32 >> 8);
        g_pHDMICoreConfig->HDMI_V_BLANK2 = (UINT8)(uTemp32 >> 16);

	// set HVLine
//	uTemp32 = aVideoParams[mode].vHVLine;
//	HdmiOutp8(rHDMI_H_V_LINE_0, (u8)(uTemp32&0xff) );
//	HdmiOutp8(rHDMI_H_V_LINE_1, (u8)(uTemp32 >> 8) );
//	HdmiOutp8(rHDMI_H_V_LINE_2, (u8)(uTemp32 >> 16) );

	uTemp32 = aVideoParams[ParamMode].vHVLine;
        g_pHDMICoreConfig->HDMI_H_V_LINE0 = (UINT8)(uTemp32&0xff);
        g_pHDMICoreConfig->HDMI_H_V_LINE1 = (UINT8)(uTemp32 >> 8);
        g_pHDMICoreConfig->HDMI_H_V_LINE2 = (UINT8)(uTemp32 >> 16);

	// set VSYNC polarity
//	HdmiOutp8(rHDMI_VSYNC_POL, aVideoParams[mode].polarity);
	g_pHDMICoreConfig->HDMI_VSYNC_POL = aVideoParams[ParamMode].polarity;
    
	// set HSyncGen
//	uTemp32 = aVideoParams[mode].vHSYNCGEN;
//	HdmiOutp8(rHDMI_H_SYNC_GEN_0, (u8)(uTemp32&0xff) );
//	HdmiOutp8(rHDMI_H_SYNC_GEN_1, (u8)(uTemp32 >> 8) );
//	HdmiOutp8(rHDMI_H_SYNC_GEN_2, (u8)(uTemp32 >> 16) );
	uTemp32 = aVideoParams[ParamMode].vHSYNCGEN;
	g_pHDMICoreConfig->HDMI_H_SYNC_GEN0 =  (UINT8)(uTemp32&0xff);
	g_pHDMICoreConfig->HDMI_H_SYNC_GEN1 = (UINT8)(uTemp32 >> 8);
	g_pHDMICoreConfig->HDMI_H_SYNC_GEN2= (UINT8)(uTemp32 >> 16);

	// set VSyncGen1
//	uTemp32 = aVideoParams[mode].vVSYNCGEN;
//	HdmiOutp8(rHDMI_V_SYNC_GEN1_0, (u8)(uTemp32&0xff) );
//	HdmiOutp8(rHDMI_V_SYNC_GEN1_1, (u8)(uTemp32 >> 8) );
//	HdmiOutp8(rHDMI_V_SYNC_GEN1_2, (u8)(uTemp32 >> 16) );
	uTemp32 = aVideoParams[ParamMode].vVSYNCGEN;
	g_pHDMICoreConfig->HDMI_V_SYNC_GEN1_0 = (UINT8)(uTemp32&0xff);
	g_pHDMICoreConfig->HDMI_V_SYNC_GEN1_1 =  (UINT8)(uTemp32 >> 8);
	g_pHDMICoreConfig->HDMI_V_SYNC_GEN1_2 =  (UINT8)(uTemp32 >> 16);

//	if (aVideoParams[mode].interlaced)
	if (aVideoParams[ParamMode].interlaced)
	{
		// set up VBLANK_F, VSYNCGEN2, VSYNCGEN3
//		uTemp32 = aVideoParams[mode].VBLANK_F;
//		uvSYNC2Temp = aVideoParams[mode].VSYNCGEN2;
//		uvSYNC3Temp = aVideoParams[mode].VSYNCGEN3;

//		HdmiOutp8(rHDMI_V_BLANK_F_0, (u8)(uTemp32 & 0xff));
//		HdmiOutp8(rHDMI_V_BLANK_F_1, (u8)(uTemp32 >> 8));
//		HdmiOutp8(rHDMI_V_BLANK_F_2, (u8)(uTemp32 >> 16));

//		HdmiOutp8(rHDMI_V_SYNC_GEN2_0, (u8)(uvSYNC2Temp & 0xff));
//		HdmiOutp8(rHDMI_V_SYNC_GEN2_1, (u8)(uvSYNC2Temp >> 8));
//		HdmiOutp8(rHDMI_V_SYNC_GEN2_2, (u8)(uvSYNC2Temp >> 16));

//		HdmiOutp8(rHDMI_V_SYNC_GEN3_0, (u8)(uvSYNC3Temp & 0xff));
//		HdmiOutp8(rHDMI_V_SYNC_GEN3_1, (u8)(uvSYNC3Temp >> 8));
//		HdmiOutp8(rHDMI_V_SYNC_GEN3_2, (u8)(uvSYNC3Temp >> 16));
		uTemp32 = aVideoParams[ParamMode].VBLANK_F;
		uvSYNC2Temp = aVideoParams[ParamMode].VSYNCGEN2;
		uvSYNC3Temp = aVideoParams[ParamMode].VSYNCGEN3;

                g_pHDMICoreConfig->HDMI_V_BLANK_F0 = (UINT8)(uTemp32 & 0xff);
                g_pHDMICoreConfig->HDMI_V_BLANK_F1 = (UINT8)(uTemp32 >> 8);
                g_pHDMICoreConfig->HDMI_V_BLANK_F2 = (UINT8)(uTemp32 >> 16);

                g_pHDMICoreConfig->HDMI_V_SYNC_GEN2_0 = (UINT8)(uvSYNC2Temp & 0xff);
                g_pHDMICoreConfig->HDMI_V_SYNC_GEN2_1 = (UINT8)(uvSYNC2Temp >> 8);
                g_pHDMICoreConfig->HDMI_V_SYNC_GEN2_2 = (UINT8)(uvSYNC2Temp >> 16);

                g_pHDMICoreConfig->HDMI_V_SYNC_GEN3_0 = (UINT8)(uvSYNC3Temp & 0xff);
                g_pHDMICoreConfig->HDMI_V_SYNC_GEN3_1 = (UINT8)(uvSYNC3Temp >> 8);
                g_pHDMICoreConfig->HDMI_V_SYNC_GEN3_2 = (UINT8)(uvSYNC3Temp >> 16);

	}
	else
	{
		// progressive mode
//		HdmiOutp8(rHDMI_V_BLANK_F_0, 0x00);
//		HdmiOutp8(rHDMI_V_BLANK_F_1, 0x00);
//		HdmiOutp8(rHDMI_V_BLANK_F_2, 0x00);

//		HdmiOutp8(rHDMI_V_SYNC_GEN2_0, 0x01);
//		HdmiOutp8(rHDMI_V_SYNC_GEN2_1, 0x10);
//		HdmiOutp8(rHDMI_V_SYNC_GEN2_2, 0x00);

//		HdmiOutp8(rHDMI_V_SYNC_GEN3_0, 0x01);
//		HdmiOutp8(rHDMI_V_SYNC_GEN3_1, 0x10);
//		HdmiOutp8(rHDMI_V_SYNC_GEN3_2, 0x00);
                g_pHDMICoreConfig->HDMI_V_BLANK_F0 = (UINT32)(0x00);
                g_pHDMICoreConfig->HDMI_V_BLANK_F1 = (UINT32)(0x00);
                g_pHDMICoreConfig->HDMI_V_BLANK_F2 = (UINT32)(0x00);

                g_pHDMICoreConfig->HDMI_V_SYNC_GEN2_0 = (UINT32)(0x01);
                g_pHDMICoreConfig->HDMI_V_SYNC_GEN2_1 = (UINT32)(0x10);
                g_pHDMICoreConfig->HDMI_V_SYNC_GEN2_2 = (UINT32)(0x00);

                g_pHDMICoreConfig->HDMI_V_SYNC_GEN3_0 = (UINT32)(0x01);
                g_pHDMICoreConfig->HDMI_V_SYNC_GEN3_1 = (UINT32)(0x10);
                g_pHDMICoreConfig->HDMI_V_SYNC_GEN3_2 = (UINT32)(0x00);

	}

	// set interlaced mode
//	HdmiOutp8(rHDMI_INT_PRO_MODE,aVideoParams[mode].interlaced);
        g_pHDMICoreConfig->HDMI_INT_PRO_MODE = (UINT8)aVideoParams[ParamMode].interlaced;
    
	// pixel repetition
//	ucTemp8 = HdmiInp8(rHDMI_CON_1);
	ucTemp8 = (UINT8)g_pHDMICoreConfig->HDMI_CON1;

	// clear 
//	ucTemp8 &= ~ HDMI_CON_PXL_REP_RATIO_MASK;
	ucTemp8 &= ~ HDMI_CON_PXL_REP_RATIO_MASK;

//	if (aVideoParams[mode].repetition)
	if (aVideoParams[ParamMode].repetition)
	{
		// set pixel repetition        
//		ucTemp8 |= HDMI_DOUBLE_PIXEL_REPETITION;
		// AVI Packet
//		HdmiOutp8(rHDMI_AVI_BYTE5,AVI_PIXEL_REPETITION_DOUBLE);

		// set pixel repetition        
		ucTemp8 |= HDMI_DOUBLE_PIXEL_REPETITION;
		// AVI Packet
                g_pHDMICoreConfig->HDMI_AVI_BYTE5 = (UINT8)AVI_PIXEL_REPETITION_DOUBLE;

	}
	else // clear pixel repetition
	{
		//AVI Packet 
//		HdmiOutp8(rHDMI_AVI_BYTE5,0x00);
                g_pHDMICoreConfig->HDMI_AVI_BYTE5 = (UINT8)0x00;
	}
	
	// set pixel repetition
//	HdmiOutp8(rHDMI_CON_1,ucTemp8 );
	g_pHDMICoreConfig->HDMI_CON1 = (UINT8)ucTemp8;
    
	// set AVI packet VIC
//	if (pixelRatio == HDMI_PIXEL_RATIO_16_9)
	if (ePixelAspectRatio == HDMI_PIXEL_RATIO_16_9)
//		HdmiOutp8(rHDMI_AVI_BYTE4, aVideoParams[mode].vAVI_VIC_16_9);
            g_pHDMICoreConfig->HDMI_AVI_BYTE4 = (UINT8)aVideoParams[ParamMode].vAVI_VIC_16_9;
	else
//		HdmiOutp8(rHDMI_AVI_BYTE4, aVideoParams[mode].vAVI_VIC);
            g_pHDMICoreConfig->HDMI_AVI_BYTE4 = (UINT8)aVideoParams[ParamMode].vAVI_VIC;

	// clear
//	ucTemp8 = HdmiInp8(rHDMI_AVI_BYTE2) & ~(AVI_PICTURE_ASPECT_4_3 | AVI_PICTURE_ASPECT_16_9);
	ucTemp8 = (g_pHDMICoreConfig->HDMI_AVI_BYTE2) & ~(AVI_PICTURE_ASPECT_4_3 | AVI_PICTURE_ASPECT_16_9);

//	if (pixelRatio == HDMI_PIXEL_RATIO_16_9)
	if (ePixelAspectRatio == HDMI_PIXEL_RATIO_16_9)
	{
		ucTemp8 |= AVI_PICTURE_ASPECT_16_9;
	}
	else
	{
		ucTemp8 |= AVI_PICTURE_ASPECT_4_3;
	}

	// set AVI packet MM
//	HdmiOutp8(rHDMI_AVI_BYTE2, ucTemp8);
	g_pHDMICoreConfig->HDMI_AVI_BYTE2 = (UINT8) ucTemp8;
    
	// set color depth
        HDMI_SetColorDepth(cd);

	//rb1004.....GCP Control : Interlaced check
	if(aVideoParams[ParamMode].interlaced == 1)
	{
		UINT32 uGcpCon;

//		uGcpCon = HdmiInp8(rHDMI_GCP_CON);
                uGcpCon = g_pHDMICoreConfig->HDMI_GCP_CON;
		uGcpCon |=  (3<<2);

//		HdmiOutp8(rHDMI_GCP_CON, uGcpCon);
                g_pHDMICoreConfig->HDMI_GCP_CON = uGcpCon;
	}
	else
	{
		UINT32 uGcpCon;

//		uGcpCon = HdmiInp8(rHDMI_GCP_CON);
		uGcpCon = g_pHDMICoreConfig->HDMI_GCP_CON;
		uGcpCon &= (~(3<<2));

//		HdmiOutp8(rHDMI_GCP_CON, uGcpCon);
		g_pHDMICoreConfig->HDMI_GCP_CON = uGcpCon;
	}


	// config Phy
/*		
#if 1	
	if (PHYConfig(aVideoParams[ParamMode].PixelClock, cd) == 0)
	{
//		UART_Printf("PHYConfig() failed.\n");
                RETAILMSG(TVOUT_ZONE_HDMI,(_T("[HDMI] PhyConfig Error\n\r")));
		return ;
	}	
	else
	{
		UINT32 i;

		// CMU Block : HDMI_SEL(SCLK_HDMI) - 0 : SCLK_PIXEL, 1 : SCLK_HDMIPHY
		uTemp32 = Inp32(0xE0100204);
		uTemp32 |= (1<<0);
		Outp32(0xE0100204, uTemp32);	

		// CMU Block : MIXER_SEL(SCLK_MIXER) - 0 : SCLK_DAC,  1 : SCLK_HDMI
		uTemp32 = Inp32(0xE0100204);
		uTemp32 |= (1<<4);
		Outp32(0xE0100204, uTemp32);

	}
#endif
*/        
    }
        
}

#endif

