/**
 *  HDMI library is responsible for setting HDMI audio/video/control registers
 */

#ifndef __HDMI_LIBRARY__
#define __HDMI_LIBRARY__

#include "video.h"
#include "audio.h"
#include "hdmireg.h"

#if __cplusplus
    extern "C"
    {
#endif

// initialize HDMI library. 
// map physical address. request HDCP/HPD system interrupt
// create events, initialize interrupts 
//int HDMIInit(VOID); 
// AP team request
BOOL HDMIInit(PHDMI_SS_REG       pSSReg, 
                PHDMI_CORE_REG  pCoreReg, 
                PHDMI_HDCP_REG  pHDCPReg,
                PHDMI_EFUSE_REG pEfuseReg,
                PHDMI_I2S_REG   pI2SReg,
                PHDMI_SPDIF_REG pSPDIFReg,
                PCMU_CLK_REG    pCMUCLKReg,
                PIIC_REG        pIICReg);

// deinitialize HDMI library.
// unmap physical address. release HDCP/HPD system interrupt
// close events, disable interrupts 
BOOL HDMIDeInit(VOID);

// HDMI interrupt handler
BOOL HDMIEventHandler(VOID);

// set hdmi video registers, set up AVI packets
BOOL HDMISetVideoMode(HDMI_VIDEO_PARAMETER* pHDMIVideoParam);

// set hdmi audio registers and audio input HW block, set up AUI/ACR packets 
BOOL HDMISetAudioMode(HDMI_AUDIO_PARAMETER* pHDMIAudioParam);

// set MPEG InfoFrame packet body.
BOOL HDMISetMPGInfoFrame(PBYTE pucPacketBody);

// start/stop transmitting MPEG InfoFrame packet
BOOL HDMIEnableMPGInfoFrame(BOOL bEn);

// set SPD InfoFrame packet body
BOOL HDMISetSPDInfoFrame(PBYTE pucPacketBody);

// start/stop transmitting SPD InfoFrame packet or not
BOOL HDMIEnableSPDInfoFrame(BOOL bEn);

// set GAMUT packet body
BOOL HDMISetGamutDataPacket(PBYTE pucPacketHeader, 
                            PBYTE pucPacketBody, 
                            BYTE ucPacketBodySize);

// start/stop transmitting GAMUT packet or not
BOOL HDMIEnableGamutDataPacket(BOOL bEn);


// set bluescreen color
BOOL HDMISetBlueScreenColor(BYTE ucCbB,BYTE ucYG, BYTE ucCrR);

// enable/disable bluescreen mode
BOOL HDMISetBlueScreen(BOOL bEn);

// enable/disable AV Mute mode
BOOL HDMISetAVMute(BOOL bEn);

// start/stop transmitting Audio 
BOOL HDMIAudioEnable(BOOL bEn);

// start transmitting HDMI output
BOOL HDMIStart(VOID);

// stop transmitting HDMI output
BOOL HDMIStop(VOID);

// set pixel color range
BOOL HDMISetColorRange(BYTE ucYMin,BYTE ucYMax,
                        BYTE ucCMin,BYTE ucCMax);

// set speaker allocation information 
BOOL HDMISetSpeakerAllocation(BYTE ucInfo);

/**
 * AP team request to expose interfaces for controlling HDCP
 */

// start processing the HDCP authenticaion
BOOL HDCPStart(void);

// stop processing the HDCP authenticaion
BOOL HDCPStop(void);



/**
 * interfaces related to HPD
 */

typedef VOID HPDCallBack(DWORD);

// register HPD callback function 
BOOL HPDSetCallback(HPDCallBack* callbackfn);

// get HPD current state
BYTE HPDGetStatus(VOID);

// start detecting HPD signal
BOOL HPDStart(VOID);

// stop detiecting HPD signal
BOOL	HPDStop(VOID);

BOOL SetHDMIPHYOnOff(BOOL bEn);

#if __cplusplus
    }
#endif

#endif /* __HDMI_LIBRARY__ */