/**
 * DDC library is responsible for DDC communication
 * DDC is used for both EDID and HDCP. 
 * So library should guarantee that only one user uses DDC driver one time. 
 * if the driver manages this, DDC library does not need to manage it.
 */

#ifndef __DDC_LIBRARY__
#define __DDC_LIBRARY__

#include <windows.h>

#if __cplusplus
    extern "C"
    {
#endif

// initialize DDC driver
BOOL DDCInit(VOID);

// deinitialize DDC driver
BOOL DDCDeInit(VOID);

// read data through DDC (fast read)
BOOL DDCRead(BYTE ucDevAddr,BYTE ucOffset, UINT32 uiSize, PBYTE pucData);

// write data through DDC
BOOL DDCWrite(BYTE ucDevAddr,BYTE ucOffset, UINT32 uiSize, PBYTE pucData);

// read data though DDC by using E-DDC protocol
BOOL EDDCReadEDID(BYTE ucSegNum, BYTE ucDevAddr,UINT32 uiOffset, BYTE ucSize, PBYTE pucData);

#if __cplusplus
    }
#endif

#endif /* __DDC_LIBRARY__ */