//-------------------------------------------------------------------
// Copyright SAMSUNG Electronics Co., Ltd
// All right reserved.
//
// This software is the confidential and proprietary information
// of Samsung Electronics, Inc. ("Confidential Information").  You
// shall not disclose such Confidential Information and shall use
// it only in accordance with the terms of the license agreement
// you entered into with Samsung Electronics. 
//-------------------------------------------------------------------

#ifndef _I2C_HDMI_H_
#define _I2C_HDMI_H_

#ifdef __cplusplus
extern "C"
{
#endif

/*
 * I2C related
 */
// i2c-bus control register (ICCR)
#define I2C_ACK				(1<<7)
#define I2C_INT				(1<<5)
#define I2C_PEND			(1<<4)

#define I2C_INT_CLEAR		(0<<4)

#define I2C_CLK				(0x41)   
//#define I2C_CLK				(0x40)  

// i2c-bus control/status register (ICSR)
#define I2C_ENABLE			(1<<4)
#define I2C_START			(1<<5)

#define I2C_MODE_MTX		0xC0
#define I2C_MODE_MRX		0x80

#define I2C_STAT_ARBITRERR		(1<<3)
#define I2C_STAT_ADDRASSLAVE	(1<<2)
#define I2C_STAT_ADDRZERO		(1<<1)
#define I2C_STAT_ACKERROR		(1<<0)

#define I2C_IDLE				0

// i2c-bus stop register (STOPCON)
#define I2C_STOP				(1<<0)
#define I2C_NO_ACK			(1<<2)

typedef enum
{
	STATE_IDLE,
	STATE_TX_EDDC_SEGADDR,
	STATE_TX_EDDC_SEGNUM,
	STATE_TX_DDC_ADDR,
	STATE_TX_DDC_OFFSET,
	STATE_RX_DDC_ADDR,
	STATE_RX_DDC_DATA,
	STATE_RX_ADDR,
	STATE_RX_DATA,
	STATE_TX_ADDR,
	STATE_TX_DATA,
	STATE_TX_STOP,
	STATE_RX_STOP
}state;


BOOL I2CHDMI_Init( void* pSysConReg, void * pIICReg);
BOOL I2CHDMI_Read(UINT8 ucAddr, UINT8 ucBytes, UINT8 *pBuffer);
BOOL I2CHDMI_Write(UINT8 ucAddr, UINT8 ucBytes, UINT8 *pBuffer);

#ifdef __cplusplus
}
#endif

#endif  /* _I2C_HDMI_H_ */
