//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
#ifndef _SDMMC_Ch2_H_
#define _SDMMC_Ch2_H_

#include "../SDMMC_LIB/SDHC.h"


// Macros on Clock gating

// Clock & Power
#define CLK_SRC0_EPLL_SEL           (~(0x1<<8))     // Control MUXepll
#define CLK_SRC0_MUXepll            (0x1<<8)        // FOUTepll

#define CLK_SRC2_MMC0_SEL           (~(0x3<<0))     // Control MUXmmc0
#define CLK_SRC2_MUXmmc0            (0x0<<0)        // MOUTepll

#define CLK_DIV3_MMC0_RATIO         (~(0xf<<0))     // DIVmmc0 clock divider ratio
#define CLK_DIV3_DIVmmc0            (0x0<<0)        // CLKMMC0 = CLKMMC0in / 1

#define CLK_GATE_D1_0_MMC0          (~(0x1<<5))     // HCLK for MMC0
#define CLK_GATE_D1_0_MMC0_PASS     (0x1<<5)        // HCLK for MMC0 pass

#define CLK_GATE_SCLK_0_MMC0        (~(0x1<<12))    // Special clock for MMC0
#define CLK_GATE_SCLK_0_MMC0_PASS   (0x1<<12)       // Special clock for MMC0 pass

#define CLK_GATE_SCLK_0_MMC0_48     (~(0x1<<15))    // Special clock 48MHz for MMC0
#define CLK_GATE_SCLK_0_MMC0_48_PASS (0x1<<15)      // Special clock 48MHz for MMC0 pass


typedef class CSDHControllerCh2 : public CSDHCBase {

    public:

        // Constructor
        CSDHControllerCh2() : CSDHCBase() {}

        // Destructor
        virtual ~CSDHControllerCh2() {}

        // Perform basic initialization including initializing the hardware
        // so that the capabilities register can be read.
        virtual BOOL Init(LPCTSTR pszActiveKey);

        virtual VOID PowerUp();

        virtual LPSDHC_DESTRUCTION_PROC GetDestructionProc()
        {
            return &DestroySDMMCHCCh2Object;
        }

        static VOID DestroySDMMCHCCh2Object(PCSDHCBase pSDHC);

    protected:

        BOOL InitClkPwr(void);

        BOOL InitGPIO(void);

        BOOL InitSDMMC(void);

        BOOL InitCh(void);

} *PCSDHControllerCh2;

#endif // _SDMMC_Ch2_H_

