//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
// Copyright (c) Samsung Electronics. Co. LTD. All rights reserved.

/*++

THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:

power_control.h

Abstract:

   Low Level HW Block Power control interface

Functions:

    

Notes:

--*/

#ifndef _S5PV210_POWER_CONTROL_H_
#define _S5PV210_POWER_CONTROL_H_

#include <dvfs.h>
#include <max8698.h>

#define DVFS_LEVEL_MAX      4

void PMIC_VoltageSet(void*g_pCMUGCTRLRegs, void *pGPIOReg, UINT32 ARM_VOL, UINT32 INT_VOL);

void DVFS_L1_L4ClockChange(void *pCMUCLKreg, void *pDMC0reg, void *pDMC1reg, UINT32 TargetLevel);
void DVFS_L0toL1ClockChange(void *pCMUCLKreg, void *pDMC0reg, void *pDMC1reg, UINT32 TargetLevel);
void DVFS_L1toL0ClockChange(void *pCMUCLKreg, void *pDMC0reg, void *pDMC1reg, UINT32 TargetLevel);

BOOL PwrCon_initialize_register_address(void *pCMUCLKRegs, void *pCMUMISCRegs, void *pPMUPMRegs, void *pPMUMISCRegs);
BOOL PwrCon_set_block_power_on(BLKPWR_DOMAIN eDomain);
BOOL PwrCon_set_block_power_off(BLKPWR_DOMAIN eDomain);
BOOL PwrCon_set_IP_clock_on(CLK_IP_LIST IP_LIST);
BOOL PwrCon_set_IP_clock_off(CLK_IP_LIST IP_LIST);
BOOL PwrCon_set_analog_power_on(CLK_IP_LIST IP_LIST);
BOOL PwrCon_set_analog_power_off(CLK_IP_LIST IP_LIST);
//RESET_STATUS PwrCon_get_reset_status(void);

#endif    // _S5PV210_POWER_CONTROL_H_

