/*
 * Project Name MFC DRIVER IN WINCE
 * Copyright  2009 Samsung Electronics Co, Ltd. All Rights Reserved.
 *
 * This file implements MFC driver.
 *
 * @name MFC DRIVER Module (MfcOpr.c)
 * @author Jiyoung Shin (idon.shin@samsung.com)
 * @date 2009/06/05
 */

#ifndef __SAMSUNG_SYSLSI_APDEV_MFC_DEC_OPR_H__
#define __SAMSUNG_SYSLSI_APDEV_MFC_DEC_OPR_H__

#include <windows.h>
#include "string.h"
#include "MfcInterface.h"
#include "SsbSipMfcApi.h"

#ifdef __cplusplus
extern "C" {
#endif

#define MFC_CODEC_CMD_DEC_HEADER        (1<<16)
#define MFC_CODEC_CMD_DEC_FRAME         (2<<16)
#define MFC_CODEC_CMD_DEC_LAST_FRAME    (3<<16)
#define MFC_CODEC_CMD_DEC_INIT_BUFF     (4<<16)

#define MFC_CODEC_CMD_ENC_HEADER        (1<<16)
#define MFC_CODEC_CMD_ENC_FRAME         (2<<16)
#define MFC_CODEC_CMD_ENC_LAST_FRAME    (3<<16)

#define PIXEL_CACHE_ON                  (0)
#define PIXEL_CACHE_OFF                 (3)

#define ENABLE_H264_DISPLAY_DELAY       (1<<30)
#define ENABLE_SLICE_BASED_IF           (1<<31)

#define CRC_GENERATION_BIT              (31)

#define MFC_PROGRESSIVE_FRAME           (0)
#define MFC_INTERLACED_FRAME            (1)

#define RC_CHANGE_ENABLE_BIT_RATE       (1<<2)
#define RC_CHANGE_ENABLE_FRAME_RATE     (1<<1)
#define RC_CHANGE_ENABLE_I_PERIOD       (1<<0)

#define RC_FIXED_TARGET_BIT_ENABLE      (1<<0)
#define RC_FIXED_TARGET_BIT_DISABLE     (0<<0)

typedef enum
{
	STREAM_BUF_FRAME_MODE               = 1,
	STREAM_BUF_DOUBLE_BUF_MODE          = 0
} MFC_EDFU_STR_BUF_MODE;

typedef enum
{
	MB_LINEAR_MODE                      = 0,
	MB_TILE_MODE_FOR_ENC                = 2,
	MB_TILE_MODE_FOR_DEC                = 3
} MFC_MB_LINEAR_TILE_MODE;

SSBSIP_MFC_ERROR_CODE MFCOpen();
SSBSIP_MFC_ERROR_CODE MFCEncodeInit(MFC_INST_CTX  *MfcCtx,  ARGS *args);
SSBSIP_MFC_ERROR_CODE MFCEncodeExe(MFC_INST_CTX  *MfcCtx,  ARGS *args);
SSBSIP_MFC_ERROR_CODE MFCDecodeInit(MFC_INST_CTX  *MfcCtx,  ARGS *args);
SSBSIP_MFC_ERROR_CODE MFCDecodeBufferInit(MFC_INST_CTX  *MfcCtx,  ARGS *args);
SSBSIP_MFC_ERROR_CODE MFCDecodeExe(MFC_INST_CTX  *MfcCtx,  ARGS *args);
SSBSIP_MFC_ERROR_CODE MFCGetConfig(MFC_INST_CTX  *MfcCtx,  ARGS *args);
SSBSIP_MFC_ERROR_CODE MFCSetConfig(MFC_INST_CTX  *MfcCtx,  ARGS *args);
SSBSIP_MFC_ERROR_CODE MFCClose(MFC_INST_CTX  *MfcCtx);
SSBSIP_MFC_ERROR_CODE SetMFCSleep(MFC_INST_CTX  *MfcCtx);
SSBSIP_MFC_ERROR_CODE SetMFCWakeUp(MFC_INST_CTX  *MfcCtx);

#ifdef __cplusplus
}
#endif

#endif //__SAMSUNG_SYSLSI_APDEV_MFC_DEC_OPR_H__

