/*
 * Project Name MFC DRIVER IN WINCE
 * Copyright  2009 Samsung Electronics Co, Ltd. All Rights Reserved.
 *
 * This file implements MFC driver.
 *
 * @name MFC DRIVER Module (MfcCommon.h)
 * @author Jiyoung Shin (idon.shin@samsung.com)
 * @date 2009/06/05
 */

#ifndef __SAMSUNG_SYSLSI_MFC_COMMON_H__
#define __SAMSUNG_SYSLSI_MFC_COMMON_H__

#include "mfc_reg.h"
#include "MfcInterface.h"

#ifdef __cplusplus
extern "C" {
#endif

#define BUF_ALIGN_UNIT      (64)
#define OffsetAddr(x)       (x&0x0fffffff)

typedef enum
{
    MFCINST_STATE_NULL = 0,

    MFCINST_STATE_OPENED         = 10,    // Instance is created
    MFCINST_STATE_DEC_INITIALIZE = 20,    // channel_set and init_codec is completed
    MFCINST_STATE_DEC_BUFFER_INIT,        // init buffer is completed
    MFCINST_STATE_DEC_EXE,

    MFCINST_STATE_ENC_INITIALIZE = 40,    // Instance is initialized for encoding
    MFCINST_STATE_ENC_EXE
} MFCINST_STATE;

typedef enum
{
    MEM_STRUCT_LINEAR           = 0,
    MEM_STRUCT_TILE_ENC         = 2, // 16x16
    MEM_STRUCT_TILE_DEC         = 3  // 64x32
}MFC_MEM_TYPE;

typedef enum
{
    MFC_H2R_CMD_EMPTY           = 0,
    MFC_H2R_CMD_OPEN_CH         = 1,
    MFC_H2R_CMD_CLOSE_CH        = 2,
    MFC_H2R_CMD_SYS_INIT        = 3,
    MFC_H2R_CMD_MC_BASE_INIT    = 4,
    MFC_H2R_CMD_SYS_SLEEP       = 5,
    MFC_H2R_CMD_SYS_WAKEUP      = 6,
    MFC_H2R_CMD_CONTINUE_ENC    = 7,
}MFC_FACADE_CMD;

typedef enum
{
    MFC_R2H_CMD_EMPTY                   = 0,
    MFC_R2H_CMD_OPEN_CH_RET             = 1,
    MFC_R2H_CMD_CLOSE_CH_RET            = 2,
    MFC_R2H_CMD_SEQ_DONE_RET            = 4,
    MFC_R2H_CMD_FRAME_DONE_RET          = 5,
    MFC_R2H_CMD_SLICE_DONE_RET          = 6,
    MFC_R2H_CMD_ENC_COMPLETE_RET        = 7,
    MFC_R2H_CMD_SYS_INIT_RET            = 8,
    MFC_R2H_CMD_FW_STATUS_RET           = 9,
    MFC_R2H_CMD_SYS_SLEPP_RET           = 10,
    MFC_R2H_CMD_SYS_WAKEUP_RET          = 11,
    MFC_R2H_CMD_INIT_BUFFER_RET         = 15,
    MFC_R2H_CMD_EDFU_INIT_RET           = 16,
    MFC_R2H_CMD_ERR_RET                 = 32
}MFC_FACADE_RESPONSE;

typedef enum
{
    MFC_WAIT_DONE_INTR = 0,
    MFC_WAIT_DONE_POLLING
}MFC_WAIT_DONE_MODE;



typedef enum
{
    MFC_RET_FRAME_NOT_CODED         = 0,
    MFC_RET_FRAME_I_FRAME           = 1,
    MFC_RET_FRAME_P_FRAME           = 2,
    MFC_RET_FRAME_B_FRAME           = 3
}MFC_FRAME_TYPE;


typedef struct tagMFCInstCtx
{
    DWORD               dwAccess;       // for Power Management.
    SSBSIP_MFC_CODEC_TYPE      MfcCodecType;
    MFCINST_STATE       MfcState;
    int                 InstNo;         // instance ID which is decided in MFC driver. It'll be used for instance management & power management.
    int                 ChID;           // instance ID which is returned value from MFC H/W

    MFC_FRAME_TYPE      FrameType;
    unsigned int        SliceEnable;
    unsigned int        CrcEnable;
    unsigned int        DPBCnt;
    unsigned int        DPBSize;
    unsigned int        extraDPB;
    unsigned int        displayDelay;
    unsigned int        postEnable;
    unsigned int        endOfFrame;
    unsigned int        forceSetFrameType;
    unsigned int        img_width;
    unsigned int        img_height;
    unsigned int        IsPackedPB;
    unsigned int        pixelCacheEnable;
    unsigned int        YSize;
    unsigned int        CbSize;
    unsigned int        MVSize;
    unsigned int        timeIncrement;
}MFC_INST_CTX;

unsigned int   GetMfcCodecType(SSBSIP_MFC_CODEC_TYPE    codec_type);
void  InitInstanceNo();
int GetInstanceNo();
void ReturnInstanceNo(int inst_no);
int SetMfcState(MFC_INST_CTX *ctx, MFCINST_STATE state);
void MFCDelay(UINT32 count);
BOOL IsMFCRunning();

#ifdef __cplusplus
}
#endif

#endif /* __SAMSUNG_SYSLSI_MFC_COMMON_H__ */

