/*
 * Project Name MFC DRIVER IN WINCE
 * Copyright  2009 Samsung Electronics Co, Ltd. All Rights Reserved.
 *
 * This file implements MFC driver.
 *
 * @name MFC DRIVER Module (MfcCommon.c)
 * @author Jiyoung Shin (idon.shin@samsung.com)
 * @date 2009/06/05
 */


#include <windows.h>
#include "MfcCommon.h"
#include "bsp_cfg.h"
#include "MfcInterface.h"
#include "MfcMemory.h"
#include "MfcLogMsg.h"
#include "MfcFW.h"

static int instanceNo[MFC_MAX_INSTANCE_NUM];


unsigned int   GetMfcCodecType(SSBSIP_MFC_CODEC_TYPE    codec_type)
{
    unsigned int    standardSel = 0;

    switch(codec_type){
        case H264_DEC    : standardSel = 0; break;
        case VC1_DEC     : standardSel = 1; break;
        case MPEG4_DEC   : 
        case XVID_DEC    : standardSel = 2; break;
        case MPEG1_DEC   :
        case MPEG2_DEC   : standardSel = 3; break;
        case H263_DEC    : standardSel = 4; break;     
        case VC1RCV_DEC  : standardSel = 5; break; 
        case DIVX311_DEC : standardSel = 6; break; 
        case DIVX412_DEC : standardSel = 7; break; 
        case DIVX502_DEC : standardSel = 8; break; 
        case DIVX503_DEC : standardSel = 9; break; 
        case H264_ENC    : standardSel = 16; break; 
        case MPEG4_ENC   : standardSel = 17; break; 
        case H263_ENC    : standardSel = 18; break; 
        default : LOG_MSG(LOG_ERROR, "GetMfcCodecType", "unknown codec type\n");
    }

    return standardSel;
}

void  InitInstanceNo()
{
    memset(&instanceNo, 0x00, sizeof(instanceNo));
}

int GetInstanceNo()
{
    unsigned int    i;

    for(i = 0; i < MFC_MAX_INSTANCE_NUM; i++)
        if(instanceNo[i] == 0){
            instanceNo[i] = 1;
            return i;
        }

    return -1;   
}


void ReturnInstanceNo(int inst_no)
{
    if((inst_no >= 0) && (inst_no < MFC_MAX_INSTANCE_NUM))
        instanceNo[inst_no] = 0;

}


BOOL IsMFCRunning()
{
    unsigned int    i;
    BOOL ret = FALSE;

    for(i = 1; i < MFC_MAX_INSTANCE_NUM; i++)
        if(instanceNo[i] == 1)
            ret = TRUE;

    return ret;  
}

int SetMfcState(MFC_INST_CTX *ctx, MFCINST_STATE state)
{

    if(ctx->MfcState > state)
        return 0;

    ctx->MfcState = state;
    return  1;

}

void MFCDelay(UINT32 count) // 100usec
{
#if 0
    volatile int i, j = 0;
    volatile static int loop = 10000;

    for(;count > 0;count--)
        for(i=0;i < loop; i++) { j++; }
#else
    Sleep(count);
#endif
}
