//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:  

keybdpdd.h

Abstract:  

Interface to the PDD layer of the keyboard interface.

Notes: 

The keyboard model device driver (MDD) uses this standard PDD interface to 
provide keyboard functionality.

--*/

//file added by szh 2007.06.13 - SPR_KEYBD_FTR 

#ifndef hhhhhhh
#define hhhhhhh

#ifdef __cplusplus
extern "C" {
#endif


#ifdef POWERKEY
	//0-->key UP   1-->key DOWN
	BOOL PowerKeyDownFlag=0;	
	BOOL CameraKeyDownFlag=0;
	BOOL LockKeyDownFlag=0;

	DWORD PowerKeydownStartTime=0;
	DWORD PowerKeydownNowTime=0,PowerKeydownDlay=0;
#endif
	
extern DWORD gIntrKeyboard;

// lqm added for K390.10-06-13
#define VK_0    0x30
#define VK_1    0x31
#define VK_2    0x32
#define VK_3    0x33
#define VK_4    0x34
#define VK_5    0x35
#define VK_6    0x36
#define VK_7    0x37
#define VK_8    0x38
#define VK_9    0x39
#define VK_A    0x41
#define VK_B    0x42
#define VK_C    0x43
#define VK_D    0x44
#define VK_E    0x45
#define VK_F    0x46
#define VK_G    0x47
#define VK_H    0x48
#define VK_I    0x49
#define VK_J    0x4A
#define VK_K    0x4B
#define VK_L    0x4C
#define VK_M    0x4D
#define VK_N    0x4E
#define VK_O    0x4F
#define VK_P    0x50
#define VK_Q    0x51
#define VK_R    0x52
#define VK_S    0x53
#define VK_T    0x54
#define VK_U    0x55
#define VK_V    0x56
#define VK_W    0x57
#define VK_X    0x58
#define VK_Y    0x59
#define VK_Z    0x5A
// end added.
/*
// lqm added for app test.
typedef struct
{
	int COL1FLAG;
	int COL2FLAG;
	int COL3FLAG;
	int COL4FLAG;
}MRX_FLAG;
*/
//      @DOC    EXTERNAL DRIVERS KEYBD_DRIVER
/*      @FUNC   BOOL |
				KeybdPdd_DllEntry |
				Called by the MDD when the keyboard driver is loaded.

		@PARM	HANDLE	| hinstDLL
		@PARM	DWORD	| Op
		@PARM	LPVOID	| lpvReserved

		@RDESC	Returns 0 to fail the driver load; non-zero for success.

*/
BOOL
WINAPI
KeybdPdd_DllEntry(
	HANDLE  hinstDLL,
	DWORD   Op,
	LPVOID  lpvReserved
	);





//      @DOC    EXTERNAL DRIVERS KEYBD_DRIVER
/*      @FUNC   INT	|
				KeybdPdd_GetEvent |
				Called by the MDD to get key events from the PDD layer.

        @PARM   UINT32			| VirtualKeys[16]
        @PARM   KEY_STATE_FLAGS	| KeyEvents[16]

		@RDESC	Returns the number of key events.

		@COMM

The PDD can return up to 16 key events.

		@COMM

If the keyboard needs to be scanned periodically, the MDD should be 
awakened periodically by signalling the keyboard interrupt.  This 
mechanism should not be allowed to run freely however since the driver 
thread will use all available processor time.  

		@COMM

0 is a valid return value if no new key events are detected.

*/
INT
WINAPI
KeybdPdd_GetEvent(
	UINT32			VirtualKeys[16],
	KEY_STATE_FLAGS	KeyEvents[16]
	);

INT
WINAPI
KeybdPdd_GetEventEx(
	UINT32			VirtualKeys[16],
	UINT32			ScanCodes[16],
	KEY_STATE_FLAGS	KeyEvents[16]
	);



//      @DOC    EXTERNAL DRIVERS KEYBD_DRIVER
/*      @FUNC   void |
				KeybdPdd_PowerHandler |
				Called by the MDD when the device is powering up or down

		@PARM	BOOL	bOff | non-zero if the device is powering off, 0 if powering on.

		@COMM

This function is called in a kernel context and may not make any system 
call or cause any kind of rescheduling.  It is pretty much limited to 
accessing its own memory.  

*/
void
WINAPI
KeybdPdd_PowerHandler(
	BOOL	bOff
	);



BOOL
WINAPI
KeybdPdd_InitializeDriver(
	PFN_KEYBD_EVENT_CALLBACK	pfnKeybdEventCallback
	);

BOOL
WINAPI
KeybdPdd_InitializeDriverEx(
	PFN_KEYBD_EVENT_CALLBACK_EX	pfnKeybdEventCallbackEx
	);

void
WINAPI
KeybdPdd_ToggleKeyNotification(
	KEY_STATE_FLAGS	KeyStateFlags
	);

KEY_STATE_FLAGS
WINAPI
KeybdPdd_KeyStateToggled(
	void
	);


#ifdef __cplusplus
}
#endif


#endif

