/*
 * Project Name MFC DRIVER IN WINCE
 * Copyright  2009 Samsung Electronics Co, Ltd. All Rights Reserved.
 *
 * This file implements MFC driver.
 *
 * @name MFC DRIVER Module (MfcPower.c)
 * @author Jiyoung Shin (idon.shin@samsung.com)
 * @date 2009/06/05
 */



#include <windows.h>
#include <register_map.h>
#include <bsp.h>
#include "bsp_args.h"
#include "DrvLib_mem.h"
#include "pmplatform.h"
#include "JPGPower.h"

HANDLE   hPwrControl;
HANDLE   PWC_msgQ = NULL;

BOOL JPGPowerInit()
{
    DBGMSG(JPG_FUNC,(_T("[JPGDRV] %s++\r\n"), _T(__FUNCTION__)));
    hPwrControl = CreateFile( L"PWC0:", GENERIC_READ|GENERIC_WRITE, FILE_SHARE_READ|FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, 0);
    if (INVALID_HANDLE_VALUE == hPwrControl )
    {
        ERRMSG((_T("[JPGDRV] %s :: Power initialization failed\r\n"), _T(__FUNCTION__)));
        return FALSE;
    } 

    return TRUE;
}

BOOL JPGPowerOnOff(int on_off)
{
    DWORD dwIPIndex = PWR_IP_JPEG;
    DWORD dwBytes;    
    static int isOn = 0;

    if (on_off == 0)
    {
        if(isOn == 1)
        {
            isOn = 0;

            if ( !DeviceIoControl(hPwrControl, IOCTL_PWRCON_SET_POWER_OFF, &dwIPIndex, sizeof(DWORD), NULL, 0, &dwBytes, NULL) )
            {
                ERRMSG((_T("[JPGDRV] %s :: Power Off Failed\r\n"), _T(__FUNCTION__)));
                return FALSE;
            }            

            DBGMSG(JPG_DBG,(_T("[JPGDRV] POWER_OFF\r\n")));
        }
    }
    else 
    {
        if(isOn == 0)
        {
            isOn = 1;
            
            if ( !DeviceIoControl(hPwrControl, IOCTL_PWRCON_SET_POWER_ON, &dwIPIndex, sizeof(DWORD), NULL, 0, &dwBytes, NULL) )
            {
                ERRMSG((_T("[JPGDRV] %s :: Power On Failed\r\n"), _T(__FUNCTION__)));
                return FALSE;
            }        
            Sleep(10);
            DBGMSG(JPG_DBG,(_T("[JPGDRV] POWER_ON\r\n")));
        }
    }
    return TRUE;
}



BOOL JPGClockOnOff(int on_off)
{

    DWORD dwIPIndex = PWR_IP_JPEG;
    DWORD dwBytes;

    if (on_off == 0) {
        if ( !DeviceIoControl(hPwrControl, IOCTL_PWRCON_SET_CLOCK_OFF, &dwIPIndex, sizeof(DWORD), NULL, 0, &dwBytes, NULL) )
        {
            ERRMSG((_T("[JPGDRV] %s :: Clock off Failed\r\n"), _T(__FUNCTION__)));
            return FALSE;
        }
        DBGMSG(JPG_DBG,(_T("[JPGDRV] CLOCK_OFF\r\n")));
    }
    else {
        if ( !DeviceIoControl(hPwrControl, IOCTL_PWRCON_SET_CLOCK_ON, &dwIPIndex, sizeof(DWORD), NULL, 0, &dwBytes, NULL) )
        {
            ERRMSG((_T("[JPGDRV] %s :: Clock on Failed\r\n"), _T(__FUNCTION__)));
            return FALSE;
        }
        DBGMSG(JPG_DBG,(_T("[JPGDRV] CLOCK_ON\r\n")));
    }

    return TRUE;
}


#ifdef BSP_USEDVFS
BOOL JPGDvfsSetLevelFix()
{
    DWORD dwBytes;
    PROFILE_LIST dwLimit = HIGH_NORM_PERF;

    DBGMSG(JPG_FUNC,(_T("[JPGDRV] %s++\r\n"), _T(__FUNCTION__)));
    if(!DeviceIoControl(hPwrControl, IOCTL_DVFS_SET_PROFILE, &dwLimit, sizeof(DWORD),NULL,0,&dwBytes,NULL))
    {
        ERRMSG((_T("[JPGDRV] %s :: IOCTL_DVFS_SET_PROFILE Failed\r\n"), _T(__FUNCTION__)));
        return FALSE;
    }
    DBGMSG(JPG_FUNC,(_T("[JPGDRV] %s--\r\n"), _T(__FUNCTION__)));
    return TRUE;
}

BOOL JPGDvfsClearLevelFix()
{
    DWORD dwBytes;
    PROFILE_LIST dwLimit = HIGH_NORM_PERF;

    DBGMSG(JPG_FUNC,(_T("[JPGDRV] %s++\r\n"), _T(__FUNCTION__)));
    if(!DeviceIoControl(hPwrControl, IOCTL_DVFS_CLEAR_PROFILE, &dwLimit, sizeof(DWORD),NULL,0,&dwBytes,NULL))
    {
        ERRMSG((_T("[JPGDRV] %s :: IOCTL_DVFS_CLEAR_PROFILE Failed\r\n"), _T(__FUNCTION__)));
        return FALSE;
    }
    DBGMSG(JPG_FUNC,(_T("[JPGDRV] %s--\r\n"), _T(__FUNCTION__)));
    return TRUE;

}
#endif // BSP_USEDVFS

