/*
 * Project Name JPEG DRIVER IN WINCE
 * Copyright  2007 Samsung Electronics Co, Ltd. All Rights Reserved. 
 *
 * This software is the confidential and proprietary information
 * of Samsung Electronics  ("Confidential Information").   
 * you shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Samsung Electronics 
 *
 * This file implements JPEG driver.
 *
 * @name JPEG DRIVER MODULE Module (JPGOpr.h)
 * @author Jiyoung Shin (idon.shin@samsung.com)
 * @date 28-03-07
 */

#ifndef __JPG_OPR_H__
#define __JPG_OPR_H__

#include <windows.h>
#include "JPGMem.h"
#include "JPGApi.h"

typedef enum tagJPG_RETURN_STATUS
{
    JPG_FAIL,
    JPG_SUCCESS,
    OK_HD_PARSING,
    ERR_HD_PARSING,
    OK_ENC_OR_DEC,
    ERR_ENC_OR_DEC,
    ERR_UNKNOWN
} JPG_RETURN_STATUS;


typedef enum
{
    JPEG_FULL_CLK = 0, 
    JPEG_HALF_CLK
}JPG_CLK_MODE_T;

typedef struct tagJPG_DEC_PROC_PARAM{
	SAMPLE_MODE_T	sampleMode;
	ENCDEC_TYPE_T	decType;
    OUT_MODE_T      outFormat;
	UINT32	width;
	UINT32	height;
    UINT32  yuvwidth;
    UINT32  yuvheight;
	UINT32	dataSize;
	UINT32	fileSize;
} JPG_DEC_PROC_PARAM;

typedef struct tagJPG_ENC_PROC_PARAM{
	SAMPLE_MODE_T	sampleMode;
	ENCDEC_TYPE_T	encType;
    IN_MODE_T       inFormat;
	IMAGE_QUALITY_TYPE_T quality;
    MODE_Y16        mode_Y16;
    UINT32	width;
	UINT32	height;
	UINT32	dataSize;
	UINT32	fileSize;
} JPG_ENC_PROC_PARAM;

typedef struct tagJPG_ARGS {
	char* InBuf;
	char* phyInBuf;
	char* OutBuf;
	char* phyOutBuf;
	char* InThumbBuf;
	char* phyInThumbBuf;
	char* OutThumbBuf;
	char* phyOutThumbBuf;
	JPG_DEC_PROC_PARAM	*decParam;
	JPG_ENC_PROC_PARAM	*encParam;
	JPG_ENC_PROC_PARAM	*thumbEncParam;
} JPG_ARGS;

JPG_RETURN_STATUS decodeJPG(JPG_CTX*jCTX, JPG_DEC_PROC_PARAM *decParam);
void setInternalClock(int on_off);
void resetJPG();
JPG_RETURN_STATUS waitForIRQ(JPG_CTX*jCTX);
SAMPLE_MODE_T getSampleType();
UINT32 getYUVSize(SAMPLE_MODE_T sampleMode, OUT_MODE_T outFormat, UINT32 width, UINT32 height, UINT32 *yuvwidth, UINT32 *yuvheight);
JPG_RETURN_STATUS encodeJPG(JPG_CTX*jCTX, JPG_ENC_PROC_PARAM    *EncParam);

#endif
