/*
 * Project Name JPEG DRIVER IN WINCE
 * Copyright  2007 Samsung Electronics Co, Ltd. All Rights Reserved. 
 *
 * This software is the confidential and proprietary information
 * of Samsung Electronics  ("Confidential Information").   
 * you shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Samsung Electronics 
 *
 * This file implements JPEG driver.
 *
 * @name JPEG DRIVER MODULE Module (JPGMem.h)
 * @author Jiyoung Shin (idon.shin@samsung.com)
 * @date 28-03-07
 */

#ifndef __JPG_MEM_H__
#define __JPG_MEM_H__

#include <windows.h>
#include "jpg_reg.h"
#include "JPGApi.h"

#define JPG_REG_BASE_ADDR    (0xEE500000)

/*
#define MAX_JPG_WIDTH        3264
#define MAX_JPG_HEIGHT       2448

#define MAX_JPG_THUMBNAIL_WIDTH	 160
#define MAX_JPG_THUMBNAIL_HEIGHT 120

#define MAX_RGB_WIDTH        800
#define MAX_RGB_HEIGHT       480
*/

// memory area is 4k(PAGE_SIZE) aligned because of VirtualCopyEx()
#define JPG_STREAM_BUF_SIZE        ((MAX_JPG_WIDTH * MAX_JPG_HEIGHT )/PAGE_SIZE + 1)*PAGE_SIZE
#define JPG_STREAM_THUMB_BUF_SIZE  ((MAX_JPG_THUMBNAIL_WIDTH * MAX_JPG_THUMBNAIL_HEIGHT )/PAGE_SIZE + 1)*PAGE_SIZE
#define JPG_FRAME_BUF_SIZE         ((MAX_JPG_WIDTH * MAX_JPG_HEIGHT * 2)/PAGE_SIZE + 1)*PAGE_SIZE
#define JPG_FRAME_THUMB_BUF_SIZE   ((MAX_JPG_THUMBNAIL_WIDTH * MAX_JPG_THUMBNAIL_HEIGHT * 2)/PAGE_SIZE + 1)*PAGE_SIZE
#define JPG_RGB_BUF_SIZE           ((MAX_RGB_WIDTH * MAX_RGB_HEIGHT*4)/PAGE_SIZE + 1)*PAGE_SIZE

#define JPG_TOTAL_BUF_SIZE         (JPG_STREAM_BUF_SIZE + JPG_STREAM_THUMB_BUF_SIZE \
										+ JPG_FRAME_BUF_SIZE + JPG_FRAME_THUMB_BUF_SIZE + JPG_RGB_BUF_SIZE)

#define COEF1_RGB_2_YUV    0x4d971e
#define COEF2_RGB_2_YUV    0x2c5783
#define COEF3_RGB_2_YUV    0x836e13

/*
 * JPEG HW Register Macro Definition
 */
#define JPG_1BIT_MASK           1
#define JPG_4BIT_MASK           0xF

#define JPG_SMPL_MODE_MASK	0x07	// SubSampling_Mode Mask is JPGMOD Register [2:0] bits mask

#define JPG_RESTART_INTRAVEL    2	// Restart Interval value in JPGDRI Register is 2

#define JPG_HCLK_JPEG_BIT       5	// HCLK_JPEG is CLK_GATE_D1_1 Register 5th bit
#define JPG_SMPL_MODE_BIT       0	// SubSampling_Mode is JPGMOD Register 0th bit
#define JPG_QUANT_TABLE1_BIT    8	// Quantization Table #1 is JPGQHNO Register 8th bit
#define JPG_QUANT_TABLE2_BIT    10	// Quantization Table #2 is JPGQHNO Register 10th bit
#define JPG_QUANT_TABLE3_BIT    12	// Quantization Table #3 is JPGQHNO Register 12th bit
#define JPG_MODE_SEL_BIT        5	// Mode Sel is JPGCMOD Register 5th bit
#define JPG_MODE_Y16_BIT        1	// Mode y16 is JPGCMOD Register 1th bit

#define JPG_DECODE              (0x1 << 3)
#define JPG_ENCODE              (0x0 << 3)

#define JPG_RESERVE_ZERO        (0b000 << 2)

#define ENABLE_MOTION_ENC       (0x1<<3)
#define DISABLE_MOTION_ENC      (0x0<<3)

#define ENABLE_MOTION_DEC       (0x1<<0)
#define DISABLE_MOTION_DEC      (0x0<<0)

#define ENABLE_HW_DEC           (0x1<<2)
#define DISABLE_HW_DEC          (0x0<<2)

#define INCREMENTAL_DEC         (0x1<<3)
#define NORMAL_DEC              (0x0<<3)
#define YCBCR_MEMORY            (0x1<<5)

#define ENABLE_IRQ              (0xf<<3)

typedef struct tagJPG_CTX
{
    unsigned int                  JPGDataAddr;
    unsigned int                  IMGDataAddr;
    unsigned int                  JPGThumbDataAddr;
    unsigned int                  IMGThumbDataAddr;
    HANDLE                        callerProcess;
}JPG_CTX;

void *Phy2VirAddr(UINT32 phy_addr, int mem_size);
BOOL JPGSfrMemMapping();
volatile JPG_SFR * GetJPGSfrVirAddr();
int GetJPGSfrPhyAddr();

#endif