#pragma once

#include <WINDOWS.h>
#include <BSP.h>
#include <I2CHwCtxt.h>

class I2CEmulContext : public I2CCtrlContext
{	
public:
	I2CEmulContext();
	~I2CEmulContext();

	BOOL	Open(DWORD dwChannel, DWORD dwMethod, DWORD dwThreadPriority, WORD wSlaveAddr, PSXXXXXX_I2C_REG pI2CReg, PSXXXXXX_GPIO_REG pGPIOReg, PSXXXXXX_SYSCLK_REG pSYSCLKReg, PSXXXXXX_BSP_ARG pBSPArgs);
	BOOL	Close(VOID);

	BOOL			StartTransfer(PI2CObject pServiceObj);
	BOOL	PowerUp(VOID) {SetPowerState(D0); return TRUE;}
	BOOL	PowerDown(VOID) {SetPowerState(D4); return TRUE;}
	
	DWORD	GetMethod(VOID) {return I2C_METHOD_POLLING;}
	DWORD	GetSysIntr(VOID) {return SYSINTR_UNDEFINED;}
	VOID	I2CThread(VOID);
};

typedef I2CEmulContext * PI2CEmulContext;

