//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this sample source code is subject to the terms of the Microsoft
// license agreement under which you licensed this sample source code. If
// you did not accept the terms of the license agreement, you are not
// authorized to use this sample source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the LICENSE.RTF on your install media or the root of your tools installation.
// THE SAMPLE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:    DDI_dummy.h

Abstract:       DDI_dummy LCD module control

Functions:


Notes:


--*/

#ifndef __DDI_DUMMY_H_
#define __DDI_DUMMY_H_

#include <string.h>
#include "dsim.h"                // wil be chaned diplay.h define DDI configuration struture to initialize LCDC and/or DSI
#include "dcs.h"

//#define Disp(x) RETAILMSG(TRUE, x)
#define Outp32(addr, data)    (*(volatile UINT32 *)(addr) = (data))
#define Inp32(addr) (*(volatile UINT32 *)(addr))


typedef struct
{
    DSIM_Infor*     pDSIProtocol;            // H/W for Read/Write Special Command of DDi
    DCS_Infor*     pDCS;                // DCS Command Set Read/Write
    DDI_Configuration* m_pDDISpec;
}DDI_Infor;


//API of DDI_dummy-------------------------------------------//
extern DDI_Configuration* DDI_dummy_GetSpec(void);
extern BYTE DDI_dummy_Init(DDI_Infor*, DWORD, DWORD);
//General API Function-------------------------------------------//
//////////
// Function Name : DDI_GetConfiguration
// Function Description :
//   This function returns Address of DDI Spec
// Input : None
// Output : DDI_Configuration* - Address of DDI Spec
// Version : v0.0
static DDI_Configuration* DDI_GetConfiguration(void)
{
    return DDI_dummy_GetSpec();
}

extern DDI_Infor* DDI_Create(DWORD uVar0, DWORD uVar1, DWORD uVar2, DWORD uVar3);


//////////
// Function Name : DDI_Init
// Function Description :
//   This function Initileze DDI to Display Image
// Input :     DDI_Infor* - DDI Handler
//            uVar0 - DSI Master Handler
//            uVar1 - DCS Handler
//            uVar2 - Not used
//            uVar3 - Not used
// Output : True/False
// Version : v0.0
static BYTE DDI_Init(DDI_Infor* pDDIInfor)
{
    if ( pDDIInfor != NULL)
    {
        if(DDI_dummy_Init(pDDIInfor, 0, 0))
        {
            return TRUE;
        }
        else
        {
            RETAILMSG(1,(_T("DDI is not initialied\n")));
            return FALSE;
        }
    }
    else
    {
        RETAILMSG(1,(_T("DSI Module is not embedded!!\n")));
        RETAILMSG(1,(_T("DDI is not initialied\n")));
        return FALSE;
    }
}

//////////
// Function Name : DDI_Destory
// Function Description :
//   This function close DDI
// Input :     DDI_Infor* - DDI Handler
//            uVar0 - Not used
//            uVar1 - Not used
//            uVar2 - Not used
//            uVar3 - Not used
// Output : True/False
// Version : v0.0
static BYTE DDI_Destory(DDI_Infor* pDDIInfor, DWORD uVar0, DWORD uVar1, DWORD uVar2, DWORD uVar3)
{
    if ( pDDIInfor != NULL)
    {
        // if there is sequence before closing lcd pannel, write here

        //free(pDDIInfor);
        return TRUE;
    }
    else
        return FALSE;
}


#endif
