#ifndef __MIE_CON_MACRO_H__
#define __MIE_CON_MACRO_H__

#if __cplusplus
extern "C"
{
#endif

////////////////////////////////////////
//
//    MIE Controller SFR Bit Field Macro
//
////////////////////////////////////////

// MIE_CTRL1
#define HRESOL_MASK         (0x7FF<<18)
#define HRESOL_BITPOS       18
#define VRESOL_MASK         (0x7FF<<7)
#define VRESOL_BITPOS       7
#define MIEMODE_MASK        (0x3<<5)
#define MIEMODE_OFF         (0x0<<5)
#define MIEMODE_UI          (0x1<<5)
#define MIEMODE_STILL       (0x2<<5)
#define MIEMODE_MOVING      (0x3<<5)
#define ONOFFDIMMEN_MASK    (0x1<<4)
#define ONOFFDIMMEN_ENABLE  (0x1<<4)
#define ONOFFDIMMEN_DISABLE (0x0<<4)
#define CAT_MASK            (0x3<<2)
#define CAT_1_FRAME         (0x0<<2)
#define CAT_2_FRAME         (0x1<<2)
#define CAT_4_FRAME         (0x2<<2)
#define CAT_8_FRAME         (0x3<<2)
#define CST_MASK            (0x3<<0)
#define CST_32_FRAME        (0x0<<0)
#define CST_64_FRAME        (0x1<<0)
#define CST_96_FRAME        (0x2<<0)
#define CST_128_FRAME       (0x3<<0)

// MIE_CTRL2
#define IERC_MASK           (0xFF<<14)
#define IERC_BITPOS         14
#define BRRC_MASK           (0xFF<<6)
#define BRRC_BITPOS         6
#define SERC_MASK           (0x1F<<1)
#define SERC_BITPOS         1
#define BGRGRAM_MASK        (0x1<<0)
#define BGRGRAM_RGB         (0x0<<0)
#define BGRGRAM_BGR         (0x1<<0)

// MIE_CTRL3
#define DUAL_VDEN_MASK      (0x1<<5)
#define DUAL_VDEN           (0x1<<5)
#define DUAL_VCLK           (0x0<<5)
#define IVCLK_MASK          (0x1<<4)
#define IVCLK_RISING_EDGE   (0x1<<4)
#define IVCLK_FALLING_EDGE  (0x0<<4)
#define IHSYNC_MASK         (0x1<<3)
#define IHSYNC_NORMAL       (0x0<<3)
#define IHSYNC_INVERTED     (0x1<<3)
#define IVSYNC_MASK         (0x1<<2)
#define IVSYNC_NORMAL       (0x0<<2)
#define IVSYNC_INVERTED     (0x1<<2)
#define IVDEN_MASK          (0x1<<1)
#define IVDEN_NORMAL        (0x0<<1)
#define IVDEN_INVERTED      (0x1<<1)
#define MIE_MASK            (0x1<<0)
#define MIE_NORMAL          (0x0<<0)
#define MIE_FIXED           (0x1<<0)

// MIE_WINHADDR
#define WINHADDR1_MASK      (0x7FF<<21)
#define WINHADDR1_BITPOS    21
#define WINHADDR0_MASK      (0x7FF<<0)
#define WINHADDR0_BITPOS    0

// MIE_WINVADDR
#define WINVADDR1_MASK      (0x7FF<<21)
#define WINVADDR1_BITPOS    21
#define WINVADDR0_MASK      (0x7FF<<0)
#define WINVADDR0_BITPOS    0

// MIE_PWMCTRL1
#define DT_MASK             (0x7<<16)
#define DT_16_FRAMES        (0x0<<16)
#define DT_24_FRAMES        (0x1<<16)
#define DT_32_FRAMES        (0x2<<16)
#define DT_40_FRAMES        (0x3<<16)
#define DT_48_FRAMES        (0x4<<16)
#define DT_56_FRAMES        (0x5<<16)
#define DT_65_FRAMES        (0x6<<16)
#define DT_72_FRAMES        (0x7<<16)
#define BLMODEINSLP_MASK    (0x1<<15)
#define BLMODEINSLP_ENABLE  (0x1<<15)
#define BLMODEINSLP_DISABLE (0x0<<15)
#define BRSEL_MASK          (0x1<<14)
#define BRSEL_ENABLE        (0x1<<14)
#define BRSEL_DISABLE       (0x0<<14)
#define BLDIMMSTEP_MASK     (0x3<<12)
#define BLDIMMSTEP_256      (0x0<<12)
#define BLDIMMSTEP_128      (0x1<<12)
#define BLDIMMSTEP_64       (0x2<<12)
#define BLDIMMSTEP_32       (0x3<<12)
#define BCFREQSEL_MASK      (0x7F<<5)
#define BCFREQSEL_BITPOS    5
#define BCTRL_MASK          (0x1<<4)
#define BCTRL_ON            (0x1<<4)
#define BCTRL_OFF           (0x0<<4)
#define DD_MASK             (0x1<<3)
#define DD_ON               (0x1<<3)
#define DD_OFF              (0x0<<3)
#define BL_MASK             (0x1<<2)
#define BL_ACTIVE           (0x1<<2)
#define BL_FIXED_TO_ZERO    (0x0<<2)
#define BCMODE_MASK         (0x3<<0)
#define BCMODE_OFF          (0x0<<0)
#define BCMODE_MANUAL       (0x1<<0)
#define BCMODE_MIE          (0x2<<0)
#define BCMODE_MANUAL_MIE   (0x3<<0)

// MIE_PWMCTRL2
#define BRMIN_MASK          (0xFF<<0)
#define BRMIN_BITPOS        0
#define MANBR_MASK          (0xFF<<8)
#define MANBR_BITPOS        8

// MIE_PWMVIDTCON1
#define VSPW_MASK           (0xFF<<0)
#define VSPW_BITPOS         0
#define VFPD_MASK           (0xFF<<8)
#define VFPD_BITPOS         8
#define VBPD_MASK           (0xFF<<16)
#define VBPD_BITPOS         16

// MIE_PWMVIDTCON2
#define HSPW_MASK           (0xFF<<0)
#define HSPW_BITPOS         0
#define HFPD_MASK           (0xFF<<8)
#define HFPD_BITPOS         8
#define HBPD_MASK           (0xFF<<16)
#define HBPD_BITPOS         16

#endif    // __MIE_CON_MACRO_H__
