#include <stdio.h>
#ifndef __G2D_DEF_H
#define __G2D_DEF_H

// **********************************************************
//     Enable RTL Vector Mode
// **********************************************************
//#define WRITE_RTL_VECTOR

// **********************************************************
//     Parameter Definition
// **********************************************************
#define UREG64 unsigned long long
#define UREG32 unsigned int
#define UREG8  unsigned char

#define G2D_BYTE 1
#define G2D_HALFWORD 2
#define G2D_BIT24 3
#define G2D_WORD 4

#define COLOR_XRGB_8888 0
#define COLOR_ARGB_8888 1
#define COLOR_RGB_565   2
#define COLOR_XRGB_1555 3
#define COLOR_ARGB_1555 4
#define COLOR_XRGB_4444 5
#define COLOR_ARGB_4444 6
#define COLOR_PACKED_RGB_888 7

#define CHANNEL_ARGB 0
#define CHANNEL_RGBA 1
#define CHANNEL_ABGR 2
#define CHANNEL_BGRA 3

// **********************************************************
//     Address Definition of SFR
// **********************************************************
//**   General Register   *****************
#define SOFT_RESET_REG          0x0000
#define INTEN_REG               0x0004
#define FIFO_INTC_REG           0x0008
#define INTC_PEND_REG           0x000C
#define FIFO_STAT_REG           0x0010
#define AXI_ID_MODE_REG         0x0014
#define CACHECTL_REG            0x0018

//**   G2D Command   *********************
#define BITBLT_START_REG        0x0100
#define BITBLT_COMMAND_REG      0x0104

//**   Rotation & Direction   *************
#define ROTATE_REG              0x0200
#define SRC_MSK_DIRECT_REG      0x0204
#define DST_PAT_DIRECT_REG      0x0208
// for old vector
#define SRC_DIRECT_REG          0x0204
#define DST_DIRECT_REG          0x0208

//**   Source    **************************
#define SRC_SELECT_REG          0x0300
#define SRC_BASE_ADDR_REG       0x0304
#define SRC_STRIDE_REG          0x0308
#define SRC_COLOR_MODE_REG      0x030C
#define SRC_LEFT_TOP_REG        0x0310
#define SRC_RIGHT_BOTTOM_REG    0x0314

//**   Destination  ***********************
#define DST_SELECT_REG          0x0400
#define DST_BASE_ADDR_REG       0x0404
#define DST_STRIDE_REG          0x0408
#define DST_COLOR_MODE_REG      0x040C
#define DST_LEFT_TOP_REG        0x0410
#define DST_RIGHT_BOTTOM_REG    0x0414

//**   Pattern   **************************
#define PAT_BASE_ADDR_REG       0x0500
#define PAT_SIZE_REG            0x0504
#define PAT_COLOR_MODE_REG      0x0508
#define PAT_OFFSET_REG          0x050C
#define PAT_STRIDE_REG          0x0510

//**   Mask   *****************************
#define MASK_BASE_ADDR_REG      0x0520
#define MASK_STRIDE_REG         0x0524

//**   Clipping Window  *******************
#define CW_LEFT_TOP_REG         0x0600
#define	CW_RIGHT_BOTTOM_REG     0x0604

//**   ROP4 & Blending   *****************
//#define ROP_CTRL_REG          0x0700
#define THIRD_OPERAND_REG       0x0610
#define ROP4_REG                0x0614
#define ALPHA_REG               0x0618

//**   Color   ***************************
#define FG_COLOR_REG            0x0700
#define BG_COLOR_REG            0x0704
#define BS_COLOR_REG            0x0708

//**   Color Key   ***********************
#define SRC_COLORKEY_CTRL_REG   0x0710
#define SRC_COLORKEY_DR_MIN_REG 0x0714
#define SRC_COLORKEY_DR_MAX_REG 0x0718
#define DST_COLORKEY_CTRL_REG   0x071C
#define DST_COLORKEY_DR_MIN_REG 0x0720
#define DST_COLORKEY_DR_MAX_REG 0x0724

// **********************************************************
//     Memory
// **********************************************************
//extern UREG32 *memory;

// **********************************************************
//     Variables for SFR
// **********************************************************
//**   General Register   *****************
//extern UREG32 DST_ENDIAN;
//extern UREG32 SRC_ENDIAN;

//**   G2D Command   ********************
extern UREG32 pMASK_EN;
extern UREG32 pSTRETCH_EN;
extern UREG32 pCW_EN;
extern UREG32 pTRANSPARENT_MODE;
extern UREG32 pCOLORKEY_MODE;
extern UREG32 pALPHA_BLEND_MODE;
extern UREG32 pCOLOR_EXP_RULE;

//**   Rotation & Direction   *************
extern UREG32 pROTATE;
extern UREG32 pSRC_X_DIRECT;
extern UREG32 pSRC_Y_DIRECT;
extern UREG32 pDST_X_DIRECT;
extern UREG32 pDST_Y_DIRECT;

//**   Source    **************************
extern UREG32 pSRC_MODE;
extern UREG32 pSRC_BASE_ADDR;
extern UREG32 pSRC_WIDTH;
extern UREG32 pSRC_HEIGHT;
extern UREG32 pSRC_COLOR_FORMAT;
extern UREG32 pSRC_CHANNEL_ORDER;
extern UREG32 pSRC_LEFT_X;
extern UREG32 pSRC_TOP_Y;
extern UREG32 pSRC_RIGHT_X;
extern UREG32 pSRC_BOTTOM_Y;
extern int pSRC_STRIDE;


//**   Destination  ***********************
extern UREG32 pDST_MODE;
extern UREG32 pDST_BASE_ADDR;
extern UREG32 pDST_WIDTH;
extern UREG32 pDST_HEIGHT;
extern UREG32 pDST_COLOR_FORMAT;
extern UREG32 pDST_CHANNEL_ORDER;
extern UREG32 pDST_LEFT_X;
extern UREG32 pDST_TOP_Y;
extern UREG32 pDST_RIGHT_X;
extern UREG32 pDST_BOTTOM_Y;
extern int pDST_STRIDE;

//**   Pattern   **************************
extern UREG32 pPAT_BASE_ADDR;
extern UREG32 pPAT_WIDTH;
extern UREG32 pPAT_HEIGHT;
extern UREG32 pPAT_COLOR_FORMAT;
extern UREG32 pPAT_CHANNEL_ORDER;
extern UREG32 pPAT_OFFSET_X;
extern UREG32 pPAT_OFFSET_Y;
extern int pPAT_STRIDE;

//**   Mask   *****************************
extern UREG32 pMASK_BASE_ADDR;
extern UREG32 pMASK_WIDTH;
extern int pMASK_STRIDE;

//**   Clipping Window  *******************
extern UREG32 pCW_LEFT_X;
extern UREG32 pCW_TOP_Y;
extern UREG32 pCW_RIGHT_X;
extern UREG32 pCW_BOTTOM_Y;

//**   ROP4 & Blending   *****************
extern UREG32 pMASKED_SELECT;
extern UREG32 pUNMASKED_SELECT;
extern UREG32 pMASKED_ROP3;
extern UREG32 pUNMASKED_ROP3;
extern UREG32 pALPHA_VALUE;
extern UREG32 pFADING_OFFSET;

//**   Color   ***************************
extern UREG32 pFG_COLOR;
extern UREG32 pBG_COLOR;
extern UREG32 pBS_COLOR;

//**   Color Key   ***********************
extern UREG32 pSRC_STENCILON_A;
extern UREG32 pSRC_STENCILON_R;
extern UREG32 pSRC_STENCILON_G;
extern UREG32 pSRC_STENCILON_B;
extern UREG32 pSRC_STENCIL_INV;
extern UREG32 pSRC_DR_MIN;
extern UREG32 pSRC_DR_MAX;
extern UREG32 pDST_STENCILON_A;
extern UREG32 pDST_STENCILON_R;
extern UREG32 pDST_STENCILON_G;
extern UREG32 pDST_STENCILON_B;
extern UREG32 pDST_STENCIL_INV;
extern UREG32 pDST_DR_MIN;
extern UREG32 pDST_DR_MAX;

// **********************************************************
//     Function Declaration
// **********************************************************
DWORD g2d_rd_reg (UREG32 Addr);
void g2d_wd_reg (UREG32 Addr, UREG32 Data);
void g2d_wr_mem (UREG32 addr, UREG32 data, UREG32 mode);
UREG32 g2d_rd_mem (UREG32 Addr, UREG32 mode);
void g2d_src2dst_split ( UREG32 InA, UREG32 InR, UREG32 InG, UREG32 InB,
                         UREG32 SrcFormat, UREG32 DstFormat, UREG32 ColorExpRule,
                         UREG32 *SrcA, UREG32 *SrcR, UREG32 *SrcG, UREG32 *SrcB,
                         UREG32 *SrcAlpha8);
void g2d_rotate ( UREG32 Rotate,
                  UREG32 SrcX, UREG32 SrcY,
                  UREG32 SrcLeftX, UREG32 SrcTopY,
                  UREG32 SrcRightX, UREG32 SrcBottomY,
                  UREG32 SrcBlockWidth,
                  UREG32 DstX, UREG32 DstY,
                  UREG32 DstLeftX, UREG32 DstTopY,
                  UREG32 DstRightX, UREG32 DstBottomY,
                  UREG32 DstBlockWidth,
                  UREG32 PatWidth, UREG32 PatHeight,
                  UREG32 PatOffsetX, UREG32 PatOffsetY,
                  UREG32 *RotateSrcX, UREG32 *RotateSrcY,
                  UREG32 *RotateDstX, UREG32 *RotateDstY,
                  UREG32 *RotatePatX, UREG32 *RotatePatY,
                  UREG32 *RotateMskX, UREG32 *RotateMskY );
UREG32 g2d_clipping ( UREG32 RotateDstX, UREG32 RotateDstY,
                      UREG32 CWLeftX, UREG32 CWTopY, UREG32 CWRightX, UREG32 CWBottomY );
UREG32 g2d_get_num_bytes_of_color ( UREG32 ColorFormat );
void g2d_split_channel ( UREG32 inColor, UREG32 inFormat, UREG32 inMode,
                         UREG32 *AData, UREG32 *RData, UREG32 *GData, UREG32 *BData); 
void g2d_load_src ( UREG32 SrcX, UREG32 SrcY,
                    UREG32 FGColor, UREG32 BGColor, UREG32 BSColor, UREG32 SrcSelect,
                    UREG32 SrcBaseAddr, int SrcStride,
                    UREG32 ColorExpRule,
                    UREG32 SrcColorFormat, UREG32 SrcChannelOrder,
                    UREG32 DstColorFormat, UREG32 DstChannelOrder,
                    UREG32 TransparentMode, UREG32 ColorkeyMode,
                    UREG32 SrcStencilOnA, UREG32 SrcStencilOnR, UREG32 SrcStencilOnG, UREG32 SrcStencilOnB,
                    UREG32 SrcStencilInv, UREG32 SrcDRMin, UREG32 SrcDRMax,
                    UREG32 *ResultA, UREG32 *ResultR, UREG32 *ResultG, UREG32 *ResultB,
                    UREG32 *SrcAlpha8, UREG32 *FlgSrcPass );
void g2d_load_dst ( UREG32 DstX, UREG32 DstY,
                    UREG32 FGColor, UREG32 BGColor, UREG32 DstSelect,
                    UREG32 DstBaseAddr, int DstStride,
                    UREG32 ColorExpRule,
                    UREG32 DstColorFormat, UREG32 DstChannelOrder,
                    UREG32 ColorkeyMode,
                    UREG32 DstStencilOnA, UREG32 DstStencilOnR,
                    UREG32 DstStencilOnG, UREG32 DstStencilOnB,
                    UREG32 DstStencilInv, UREG32 DstDRMin, UREG32 DstDRMax,
                    UREG32 *ResultA, UREG32 *ResultR, UREG32 *ResultG, UREG32 *ResultB,
                    UREG32 *FlgDstPass, UREG32 *DstAddr, UREG32 *DstMode );
UREG32 g2d_load_mask ( UREG32 MaskEn, UREG32 MaskBaseAddr, UREG32 MskX, UREG32 MskY,
                       int DstStride );
UREG32 g2d_colorkey_test ( UREG32 SrcA, UREG32 SrcR, UREG32 SrcG, UREG32 SrcB,
                           UREG32 StencilOnA, UREG32 StencilOnR,
                           UREG32 StencilOnG, UREG32 StencilOnB, UREG32 StencilInverse,
                           UREG32 MinDR, UREG32 MaxDR );
void g2d_load_pat ( UREG32 PatX, UREG32 PatY,
                    UREG32 FGColor, UREG32 BGColor,
                    UREG32 PatBaseAddr, int PatStride,
                    UREG32 ColorExpRule,
                    UREG32 PatColorFormat, UREG32 PatChannelOrder,
                    UREG32 DstColorFormat, UREG32 DstChannelOrder,
                        UREG32 MaskBit, UREG32 MaskedSelect, UREG32 UnmaskedSelect, 
                    UREG32 *ResultA, UREG32 *ResultR, UREG32 *ResultG, UREG32 *ResultB );
UREG32 g2d_rop3 ( UREG32 SrcColor, UREG32 DstColor, UREG32 PatColor, UREG32 RopValue );
UREG32 g2d_final_color_conv (UREG32 AlphaMode, UREG32 InData, UREG32 inFormat, UREG32 inMode );
UREG32 g2d_alpha_blending ( UREG32 AlphaMode, UREG32 AlphaValue,
                            UREG32 FadingOffset, UREG32 SrcColor,
                            UREG32 SrcAlpha, UREG32 DstColor );
void g2d_pixel_rendering ( UREG32 RelativeSrcX, UREG32 RelativeSrcY,
                           UREG32 RelativeDstX, UREG32 RelativeDstY,
                           UREG32 SrcLeftX, UREG32 SrcTopY,
                           UREG32 SrcRightX, UREG32 SrcBottomY,
                           UREG32 SrcBlockWidth,
                           UREG32 DstLeftX, UREG32 DstTopY,
                           UREG32 DstRightX, UREG32 DstBottomY,
                           UREG32 DstBlockWidth,
                           UREG32 Rotate,
                           UREG32 TransparentMode, UREG32 ColorkeyMode,
                           UREG32 CWEn, UREG32 CWLeftX, UREG32 CWTopY,
                           UREG32 CWRightX, UREG32 CWBottomY,
                           UREG32 FGColor, UREG32 BGColor, UREG32 BSColor,
                           UREG32 SrcSelect, UREG32 SrcBaseAddr,
                           int SrcStride, int MaskStride,
                           UREG32 SrcColorFormat, UREG32 SrcChannelOrder,
                           UREG32 DstSelect, UREG32 DstBaseAddr, int DstStride,
                           UREG32 DstColorFormat, UREG32 DstChannelOrder,
                           UREG32 PatBaseAddr,
                           UREG32 PatWidth, UREG32 PatHeight, int PatStride,
                           UREG32 PatColorFormat, UREG32 PatChannelOrder,
                           UREG32 PatOffsetX, UREG32 PatOffsetY,
                           UREG32 MaskEn, UREG32 MaskedSelect, UREG32 UnmaskedSelect,
                           UREG32 MaskBaseAddr, UREG32 MaskedRop3, UREG32 UnmaskedRop3,
                           UREG32 SrcStencilOnA, UREG32 SrcStencilOnR,
                           UREG32 SrcStencilOnG, UREG32 SrcStencilOnB, UREG32 SrcStencilInv,
                           UREG32 SrcDRMin, UREG32 SrcDRMax,
                           UREG32 DstStencilOnA, UREG32 DstStencilOnR,
                           UREG32 DstStencilOnG, UREG32 DstStencilOnB, UREG32 DstStencilInv,
                           UREG32 DstDRMin, UREG32 DstDRMax, UREG32 ColorExpRule,
                           UREG32 AlphaBlendMode, UREG32 AlphaValue, UREG32 FadingOffset );
void g2d_bitblt(void);
void g2d_reset(void);
UREG32 g2d_get_num_bytes_of_color ( UREG32 ColorFormat );

#endif
