//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
// Copyright (c) Samsung Electronics. Co. LTD. All rights reserved.

/*++

THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:

    precomp.h

Abstract:

    The precompiled header for Display Class

Notes:

--*/

#include <bsp.h>
#include <types.h>
#include <winddi.h>
#include <ddrawi.h>
#include <ddgpe.h>
#include <emul.h>
#include <ddhfuncs.h>
#include <CRegEdit.h>
//#include <dvp.h>
#include <image_cfg.h>
#include <dispperf.h>
#include <SVEDriverAPI.h>   // Shared Type definition
#include <display_main.h>
#include <ldi.h>
#include <mipidsi_reg.h>
#include <display_con.h>
#include <SVE_API.h>
//#include <postif_proc.h>    // From Raw Camera Driver
#include <fimg2d.h>

#include "mediatype.h"
#include "priv_context.h"       // For common data structure, This has dependency to S5PV210Surf

#if 0
#define __MODULE__  "S5PV210 Display Driver"

extern DBGPARAM dpCurSettings;

#define DEBUG_2D_MSG    DEBUGMSG
#define DEBUG_DISP_MSG    DEBUGMSG
#define RETAIL_2D_MSG   RETAILMSG
#define RETAIL_DISP_MSG   RETAILMSG

#ifdef DEBUG

#define GPE_ZONEMASK_ERROR              (1<<0)
#define GPE_ZONEMASK_WARNING            (1<<1)
#define GPE_ZONEMASK_PERF               (1<<2)
#define GPE_ZONEMASK_TEMP               (1<<3)

#define GPE_ZONEMASK_ENTER              (1<<4)
#define GPE_ZONEMASK_INIT               (1<<5)
#define GPE_ZONEMASK_BLT_HI             (1<<6)
#define GPE_ZONEMASK_BLT_LO             (1<<7)

#define GPE_ZONEMASK_CREATE             (1<<8)
#define GPE_ZONEMASK_FLIP               (1<<9)
#define GPE_ZONEMASK_LINE               (1<<10)
#define GPE_ZONEMASK_HW                 (1<<11)

#define GPE_ZONEMASK_POLY               (1<<12)
#define GPE_ZONEMASK_CURSOR             (1<<13)
// #define GPE_ZONE_               DEBUGZONE(14)
// #define GPE_ZONE_               DEBUGZONE(15)

#ifndef DISPDRV_DEBUGZONES
#define DISPDRV_DEBUGZONES         (GPE_ZONEMASK_ERROR | GPE_ZONEMASK_WARNING | GPE_ZONEMASK_TEMP)
#endif
#endif  //DEBUG

// Even on Release Mode, We don't care about GPE message
#define ZONEID_ERROR                0
#define ZONEID_WARNING              1
#define ZONEID_PERF                 2
#define ZONEID_TEMP                 3
#define ZONEID_ENTER                4
#define ZONEID_INIT                 5
#define ZONEID_BLT_HI               6
#define ZONEID_BLT_LO               7
#define ZONEID_CREATE               8
#define ZONEID_FLIP                 9
#define ZONEID_LINE                 10
#define ZONEID_POST                 11
#define ZONEID_ROTATOR              12
#define ZONEID_TVSC                 13
#define ZONEID_TVENC                14
#define ZONEID_2D                   15

#define DISP_ZONE_ERROR             DEBUGZONE(ZONEID_ERROR)
#define DISP_ZONE_WARNING           DEBUGZONE(ZONEID_WARNING)
#define DISP_ZONE_PERF              DEBUGZONE(ZONEID_PERF)
#define DISP_ZONE_TEMP              DEBUGZONE(ZONEID_TEMP)
#define DISP_ZONE_ENTER             DEBUGZONE(ZONEID_ENTER)
#define DISP_ZONE_INIT              DEBUGZONE(ZONEID_INIT)
#define DISP_ZONE_BLT_HI            DEBUGZONE(ZONEID_BLT_HI)
#define DISP_ZONE_BLT_LO            DEBUGZONE(ZONEID_BLT_LO)
#define DISP_ZONE_CREATE            DEBUGZONE(ZONEID_CREATE)
#define DISP_ZONE_FLIP              DEBUGZONE(ZONEID_FLIP)
#define DISP_ZONE_LINE              DEBUGZONE(ZONEID_LINE)
#define DISP_ZONE_POST              DEBUGZONE(ZONEID_POST)
#define DISP_ZONE_ROTATOR           DEBUGZONE(ZONEID_ROTATOR)
#define DISP_ZONE_TVSC              DEBUGZONE(ZONEID_TVSC)
#define DISP_ZONE_TVENC             DEBUGZONE(ZONEID_TVENC)
#define DISP_ZONE_2D                DEBUGZONE(ZONEID_2D)

#define ZONEMASK_ERROR         (1 << ZONEID_ERROR)
#define ZONEMASK_WARNING       (1 << ZONEID_WARNING)
#define ZONEMASK_PERF          (1 << ZONEID_PERF)
#define ZONEMASK_TEMP          (1 << ZONEID_TEMP)
#define ZONEMASK_ENTER         (1 << ZONEID_ENTER)
#define ZONEMASK_INIT          (1 << ZONEID_INIT)
#define ZONEMASK_BLT_HI        (1 << ZONEID_BLT_HI)
#define ZONEMASK_BLT_LO        (1 << ZONEID_BLT_LO)
#define ZONEMASK_CREATE        (1 << ZONEID_CREATE)
#define ZONEMASK_FLIP          (1 << ZONEID_FLIP)
#define ZONEMASK_LINE          (1 << ZONEID_LINE)
#define ZONEMASK_POST          (1 << ZONEID_POST)
#define ZONEMASK_ROTATOR       (1 << ZONEID_ROTATOR)
#define ZONEMASK_TVSC          (1 << ZONEID_TVSC)
#define ZONEMASK_TVENC         (1 << ZONEID_TVENC)
#define ZONEMASK_2D            (1 << ZONEID_2D)


#ifndef DISPDRV_RETAILZONES
#define DISPDRV_RETAILZONES         (ZONEMASK_ERROR)
#endif
#else
/*
#ifdef RETAILMSG
#undef RETAILMSG
#define RETAILMSG   DBGMSG
#endif

#ifdef DEBUGMSG
#undef DEBUGMSG
#define DEBUGMSG   DBGMSG
#endif
*/
#define DEBUG_2D_MSG    DBGMSG
#define DEBUG_DISP_MSG  DBGMSG
#define RETAIL_2D_MSG   DBGMSG
#define RETAIL_DISP_MSG DBGMSG

#ifdef DEBUG
#define __MODULE__  "S5PV210 Display Driver"

#ifndef DISPDRV_DEBUGZONES
#define DISPDRV_DEBUGZONES         (GPE_ZONEMASK_ERROR | GPE_ZONEMASK_WARNING | GPE_ZONEMASK_TEMP)
#endif
#define GPE_ZONEMASK_ERROR              (1<<0)
#define GPE_ZONEMASK_WARNING            (1<<1)
#define GPE_ZONEMASK_PERF               (1<<2)
#define GPE_ZONEMASK_TEMP               (1<<3)

#define GPE_ZONEMASK_ENTER              (1<<4)
#define GPE_ZONEMASK_INIT               (1<<5)
#define GPE_ZONEMASK_BLT_HI             (1<<6)
#define GPE_ZONEMASK_BLT_LO             (1<<7)

#define GPE_ZONEMASK_CREATE             (1<<8)
#define GPE_ZONEMASK_FLIP               (1<<9)
#define GPE_ZONEMASK_LINE               (1<<10)
#define GPE_ZONEMASK_HW                 (1<<11)

#define GPE_ZONEMASK_POLY               (1<<12)
#define GPE_ZONEMASK_CURSOR             (1<<13)
// #define GPE_ZONE_               DEBUGZONE(14)
// #define GPE_ZONE_               DEBUGZONE(15)

#endif // DEBUG

#define GPE_ZONE_ERROR              DISP_INFO
#define GPE_ZONE_WARNING            DISP_DBG
#define GPE_ZONE_PERF               DISP_DBG
#define GPE_ZONE_TEMP               DISP_DBG

#define GPE_ZONE_ENTER              DISP_FUNC
#define GPE_ZONE_INIT               DISP_DBG
#define GPE_ZONE_BLT_HI             DISP_DBG
#define GPE_ZONE_BLT_LO             DISP_DBG

#define GPE_ZONE_CREATE             DISP_DBG
#define GPE_ZONE_FLIP               DISP_DBG
#define GPE_ZONE_LINE               DISP_DBG
#define GPE_ZONE_HW                 DISP_DBG

#define GPE_ZONE_POLY               DISP_DBG
#define GPE_ZONE_CURSOR             DISP_DBG

#define DISP_ZONE_ERROR             DISP_INFO
#define DISP_ZONE_WARNING           DISP_DBG
#define DISP_ZONE_PERF              DISP_USR2
#define DISP_ZONE_TEMP              DISP_DBG
#define DISP_ZONE_ENTER             DISP_FUNC
#define DISP_ZONE_INIT              DISP_DBG
#define DISP_ZONE_BLT_HI            DISP_DBG
#define DISP_ZONE_BLT_LO            DISP_DBG
#define DISP_ZONE_CREATE            DISP_FUNC
#define DISP_ZONE_FLIP              DISP_DBG
#define DISP_ZONE_LINE              DISP_DBG
#define DISP_ZONE_POST              DISP_DBG
#define DISP_ZONE_ROTATOR           DISP_DBG
#define DISP_ZONE_TVSC              DISP_DBG
#define DISP_ZONE_TVENC             DISP_DBG
#define DISP_ZONE_2D                DISP_DBG

#endif

// This Definition is used to initialize the main class of display driver
#define ESC_SUCCESS             (0x00000001)
#define ESC_FAILED              (0xFFFFFFFF)
#define ESC_NOT_SUPPORTED       (0x00000000)

#define TV_DST_WIDTH            (640)
#define TV_DST_HEIGHT           (448)

#define MAX_SUPPORT_MODE        (1)

#define SUPPORT_APM_DISP
//#define USE_CMM_FOR_YUVSURFACE
#ifdef OVERLAY_USE_MEM2MEM
#define OVERLAY_FB_NUM 3
#endif
#ifdef USE_CMM_FOR_YUVSURFACE
#ifdef OVERLAY_USE_MEM2MEM
#define CMM_MEMAREA_FOR_M2M DRAM_1
#else
#define CMM_MEMAREA_FOR_M2M DRAM_0
#endif
#endif

//#define USE_REGISTRY_VIDMEM_VIDSIZE
#define PC_REG_DISPLAY_CONFIG   _T("\\Drivers\\Display\\S5PV210\\Config\\")
#define PC_REG_PRIMARY_WINDOW   _T("PrimaryWin")
#define PC_REG_DDOVERLAY_WINDOW _T("DDOverlayWin")
// This is Default Setting
#define PRIMARY_WINDOW          (DISP_WIN2)
#define PRIMARY_WINDOW_MODE     (DISP_WIN2_DMA)
#define IOCTL_PRIMARY_WINDOW_REQUEST    (IOCTL_SVE_RSC_REQUEST_FIMD_WIN2)
#define IOCTL_PRIMARY_WINDOW_RELEASE    (IOCTL_SVE_RSC_RELEASE_FIMD_WIN2)
#define OVERLAY_WINDOW          (DISP_WIN1)
#define OVERLAY_WINDOW_DMA      (DISP_WIN1_DMA)
#ifdef OVERLAY_USE_MEM2MEM
#define OVERLAY_WINDOW_FIFO     (DISP_WIN1_DMA)
#else
#define OVERLAY_WINDOW_FIFO     (DISP_WIN1_CAMIF1_RGB)
#endif
#define IOCTL_OVERLAY_WINDOW_REQUEST    (IOCTL_SVE_RSC_REQUEST_FIMD_WIN1)
#define IOCTL_OVERLAY_WINDOW_RELEASE    (IOCTL_SVE_RSC_RELEASE_FIMD_WIN1)
#define IOCTL_OVERLAY_WINDOW_LOCALPATH_START    (IOCTL_SVE_LOCALPATH_SET_WIN1_START)
#define IOCTL_OVERLAY_WINDOW_LOCALPATH_STOP     (IOCTL_SVE_LOCALPATH_SET_WIN1_STOP)
#ifdef OVERLAY_USE_MEM2MEM
#define OVERLAY_USE_LOCALPATH FALSE
#define POST_THREAD_PRIORITY 100
#else
#define OVERLAY_USE_LOCALPATH TRUE
#endif

// This calculation is different from CE 5.0, In CE5.0 Surface class can not support BytesPerPixel()
//#define BYTES_PER_PIXEL(_surf)      (EGPEFormatToBpp[(_surf)->Format()])>>3)     //< This is for WCE5.0
#define BYTES_PER_PIXEL(_surf)      ((_surf)->BytesPerPixel())
#define SURFACE_WIDTH(_surf)     ((_surf)->Stride()/BYTES_PER_PIXEL(_surf))
#define RECT_WIDTH(_rect)        ((_rect)->right - (_rect)->left)
#define RECT_HEIGHT(_rect)      ((_rect)->bottom - (_rect)->top)
#define MIN(a, b)                  ((a) < (b)? a : b)
#define AREA_SIZE(_rect, _surf)         (ABS(RECT_WIDTH(_rect))*ABS(RECT_HEIGHT(_rect))*BYTES_PER_PIXEL(_surf))

/// Graphic Optimizaiton Options
//
#define USE_CACHED_VIDEOMEMORY  (TRUE)
#define USE_VIDEOMEMORY_FORALL_SURFACES (TRUE)

//< If you want to use 2D HW for GDI or DDRAW, set this to "TRUE", if not, set to "FALSE"
#define G2D_ACCELERATE      (TRUE)           

#define G2D_FASTRETURN_INT  1
#define G2D_FASTRETURN_POL  2
#define G2D_INTERRUPT       3
#define G2D_BUSYWAITING     4
#define G2D_PROCESSINGTYPE  G2D_INTERRUPT


/// if USE_CLONEBUFFER is TRUE, 
/// although SRC or DST surface isn't phisically linear, it will work with HW by using memcpy.
#define USE_CLONEBUFFER     (TRUE)

#define USE_CACHEFLUSH_FORVIDEOMEMORY (TRUE)

/// For using Physically Linear Surface on System Memory to wide 2D HW usage.
/// 2D HW need physically contiguous memory, and its address.
/// This will consume System Memory and allocate Physically and Virtually contiguous memory.
/// So if system has small memory, allocation may fail.
/// Then 2D HW will not work for that memory.

#define USE_PACSURF         (FALSE)
///  if USE_PACSURF is TRUE then these condition will work
#define PAC_ALLOCATION_BOUNDARY (160*120*2)

#define FORCE_SET_PALLETE (TRUE)

/// for performance, we recomand to set TRUE.
#define RETURNTOSW_FOR_PERFORMANCE   (TRUE)
///  if RETURNTOSW_FOR_PERFORMANCE is TRUE then these condition will work
#define G2D_COMPROMISE_LIMIT (20*20*2)
#define G2D_COMPROMISE_LIMIT_CONSTANT_ALPHABLEND (0)
#define G2D_COMPROMISE_LIMIT_CONSTANT_ALPHABLEND_S (0)
#define G2D_COMPROMISE_LIMIT_PERPIXEL_ALPHABLEND (0)
#define G2D_COMPROMISE_LIMIT_PERPIXEL_ALPHABLEND_S (0)
#define G2D_COMPROMISE_LIMIT_STRETCH (0)
#define G2D_COMPROMISE_LIMIT_STRETCH_S (0)
#define G2D_COMPROMISE_LIMIT_COLORCONVERSION (0)
#define G2D_COMPROMISE_LIMIT_COLORCONVERSION_S (0)
#define G2D_COMPROMISE_LIMIT_NOTSRCCOPY (800*80*2)
#define G2D_COMPROMISE_LIMIT_NOTSRCCOPY_S (800*150*2)


#define G2D_CLONESURF_WIDTH (800)
#define G2D_CLONESURF_HEIGHT (480)

#define USE_SECEMUL_LIBRARY (TRUE)

