/*
 * Project Name Codec Memory Management DRIVER IN WINCE
 * Copyright  2007 Samsung Electronics Co, Ltd. All Rights Reserved. 
 *
 * This software is the confidential and proprietary information
 * of Samsung Electronics  ("Confidential Information").   
 * you shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Samsung Electronics 
 *
 * This file implements JPEG driver.
 *
 * @name  Codec Memory Management DRIVER MODULE Module (CMMDriver.c)
 * @author Jiyoung Shin (idon.shin@samsung.com)
 * @date 23-04-08
 */

#ifndef __CMM_DRIVER_H__
#define __CMM_DRIVER_H__

#include <windows.h>
#include <ceddk.h>
#include <nkintr.h>
#include "image_cfg.h"
#include "CMMAPI.h"

#define MAX_INSTANCE_NUM    10

#define CODEC_MEM_START_DRAM_0            (IMAGE_CMM_0_BUFFER_PA_START)
#define CODEC_MEM_SIZE_DRAM_0             (IMAGE_CMM_0_BUFFER_SIZE)
 
#define CODEC_MEM_START_DRAM_1            (IMAGE_CMM_1_BUFFER_PA_START)
#define CODEC_MEM_SIZE_DRAM_1             (IMAGE_CMM_1_BUFFER_SIZE)

#define Align(x, alignbyte) (((x)+(alignbyte)-1)/(alignbyte)*(alignbyte))

typedef struct tagCODEC_MEM_CTX
{
    UINT8            inst_no;
    HANDLE            callerProcess;
}CODEC_MEM_CTX;

typedef struct tagALLOC_MEM_T{
    struct tagALLOC_MEM_T    *prev;
    struct tagALLOC_MEM_T    *next;
    union{
        DWORD                cached_p_addr;  // physical address
        PHYSICAL_ADDRESS    uncached_p_addr;  // physical address
    };
    UINT8                    *v_addr;  // virtual address in cached area
    UINT8                    *u_addr;  // copyed virtual address for user mode process
    UINT32                    size;       // memory size    
    CMM_DRAM_LOCATION       dramLocation;
    UINT8                    inst_no;
    char                    cacheFlag;

} ALLOC_MEM_T;
    
typedef struct tagFREE_MEM_T
{
    struct tagFREE_MEM_T        *prev;
    struct tagFREE_MEM_T        *next;
    DWORD                               startAddr;
    DWORD                               size;
    CMM_DRAM_LOCATION       dramLocation;
}FREE_MEM_T;

typedef enum
{
    CMM_TYPE_CODEC = 0,
    CMM_TYPE_DISPLAY = 1
}CMM_MEM_TYPE;
    
#if __cplusplus
extern "C" {
#endif

void CleanInvalidateCacheRange(PBYTE StartAddress, PBYTE EndAddress);
void CleanCacheRange(PBYTE StartAddress, PBYTE EndAddress);
void InvalidateCacheRange(PBYTE StartAddress, PBYTE EndAddress);
static void InsertNodeToAllocList(ALLOC_MEM_T *node,  UINT8 inst_no);
static void InsertNodeToFreeList(FREE_MEM_T *node,  UINT8 inst_no);
static void DeleteNodeFromAllocList(ALLOC_MEM_T *node,  UINT8 inst_no);
static void DeleteNodeFromFreeList( FREE_MEM_T *node,  UINT8 inst_no);
static DWORD GetMemArea(UINT32 allocSize, UINT8 inst_no);
static ALLOC_MEM_T * GetCodecVirAddr(UINT8 inst_no, CMM_ALLOC_PRAM_T *in_param);
static void FreeCodecBuff(UINT8 *c_addr);
static void MergeFragmentation(UINT8 inst_no);
static void ReleaseAllocMem(ALLOC_MEM_T *node, CODEC_MEM_CTX *CodecMem);
static int GetInstanceNo();
static void ReturnInstanceNo(UINT8 inst_no);
static void PrintList();
#if __cplusplus
}
#endif





#endif /*__CMM_DRIVER_H__*/
