//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft end-user
// license agreement (EULA) under which you licensed this SOFTWARE PRODUCT.
// If you did not accept the terms of the EULA, you are not authorized to use
// this source code. For a copy of the EULA, please see the LICENSE.RTF on your
// install media.
//
// Copyright (c) Samsung Electronics. Co. LTD. All rights reserved.

/*++

THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:

    precomp.h

Abstract:

    The precompiled header for S5PV210 Disp Class

Notes:

--*/

#include <windows.h>
#include <bsp.h>
#include <DrvLib_mem.h>
#include <pm.h>
#include <linklist.h>
#include <devload.h>
#include "pmplatform.h"
#include "CAMDriver.h"
#include "camera_typedef.h"
#include "camera_hal.h"
#include "postif_proc.h"
#include "customcamera.h"

#define __MODULE__  "S5PV210 Camera Driver"

extern DBGPARAM dpCurSettings;

#ifndef CAMDRV_DEBUGZONES
#define CAMDRV_DEBUGZONES           (ZONEMASK_ERROR | ZONEMASK_WARNING | ZONEMASK_TEMP | ZONEMASK_ENTER | ZONEMASK_INIT\
                                     | ZONEMASK_OPEN | ZONEMASK_CLOSE | ZONEMASK_IOCTL)
#endif
#ifndef CAMDRV_RETAILZONES
#define CAMDRV_RETAILZONES          (ZONEMASK_ERROR)
#endif
#ifdef  DEBUG
#define CAMDRV_ZONES    CAMDRV_DEBUGZONES
#else
#define CAMDRV_ZONES    CAMDRV_RETAILZONES
#endif

// Even on Release Mode, We don't care about GPE message
#define ZONEID_ERROR                0
#define ZONEID_WARNING              1
#define ZONEID_PERF                 2
#define ZONEID_TEMP                 3
#define ZONEID_ENTER                4
#define ZONEID_INIT                 5
#define ZONEID_OPEN                 7
#define ZONEID_CLOSE                8
#define ZONEID_IOCTL                9
#define ZONEID_CAMIF                10
#define ZONEID_POSTIF               11

#define CAM_ZONE_ERROR             DEBUGZONE(ZONEID_ERROR)
#define CAM_ZONE_WARNING           DEBUGZONE(ZONEID_WARNING)
#define CAM_ZONE_PERF              DEBUGZONE(ZONEID_PERF)
#define CAM_ZONE_TEMP              DEBUGZONE(ZONEID_TEMP)
#define CAM_ZONE_ENTER             DEBUGZONE(ZONEID_ENTER)
#define CAM_ZONE_INIT              DEBUGZONE(ZONEID_INIT)
#define CAM_ZONE_OPEN              DEBUGZONE(ZONEID_OPEN)
#define CAM_ZONE_CLOSE             DEBUGZONE(ZONEID_CLOSE)
#define CAM_ZONE_IOCTL             DEBUGZONE(ZONEID_IOCTL)
#define CAM_ZONE_CAMIF             DEBUGZONE(ZONEID_CAMIF)
#define CAM_ZONE_POSTIF            DEBUGZONE(ZONEID_POSTIF)

#define ZONEMASK_ERROR         (1 << ZONEID_ERROR)
#define ZONEMASK_WARNING       (1 << ZONEID_WARNING)
#define ZONEMASK_PERF          (1 << ZONEID_PERF)
#define ZONEMASK_TEMP          (1 << ZONEID_TEMP)
#define ZONEMASK_ENTER         (1 << ZONEID_ENTER)
#define ZONEMASK_INIT          (1 << ZONEID_INIT)
#define ZONEMASK_OPEN          (1 << ZONEID_OPEN)
#define ZONEMASK_CLOSE         (1 << ZONEID_CLOSE)
#define ZONEMASK_IOCTL         (1 << ZONEID_IOCTL)
#define ZONEMASK_CAMIF         (1 << ZONEID_CAMIF)
#define ZONEMASK_POSTIF        (1 << ZONEID_POSTIF)

//
#define COUNT_CAMERA_IP     (MAX_CAMERA_IP_HW)
#ifdef USE_LOCALPATH
#define USE_FIMC_LOCALPATH
#endif