//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this sample source code is subject to the terms of the Microsoft
// license agreement under which you licensed this sample source code. If
// you did not accept the terms of the license agreement, you are not
// authorized to use this sample source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the LICENSE.RTF on your install media or the root of your tools installation.
// THE SAMPLE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:    s5x532.h

Abstract:       OV3640 Camera module setting binary microcode sequence

Functions:


Notes:


--*/

//#ifndef _S5X532_H_
//#define _S5X532_H_

#define SIMPLE_MODULE_SETTING   (FALSE)
#define MODULE_COMMAND_SIZE     (3)

#if (SIMPLE_MODULE_SETTING)
//const 
unsigned char OV3640_YCbCr8bit[][MODULE_COMMAND_SIZE] = 
{
#if 0
  {0xfc, 0x01},
    {0x03, 0x01}, // sw reset

    {0xfc, 0x01},
    {0x04, 0x01},

    {0xfc, 0x02},
    {0x52, 0x80}, // pll_m

    {0xfc, 0x02},
    {0x50, 0x54},
    
    {0xfc, 0x00},
    {0x02, 0x02},

    {0xfc, 0x01},
    {0x02, 0x05},
 #endif 
};

#else

unsigned char OV3640_YCbCr8bit[][MODULE_COMMAND_SIZE] = 
{
#if 1// OV3640
   {0x30, 0x12, 0x80},	//software reset
	{0xff, 0xff, 0x10},	//delay 10ms
//	{0x30, 0x12, 0x10},	//software reset
	{0x30, 0x4d, 0x45},
	{0x30, 0xa7, 0x5e},
	{0x30, 0x87, 0x16},
	{0x30, 0x9C, 0x1a},
	{0x30, 0xa2, 0xe4},
	{0x30, 0xaa, 0x42},
	{0x30, 0xb0, 0xff},	// pin-output
	{0x30, 0xb1, 0xff},	// pin-output
	{0x30, 0xb2, 0x10},
	{0x30, 0x0e, 0x39},
	{0x30, 0x0f, 0x21},
	{0x30, 0x10, 0x20},
	{0x30, 0x4c, 0x81},
	{0x30, 0xd7, 0x10},
	{0x30, 0xd9, 0x0d},
	{0x30, 0xdb, 0x08},
	{0x30, 0x16, 0x82},
//	{0x30, 0x18, 0x48},	// billy--default:0x48  luminance
//	{0x30, 0x19, 0x40},	// 0x40
//	{0x30, 0x1a, 0x82},
	{0x30, 0x7d, 0x00},
	{0x30, 0x87, 0x02},
	{0x30, 0x82, 0x20},
	{0x30, 0x15, 0x12},
	{0x30, 0x14, 0x84},
	{0x30, 0x13, 0xf7},
	{0x30, 0x3c, 0x08},
	{0x30, 0x3d, 0x18},
	{0x30, 0x3e, 0x06},
	{0x30, 0x3f, 0x0c},
	{0x30, 0x30, 0x62},
	{0x30, 0x31, 0x26},
	{0x30, 0x32, 0xe6},
	{0x30, 0x33, 0x6e},
	{0x30, 0x34, 0xea},
	{0x30, 0x35, 0xae},
	{0x30, 0x36, 0xa6},
	{0x30, 0x37, 0x6a},
//	{0x30, 0x77, 0x0f},	0x00// billy::add default:0x00 bit[1]:vsync negative bit[0]:hsync negative
	{0x30, 0x7c, 0x10},	// billy::add
	{0x31, 0x04, 0x02},
	{0x31, 0x05, 0xfd},
	{0x31, 0x06, 0x00},
	{0x31, 0x07, 0xff},
	{0x33, 0x00, 0x13},
	{0x33, 0x01, 0xde},
	{0x33, 0x02, 0xcf},
	{0x33, 0x12, 0x26},
	{0x33, 0x14, 0x42},
	{0x33, 0x13, 0x2b},
	{0x33, 0x15, 0x42},
	{0x33, 0x10, 0xd0},
	{0x33, 0x11, 0xbd},
	{0x33, 0x0c, 0x18},
	{0x33, 0x0d, 0x18},
	{0x33, 0x0e, 0x56},
	{0x33, 0x0f, 0x5c},
	{0x33, 0x0b, 0x1c},
	{0x33, 0x06, 0x5c},
	{0x33, 0x07, 0x11},
	{0x33, 0x6a, 0x52},
	{0x33, 0x70, 0x46},
	{0x33, 0x76, 0x38},
	{0x30, 0xb8, 0x20},
	{0x30, 0xb9, 0x17},
	{0x30, 0xba, 0x04},
	{0x30, 0xbb, 0x08},
	{0x35, 0x07, 0x06},
	{0x35, 0x0a, 0x4f},
	{0x31, 0x00, 0x02},
	{0x33, 0x01, 0xde},
	{0x33, 0x04, 0x00},
	{0x34, 0x00, 0x00},	// 0x00
	{0x34, 0x04, 0x00},//YUV sequence
//	{0x34, 0x00, 0x02},	// 0x00
//	{0x34, 0x04, 0x40},//YUV sequence
//	{0x36, 0x00, 0xc5},//bit[2] Vsync polarity;bit[4] PCLK polarity
	{0x36, 0x00, 0xc0},	// default:0xc0
	{0x30, 0x88, 0x08},
	{0x30, 0x89, 0x00},
	{0x30, 0x8a, 0x06},
	{0x30, 0x8b, 0x00},
	{0x30, 0x8d, 0x04},
	{0x30, 0x86, 0x03},
	{0x30, 0x86, 0x00},
	{0x30, 0xa9, 0xb5},	// 0xbd:dvdd connect 1.5V   0xb5:use interal voltage
	{0x33, 0x17, 0x04},	// billy--default:0x04
	{0x33, 0x16, 0xf0},	// 0xf8
	{0x33, 0x12, 0x35}, 	// 0x31
	{0x33, 0x14, 0x48},	// 0x57
	{0x33, 0x13, 0x2d},	// 0x28
	{0x33, 0x15, 0x40},	// 0x3d
	{0x33, 0x11, 0x97},	// 0xd0
	{0x33, 0x10, 0x8b},	// 0xb6
	{0x33, 0x0c, 0x13},	// 0x16
	{0x33, 0x0d, 0x12},	// 0x16
	{0x33, 0x0e, 0x57},	// 0x5f
	{0x33, 0x0f, 0x4f},	// 0x5c
	{0x33, 0x0b, 0x0f},	// 0x18
	{0x33, 0x06, 0x5e},	// 0x5c
	{0x33, 0x07, 0x11},
	{0x33, 0x08, 0x25},
	{0x33, 0x09, 0x21},	// add
	{0x33, 0x40, 0x20},
	{0x33, 0x41, 0x58},
	{0x33, 0x42, 0x08},
	{0x33, 0x43, 0x21},
	{0x33, 0x44, 0xbe},
	{0x33, 0x45, 0xe0},
	{0x33, 0x46, 0xca},
	{0x33, 0x47, 0xc6},
	{0x33, 0x48, 0x04},
	{0x33, 0x49, 0x98},
	{0x33, 0x55, 0x02},	// billy--contrast enable:0x06 default:0x02
//	{0x33, 0x5c, 0x00},	// billy--add
//	{0x33, 0x5d, 0x2a},	// billy--add
	{0x33, 0x58, 0x44},
	{0x33, 0x59, 0x44},
	{0x33, 0x00, 0x13},
	{0x33, 0x67, 0x23},
	{0x33, 0x68, 0xBB},
	{0x33, 0x69, 0xD6},
	{0x33, 0x6A, 0x2A},
	{0x33, 0x6B, 0x07},
	{0x33, 0x6C, 0x00},
	{0x33, 0x6D, 0x23},
	{0x33, 0x6E, 0xC3},
	{0x33, 0x6F, 0xDE},
	{0x33, 0x70, 0x2b},
	{0x33, 0x71, 0x07},
	{0x33, 0x72, 0x00},
	{0x33, 0x73, 0x23},
	{0x33, 0x74, 0x9e},
	{0x33, 0x75, 0xD6},
	{0x33, 0x76, 0x29},
	{0x33, 0x77, 0x07},
	{0x33, 0x78, 0x00},
	{0x33, 0x2a, 0x1d},
	{0x33, 0x1b, 0x08}, 
	{0x33, 0x1c, 0x16},
	{0x33, 0x1d, 0x2d},
	{0x33, 0x1e, 0x54},
	{0x33, 0x1f, 0x66},
	{0x33, 0x20, 0x73},
	{0x33, 0x21, 0x80},
	{0x33, 0x22, 0x8c}, 
	{0x33, 0x23, 0x95}, 
	{0x33, 0x24, 0x9d},
	{0x33, 0x25, 0xac}, 
	{0x33, 0x26, 0xb8},
	{0x33, 0x27, 0xcc}, 
	{0x33, 0x28, 0xdd},
	{0x33, 0x29, 0xee}, 
	{0x33, 0x2e, 0x04},
	{0x33, 0x2f, 0x04},
	{0x33, 0x31, 0x02},

   	{0x30, 0x12, 0x00},
	{0x30, 0x20, 0x01},
	{0x30, 0x21, 0x1d},
	{0x30, 0x22, 0x00},
	{0x30, 0x23, 0x0a},
	{0x30, 0x24, 0x08},
	{0x30, 0x25, 0x18},
	{0x30, 0x26, 0x06},
	{0x30, 0x27, 0x0c},
	{0x30, 0x2a, 0x06},
	//{0x30, 0x2b, 0x10},	// 0x39
	{0x30, 0x2b, 0x72},	// billy::edit	3.75:0x20  7.14:0x72
	{0x30, 0x75, 0x44},	// 0x24
	{0x30, 0x0d, 0x00},	// 0x01
	{0x30, 0xd7, 0x10},	// 0x90
	{0x30, 0x69, 0x44},	// 0x04
	{0x30, 0x3e, 0x01},	// 0x00
	{0x30, 0x3f, 0x80},	// 0xc0
	{0x33, 0x02, 0xef},
	{0x33, 0x5f, 0x68},
	{0x33, 0x60, 0x18},
	{0x33, 0x61, 0x0c},
	{0x33, 0x62, 0x68},
	{0x33, 0x63, 0x08},
	{0x33, 0x64, 0x04},
	{0x33, 0x66, 0x10},
	{0x34, 0x03, 0x42},
	{0x30, 0x88, 0x08},
	{0x30, 0x89, 0x00},
	{0x30, 0x8a, 0x06},
	{0x30, 0x8b, 0x00},
	{0x30, 0x0e, 0x39},	// 0x32
	{0x30, 0x0f, 0x21},
	{0x30, 0x10, 0x20},
	{0x30, 0x11, 0x00},	// 3.75:0x01  7.14:0x00
	{0x30, 0x4c, 0x81},
	{0x30, 0x1c, 0x0c},	// 7.14::add
	{0x30, 0x1d, 0x0f},	// 7.14::add
	{0x30, 0x71, 0x75},	// 7.14::add
	{0x30, 0x73, 0x66},	// 7.14::add
//jerry   add	
	{0x30, 0x00, 0x00},
	{0x30, 0x02, 0x00},
	{0x30, 0x01, 0x3f}, // 0XFF
	{0x30, 0x03, 0x3f}, //0XFF
	{0x30, 0x05, 0xff},
	{0x30, 0x06, 0x80},
	{0x30, 0x07, 0xff},
//sde	
	{0x33, 0x54, 0x01},
	{0x33, 0x55, 0x04},
//	{0x33, 0x56, 0x02},
//	{0x33, 0x57, 0x02},
//	{0x33, 0x58, 0x02},
//	{0x33, 0x59, 0x02},
//	{0x33, 0x5a, 0x30},
//	{0x33, 0x5b, 0x90},
	{0x33, 0x5c, 0x24},
	{0x33, 0x5d, 0x24},
//	{0x33, 0x5e, 0x02},
//Exposure
// 1.Average-based 
	{0x30, 0x18, 0x40},
	{0x30, 0x19, 0x38},
	{0x30, 0x1a, 0x71},
// 2.Histogram-based	
	{0x30, 0x47, 0x80},
	{0x30, 0x18, 0x98},
	{0x30, 0x19, 0x78},
//Sharpness
	{0x33, 0x2d, 0x44},
#endif
#if 0
	{0x12, 0x80},

//	{0x12, 0x0},
	{0xff,0x10},
	{0x11,0x80},
	{0x6a,0x3e},
	{0x3b,0x09},
//	{0x13,0x8f},
//	{0x01,0x80},
//	{0x02,0x80},
//	{0x00,0x00},
//	{0x00,0xff},
//	{0x10,0x00},
	{0x39,0x43},
	{0x38,0x12},
	{0x37,0x00},
	{0x35,0x91},
	{0x0e,0xa0},
	{0x1e,0x10},
	{0xA8,0x80},
	{0x12,0x40},
	{0x04,0x00},
	{0x0c,0x04},
	{0x0d,0x80},
//	{0x18,0xc6},
//	{0x17,0x26},
	{0x32,0xad},
//	{0x03,0x00},
//	{0x1a,0x3d},
//	{0x19,0x01},
	{0x3f,0xa6},
//	{0x14,0x2e},
	{0x15,0x10},
//	{0x41,0x02},
	{0x42,0x08},
	{0x1b,0x00},
	{0x16,0x06},
	{0x33,0xe2},
	{0x34,0xbf},
	{0x96,0x04},
//	{0x3a,0x00},
	{0x8e,0x00},
	{0x3c,0x77},
	{0x8B,0x06},
	{0x94,0x88},
	{0x95,0x88},
	{0x40,0xc1},
	{0x29,0x3f},
	{0x0f,0x42},
	{0x3d,0x92},
//	{0x69,0x40},
	{0x5C,0xb9},
	{0x5D,0x96},
	{0x5E,0x10},
	{0x59,0xc0},
	{0x5A,0xaf},
	{0x5B,0x55},
	{0x43,0xf0},
	{0x44,0x10},
	{0x45,0x68},
	{0x46,0x96},
	{0x47,0x60},
	{0x48,0x80},
	{0x5F,0xe0},
	{0x60,0x8c},
	{0x61,0x20},
	{0xa5,0xd9},
	{0xa4,0x74},
	{0x8d,0x02},
//	{0x8C,0x23},
	{0x3E,0x02},
	{0xa9,0xb8},
	{0xaa,0x92},
	{0xab,0x0a},
	{0x8f,0xdf},
	{0x90,0x00},
	{0x91,0x00},
	{0x9f,0x00},
	{0xa0,0x00},
//	{0x3A,0x01},
//	{0x24,0x70},
//	{0x25,0x64},
//	{0x26,0xc3},
	{0x2a,0x00},
	{0x2b,0x00},

//
//	{0x04,0x00},
//	{0x0C,0x00},
//	{0x0D,0x00},
// 	{0x11,0x80},
//	{0x12,0x40},
//	{0x37,0x81},
//	{0x38,0x93},
//	{0x39,0x50},
	{0x05,0x40},// 40
	{0x06,0x10},// 10
	{0x08,0x00},// 00
//	{0x10,0x80},
//	{0x8C,0x20},
//	{0x14,0x3a},
	{0x09, 0x01},// 02
	{0x13,0xef},
// vga	
	{0x04,0x00},
	{0x0c,0x04},
	{0x0d,0x80},
	{0x11,0x83},
	{0x12,0x40},
	{0x37,0x00},
	{0x38,0x12},
	{0x39,0x43},
	{0x40,0xc1},
// exposure
	{0x04, 0x02},//[0-1]
	{0x10, 0x7c},//[2-9]
	{0xa1, 0x40},//[10-15]
	{0x24,0x70},
	{0x25,0x64},
	{0x26,0xc3},
//auto white blance	
	{0x01,0x80},
	{0x02,0x80},
	{0x69,0x40},
//agc
	{0x00,0x04},
	{0x03,0x00},
	{0x14,0x2e},
	{0x18,0xc6},
	{0x17,0x26},
	{0x1a,0x3d},
	{0x19,0x01},
//Color Matrix Control
	{0x3d,0x92},
	{0x41,0x02},
	
	{0x4f,0x3a},
	{0x50,0x3d},
	{0x51,0x03},
	{0x52,0x12},
	{0x53,0x26},
	{0x54,0x38},
	{0x55,0x40},
	{0x56,0x40},
	{0x57,0x40},
	{0x58,0x0f},
// Sharpness Control
	{0x3e,0x02},
	{0x3f,0xa6},
	{0x8c,0x23},
//blc	
	{0x3a,0x00},
	{0x67,0x80},
	{0x68,0x80},
	{0x3a,0x01},
//Banding Filter  VGA
//	{0x11,0x83},
	{0xa2,0x4b},
	{0xa3,0x3e},
	
//gamma
	{0x6c,0x40},
	{0x6d,0x30},
	{0x6e,0x4b},
	{0x6f,0x60},
	{0x70,0x70},
	{0x71,0x70},
	{0x72,0x70},
	{0x73,0x70},
	{0x74,0x60},
	{0x75,0x60},
	{0x76,0x50},
	{0x77,0x48},
	{0x78,0x3a},
	{0x79,0x2e},
	{0x7a,0x28},
	{0x7b,0x22},
	{0x7c,0x04},
	{0x7d,0x07},
	{0x7e,0x10},
	{0x7f,0x28},
	{0x80,0x36},
	{0x81,0x44},
	{0x82,0x52},
	{0x83,0x60},
	{0x84,0x6c},
	{0x85,0x78},
	{0x86,0x8c},
	{0x87,0x9e},
	{0x88,0xbb},
	{0x89,0xd2},
	{0x8a,0xe6},
#endif
	
};
#endif

//#endif // _S5X532_H_
