//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this sample source code is subject to the terms of the Microsoft
// license agreement under which you licensed this sample source code. If
// you did not accept the terms of the license agreement, you are not
// authorized to use this sample source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the LICENSE.RTF on your install media or the root of your tools installation.
// THE SAMPLE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
// This code is generated initially by dklee(dokyou.lee@samsung.com)

/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:    s5k4eagx_module.h

Abstract:       S5K4EAGX Camera module header

Functions:


Notes:


--*/


#ifndef __S5K4EAGX_MODULE_H__
#define __S5K4EAGX_MODULE_H__

//========================================================
//  S5K4EAGX SYSLSI module definition

#include <bsp.h>
#include "module.h"
#include "camera_typedef.h"

#define CAM_S5K4EAGX_DEVICE_ID      0x5a  // 8bit slave address for WRITE
#define CAM_S5K4EAGX_I2C_CLOCK      100

//========================================================
//  S5K4EAGX default mode
#define S5K4EAGX_MODULE_ITUXXX         CAM_ITU601
#define S5K4EAGX_MODULE_INTERLACE      0
#define S5K4EAGX_MODULE_MIPI           (TRUE)
#define S5K4EAGX_MODULE_LANE           (DATA_LANE_2)
#define S5K4EAGX_MODULE_JPEG           (1)
#define S5K4EAGX_MODULE_YUVORDER       CAM_ORDER_CRYCBY
#define S5K4EAGX_MODULE_PREVIEWHSIZE   640
#define S5K4EAGX_MODULE_PREVIEWVSIZE   480
#define S5K4EAGX_MODULE_HSIZE          1920
#define S5K4EAGX_MODULE_VSIZE          1080
#define S5K4EAGX_MODULE_HOFFSET        0
#define S5K4EAGX_MODULE_VOFFSET        0
#define S5K4EAGX_MODULE_UVOFFSET       CAM_UVOFFSET_0
#define S5K4EAGX_MODULE_CLOCK          24000000
#define S5K4EAGX_MODULE_CODEC          CAM_FORMAT_YCBYCR422_1PLANE
#define S5K4EAGX_MODULE_HIGHRST        0        // This is affected by Electic circuit for reset or power control PIN, BB37->0, SMDK->1
#define S5K4EAGX_MODULE_INVPCLK        0
#define S5K4EAGX_MODULE_INVVSYNC       0
#define S5K4EAGX_MODULE_INVHREF        0
#define S5K4EAGX_MODULE_HSSETTLE       12


//========================================================
//  S5K4EAGX infomation
#define S5K4EAGX_JPEG_MAX_SIZE          1843200

class S5K4EAGX : public CamModule
{
public:
    S5K4EAGX();    
    S5K4EAGX(ICamComm *CommIF);
    ~S5K4EAGX();    
    MODULE_STATUS Init();
    MODULE_STATUS Deinit();
    MODULE_STATUS InitSensor();
    MODULE_STATUS Power(BOOL bOnOff);
    MODULE_STATUS Standby(BOOL bActive);
    MODULE_STATUS Reset(BOOL bActive);

    MODULE_STATUS GetSupportFormat(MODULE_DESCRIPTOR *outModuleDesc);
    MODULE_STATUS SetFormatSize(CAMIF_IMG_SIZE Size);
    MODULE_STATUS SensorPrepare();
    MODULE_STATUS SensorStart();
    MODULE_STATUS StartCapture();
    MODULE_STATUS StopCapture();
    void S5K4EA_Init(IMG_TYPE eSrcFmt, DWORD CamImgWidth, DWORD CamImgHeight, int eCSISDataLaneNum);
    void S5K4EA_WakeUp(IMG_TYPE eSrcFmt);
    void S5K4EA_Sleep(void);
};



/*=====================================
				S5K4EA Defined
=====================================*/

#define S5K4EA_PREVIEW_MODE		0
#define S5K4EA_CAPTURE_MODE		1

#define S5K4EA_CONTINUOUS			0
#define S5K4EA_NON_CONTINUOUS	1

/*========Defined Value(Don't modify)===========*/
#define S5K4EA_Speed_368Mbps		0
#define S5K4EA_Speed_464Mbps		1
#define S5K4EA_Speed_552Mbps		2
#define S5K4EA_Speed_648Mbps		3
#define S5K4EA_Speed_736Mbps		4
#define S5K4EA_Speed_832Mbps		5
#define S5K4EA_Speed_920Mbps		6

typedef enum _ClockPredefine
{
    S5K4EA4Khz_0Mhz = 0x0000,
    S5K4EA4Khz_46Mhz = 0x2CEC,
    S5K4EA4Khz_58Mhz = 0x38A4,
    S5K4EA4Khz_69Mhz = 0x4362,
    S5K4EA4Khz_81Mhz = 0x4F1A,
    S5K4EA4Khz_91Mhz = 0x58DE,
    S5K4EA4Khz_92Mhz = 0x59D8,
    S5K4EA4Khz_93Mhz = 0x5AD2,
    S5K4EA4Khz_104Mhz = 0x6590,
    S5K4EA4Khz_115Mhz = 0x704E
};
/*
#define S5K4EA4Khz_0Mhz		0x0000
#define S5K4EA4Khz_46Mhz		0x2CEC
#define S5K4EA4Khz_58Mhz		0x38A4
#define S5K4EA4Khz_69Mhz		0x4362
#define S5K4EA4Khz_81Mhz		0x4F1A
#define S5K4EA4Khz_91Mhz		0x58DE
#define S5K4EA4Khz_92Mhz		0x59D8
#define S5K4EA4Khz_93Mhz		0x5AD2
#define S5K4EA4Khz_104Mhz		0x6590
#define S5K4EA4Khz_115Mhz		0x704E
*/

#define S5K4EAFrTime_30fps		0x014D	// 33.3ms -> 30 fps
#define S5K4EAFrTime_15fps		0x029A	// 66.6ms -> 15 fps
#define S5K4EAFrTime_7P5fps		0x0535	// 133.3ms -> 7.5 fps
#define S5K4EAFrTime_1P5fps		0x1964	// 650.0ms -> 1.5 fps
/*=====================================*/
/*========Register map for S5K4EA EVT1(Don't modify)===========*/
#define S5K4EA_REG_TC_IPRM_InClockLSBs				0x0238
#define S5K4EA_REG_TC_IPRM_InClockMSBs				0x023A
#define S5K4EA_REG_TC_IPRM_UseNPviClocks				0x0252
#define S5K4EA_REG_TC_IPRM_UseNMipiClocks				0x0254
#define S5K4EA_REG_TC_IPRM_NumberOfMipiLanes			0x0256
#define S5K4EA_REG_TC_IPRM_OpClk4KHz_0				0x025A
#define S5K4EA_REG_TC_IPRM_MinOutRate4KHz_0			0x025C
#define S5K4EA_REG_TC_IPRM_MaxOutRate4KHz_0			0x025E
#define S5K4EA_REG_TC_IPRM_InitParamsUpdated			0x026E
#define S5K4EA_REG_TC_GP_EnablePreview				0x0280
#define S5K4EA_REG_TC_GP_EnablePreviewChanged		0x0282
#define S5K4EA_REG_TC_GP_EnableCapture				0x0284
#define S5K4EA_REG_TC_GP_EnableCaptureChanged		0x0286
#define S5K4EA_REG_TC_GP_NewConfigSync				0x0290
#define S5K4EA_REG_TC_GP_ActivePrevConfig				0x02A4
#define S5K4EA_REG_TC_GP_PrevConfigChanged			0x02A6
#define S5K4EA_REG_TC_GP_PrevOpenAfterChange			0x02A8
#define S5K4EA_REG_TC_GP_ActiveCapConfig				0x02AC
#define S5K4EA_REG_TC_GP_CapConfigChanged			0x02AE
#define S5K4EA_REG_0TC_PCFG_usWidth					0x02E2
#define S5K4EA_REG_0TC_PCFG_usHeight					0x02E4
#define S5K4EA_REG_0TC_PCFG_Format					0x02E6
#define S5K4EA_REG_0TC_PCFG_usMaxOut4KHzRate			0x02E8
#define S5K4EA_REG_0TC_PCFG_usMinOut4KHzRate			0x02EA
#define S5K4EA_REG_0TC_PCFG_PVIMask					0x02F0
#define S5K4EA_REG_0TC_PCFG_uClockInd					0x02F8
#define S5K4EA_REG_0TC_PCFG_FrRateQualityType			0x02FC
#define S5K4EA_REG_0TC_PCFG_usFrTimeType				0x02FA
#define S5K4EA_REG_0TC_PCFG_usMaxFrTimeMsecMult10	0x02FE
#define S5K4EA_REG_0TC_PCFG_usMinFrTimeMsecMult10	0x0300

namespace S5K4EA_SWREG
{
    namespace TC_IPRM
    {
        enum _regs
        {
            InClockLSBs                 = 0x0238,
            InClockMSBs                 = 0x023A,
            LedGpio                     = 0x023C,
            CM_Init_AfModeType          = 0x023E,
            CM_Init_PwmConfig1          = 0x0240,
            CM_Init_PwmConfig2          = 0x0242,
            CM_Init_GpioConfig1         = 0x0244,
            CM_Init_GpioConfig2         = 0x0246,
            CM_Init_AdcConfig           = 0x0248,
            CM_Init_AdcRateKhz          = 0x024A,
            CM_Init_Mi2cBits            = 0x024C,
            CM_Init_Mi2cRateKhz         = 0x024E,
            InitHwErr                   = 0x0250,
            UseNPviClocks               = 0x0252,
            UseNMipiClocks              = 0x0254,
            NumberOfMipiLanes           = 0x0256,
            OpClk4KHz_0                 = 0x025A,
            MinOutRate4KHz_0            = 0x025C,
            MaxOutRate4KHz_0            = 0x025E,
            InitParamsUpdated           = 0x026E,
        };
        enum _InitHwErr_val
        {
            NoError             = 0,
            NO_LED_GPIO,
            TOO_MANY_PWMS,
            PWM_USED_TWICE,
            GPIO_USED_TWICE,
            TOO_MANY_ADCS,
            ADC_USED_TWICE,
            DRV_NOT_EXIST,
            DRV_HW_INIT_ERROR,
            GPIO_0_NOT_EXIST    = 9
        };
    }
    namespace TC_GP
    {
        enum _regs
        {
            SpecialEffects              = 0x027E,
            EnablePreview               = 0x0280,
            EnablePreviewChanged        = 0x0282,
            EnableCapture               = 0x0284,
            EnableCaptureChanged        = 0x0286,
            InvokeHighSpeedSingleAF     = 0x0288,
            bCaptureAfterHighSpeedAF    = 0x028A,
            bMacroModEHighSpeedAF       = 0x028C,
            HighSpeedAfWinMask          = 0x028E,
            NewConfigSync               = 0x0290,
            PrevReqInputWidth           = 0x0292,
            PrevReqInputHeight          = 0x0294,
            PrevInputWidthOfs           = 0x0296,
            PrevInputHeightOfs          = 0x0298,
            CapReqInputWidth            = 0x029A,
            CapReqInputHeight           = 0x029C,
            CapInputWidthOfs            = 0x029E,
            CapInputHeightOfs           = 0x02A0,
            InputsChangeRequest         = 0x02A2,
            ActivePrevConfig            = 0x02A4,
            PrevConfigChanged           = 0x02A6,
            PrevOpenAfterChange         = 0x02A8,
            ErrorPrevConfig             = 0x02AA,
            ActiveCapConfig             = 0x02AC,
            CapConfigChanged            = 0x02AE,
            ErrorCapConfig              = 0x02B0,
            GasTableChanged             = 0x02B2,
            SRA_AddLow                  = 0x02B4,
            SRA_AddHigh                 = 0x02B6,
            SRA_AccessType              = 0x02B8,
            SRA_Changed                 = 0x02BA,
            bCheckPVIRange              = 0x02BC,
        };
    }
    namespace TC_AF
    {
        enum _regs
        {
            AfCmd                       = 0x02BE,
            AfCmdParam                  = 0x02C0,
            AfCmdError                  = 0x02C2,
            DriverCmd                   = 0x02C4,
            FstWinStartX                = 0x02C6,
            FstWinStartY                = 0x02C8,
            FstWinSizeX                 = 0x02CA,
            FstWinSizeY                 = 0x02CC,
            ScndWinStartX               = 0x02CE,
            ScndWinStartY               = 0x02D0,
            ScndWinSizeX                = 0x02D2,
            ScndWinSizeY                = 0x02D4,
            WinSizesUpdated             = 0x02D6,
            DMSWinStartX                = 0x02D8,
            DMSWinStartY                = 0x02DA,
            DMSWinSizeX                 = 0x02DC,
            DMSWinSizeY                 = 0x02DE,
            DMSWinUpdated               = 0x02E0
        };
    }

    namespace TC_PCFG_0
    {
        enum _regs
        {
            usWidth                 = 0x02E2,
            usHeight                = 0x02E4,
            Format                  = 0x02E6,
            usMaxOut4KHzRate        = 0x02E8,
            usMinOut4KHzRate        = 0x02EA,
            OutClkPerPix88          = 0x02EC,
            uBpp88                  = 0x02EE,
            PVIMask                 = 0x02F0,
            OIFMask                 = 0x02F2,
            usJpegPacketSize        = 0x02F4,
            usJpegTotalPackets      = 0x02F6,
            uClockInd               = 0x02F8,
            usFrTimeType            = 0x02FA,
            FrRateQualityType       = 0x02FC,
            usMaxFrTimeMsecMult10   = 0x02FE,
            usMinFrTimeMsecMult10   = 0x0300,
            sSaturation             = 0x0302,
            sSharpBlur              = 0x0304,
            sGlamour                = 0x0306,
            sColorTemp              = 0x0308,
            uDeviceGammaIndex       = 0x030A,
            uPrevMirror             = 0x030C,
            uCaptureMirror          = 0x030E,
            uRotation               = 0x0310
        };
        enum _Format_val
        {
            RGB565      = 0,
            RGB888      = 1,
            FULL_YUV    = 5,
            CROPPED_YUV = 6,
            BAYER       = 7,
            JPEG        = 9
        };
        enum _PVIMask_val
        {
            B_MSB_FIRST_BIT         = 0,
            B_CLK_NEG_EDGE_BIT,
            B_VALIDV_ACTIVE_LOW_BIT,
            B_VALIDH_ACTIVE_LOW_BIT,
            B_UV_BEFORE_Y_BIT,
            B_V_BEFORE_U_BIT,
            B_VCLK_OUT_ACTIVE_NO_DATA,
            BAYER_2_BYTES_BIT,
            BAYER_8_BITS_BIT,
            BAYER_12_BITS_BIT       = 9
        };
        enum _FrTimeType_val
        {
            FR_TIME_DYNAMIC             = 0,
            FR_TIME_FIXED_NOT_ACCURATE  = 1,
            FR_TIME_FIXED_ACCURATE      = 2
        };
        enum _FrRateQualityType_val
        {
            FRVSQ_DYNAMIC       = 0,
            FRVSQ_BEST_FRRATE   = 1,
            FRVSQ_BEST_QUALITY  = 2
            
        };
    }
    namespace TC_PCFG_1
    {
        enum _regs
        {
            usWidth                 = 0x0312,
            usHeight                = 0x0314,
            Format                  = 0x0316,
            usMaxOut4KHzRate        = 0x0318,
            usMinOut4KHzRate        = 0x031A,
            OutClkPerPix88          = 0x031C,
            uBpp88                  = 0x031E,
            PVIMask                 = 0x0320,
            OIFMask                 = 0x0322,
            usJpegPacketSize        = 0x0324,
            usJpegTotalPackets      = 0x0326,
            uClockInd               = 0x0328,
            usFrTimeType            = 0x032A,
            FrRateQualityType       = 0x032C,
            usMaxFrTimeMsecMult10   = 0x032E,
            usMinFrTimeMsecMult10   = 0x0330,
            sSaturation             = 0x0332,
            sSharpBlur              = 0x0334,
            sGlamour                = 0x0336,
            sColorTemp              = 0x0338,
            uDeviceGammaIndex       = 0x033A,
            uPrevMirror             = 0x033C,
            uCaptureMirror          = 0x033E,
            uRotation               = 0x0340
        };    
    }
    namespace TC_PCFG_2
    {
        enum _regs
        {
            usWidth                 = 0x0342,
            usHeight                = 0x0344,
            Format                  = 0x0346,
            usMaxOut4KHzRate        = 0x0348,
            usMinOut4KHzRate        = 0x034A,
            OutClkPerPix88          = 0x034C,
            uBpp88                  = 0x034E,
            PVIMask                 = 0x0350,
            OIFMask                 = 0x0352,
            usJpegPacketSize        = 0x0354,
            usJpegTotalPackets      = 0x0356,
            uClockInd               = 0x0358,
            usFrTimeType            = 0x035A,
            FrRateQualityType       = 0x035C,
            usMaxFrTimeMsecMult10   = 0x035E,
            usMinFrTimeMsecMult10   = 0x0360,
            sSaturation             = 0x0362,
            sSharpBlur              = 0x0364,
            sGlamour                = 0x0366,
            sColorTemp              = 0x0368,
            uDeviceGammaIndex       = 0x036A,
            uPrevMirror             = 0x036C,
            uCaptureMirror          = 0x036E,
            uRotation               = 0x0370
        };    
    }    
    namespace TC_PCFG_3    {
        enum _regs
        {
            usWidth                 = 0x0372,
            usHeight                = 0x0374,
            Format                  = 0x0376,
            usMaxOut4KHzRate        = 0x0378,
            usMinOut4KHzRate        = 0x037A,
            OutClkPerPix88          = 0x037C,
            uBpp88                  = 0x037E,
            PVIMask                 = 0x0380,
            OIFMask                 = 0x0382,
            usJpegPacketSize        = 0x0384,
            usJpegTotalPackets      = 0x0386,
            uClockInd               = 0x0388,
            usFrTimeType            = 0x038A,
            FrRateQualityType       = 0x038C,
            usMaxFrTimeMsecMult10   = 0x038E,
            usMinFrTimeMsecMult10   = 0x0390,
            sSaturation             = 0x0392,
            sSharpBlur              = 0x0394,
            sGlamour                = 0x0396,
            sColorTemp              = 0x0398,
            uDeviceGammaIndex       = 0x039A,
            uPrevMirror             = 0x039C,
            uCaptureMirror          = 0x039E,
            uRotation               = 0x03A0
        };    
    }        
    namespace TC_PCFG_4
    {
        enum _regs
        {
            usWidth                 = 0x03A2,
            usHeight                = 0x03A4,
            Format                  = 0x03A6,
            usMaxOut4KHzRate        = 0x03A8,
            usMinOut4KHzRate        = 0x03AA,
            OutClkPerPix88          = 0x03AC,
            uBpp88                  = 0x03AE,
            PVIMask                 = 0x03B0,
            OIFMask                 = 0x03B2,
            usJpegPacketSize        = 0x03B4,
            usJpegTotalPackets      = 0x03B6,
            uClockInd               = 0x03B8,
            usFrTimeType            = 0x03BA,
            FrRateQualityType       = 0x03BC,
            usMaxFrTimeMsecMult10   = 0x03BE,
            usMinFrTimeMsecMult10   = 0x03C0,
            sSaturation             = 0x03C2,
            sSharpBlur              = 0x03C4,
            sGlamour                = 0x03C6,
            sColorTemp              = 0x03C8,
            uDeviceGammaIndex       = 0x03CA,
            uPrevMirror             = 0x03CC,
            uCaptureMirror          = 0x03CE,
            uRotation               = 0x03D0
        };    
    }        
    namespace TC_CCFG_0
    {
        enum _regs
        {
            uCaptureMode            = 0x03D2,
            bUseMechShut            = 0x03D4,
            usWidth                 = 0x03D6,
            usHeight                = 0x03D8,
            Format                  = 0x03DA,
            usMaxOut4KHzRate        = 0x03DC,
            usMinOut4KHzRate        = 0x03DE,
            OutClkPerPix88          = 0x03E0,
            uBpp88                  = 0x03E2,
            PVIMask                 = 0x03E4,
            OIFMask                 = 0x03E6,
            usJpegPacketSize        = 0x03E8,
            usJpegTotalPackets      = 0x03EA,
            uClockInd               = 0x03EC,
            usFrTimeType            = 0x03EE,
            FrRateQualityType       = 0x03F0,
            usMaxFrTimeMsecMult10   = 0x03F2,
            usMinFrTimeMsecMult10   = 0x03F4,
            sSaturation             = 0x03F6,
            sSharpBlur              = 0x03F8,
            sGlamour                = 0x03FA,
            sColorTemp              = 0x03FC,
            uDeviceGammaIndex       = 0x03FE,
        };
    }
    namespace TC_CCFG_1
    {
        enum _regs
        {
            uCaptureMode            = 0x0400,
            bUseMechShut            = 0x0402,
            usWidth                 = 0x0404,
            usHeight                = 0x0406,
            Format                  = 0x0408,
            usMaxOut4KHzRate        = 0x040A,
            usMinOut4KHzRate        = 0x040C,
            OutClkPerPix88          = 0x040E,
            uBpp88                  = 0x0410,
            PVIMask                 = 0x0412,
            OIFMask                 = 0x0414,
            usJpegPacketSize        = 0x0416,
            usJpegTotalPackets      = 0x0418,
            uClockInd               = 0x041A,
            usFrTimeType            = 0x041C,
            FrRateQualityType       = 0x041E,
            usMaxFrTimeMsecMult10   = 0x0420,
            usMinFrTimeMsecMult10   = 0x0422,
            sSaturation             = 0x0424,
            sSharpBlur              = 0x0426,
            sGlamour                = 0x0428,
            sColorTemp              = 0x042A,
            uDeviceGammaIndex       = 0x042C,
        };
    }    
    namespace TC_CCFG_2
    {
        enum _regs
        {
            uCaptureMode            = 0x042E,
            bUseMechShut            = 0x0430,
            usWidth                 = 0x0432,
            usHeight                = 0x0434,
            Format                  = 0x0436,
            usMaxOut4KHzRate        = 0x0438,
            usMinOut4KHzRate        = 0x043A,
            OutClkPerPix88          = 0x043C,
            uBpp88                  = 0x043E,
            PVIMask                 = 0x0440,
            OIFMask                 = 0x0442,
            usJpegPacketSize        = 0x0444,
            usJpegTotalPackets      = 0x0446,
            uClockInd               = 0x0448,
            usFrTimeType            = 0x044A,
            FrRateQualityType       = 0x044C,
            usMaxFrTimeMsecMult10   = 0x044E,
            usMinFrTimeMsecMult10   = 0x0450,
            sSaturation             = 0x0452,
            sSharpBlur              = 0x0454,
            sGlamour                = 0x0456,
            sColorTemp              = 0x0458,
            uDeviceGammaIndex       = 0x045A,
        };
    } 
    namespace TC_CCFG_3
    {
        enum _regs
        {
            uCaptureMode            = 0x045C,
            bUseMechShut            = 0x045E,
            usWidth                 = 0x0460,
            usHeight                = 0x0462,
            Format                  = 0x0464,
            usMaxOut4KHzRate        = 0x0466,
            usMinOut4KHzRate        = 0x0468,
            OutClkPerPix88          = 0x046A,
            uBpp88                  = 0x046C,
            PVIMask                 = 0x046E,
            OIFMask                 = 0x0470,
            usJpegPacketSize        = 0x0472,
            usJpegTotalPackets      = 0x0474,
            uClockInd               = 0x0476,
            usFrTimeType            = 0x0478,
            FrRateQualityType       = 0x047A,
            usMaxFrTimeMsecMult10   = 0x047C,
            usMinFrTimeMsecMult10   = 0x047E,
            sSaturation             = 0x0480,
            sSharpBlur              = 0x0482,
            sGlamour                = 0x0484,
            sColorTemp              = 0x0486,
            uDeviceGammaIndex       = 0x0488,
        };
    }        
    namespace TC_CCFG_4
    {
        enum _regs
        {
            uCaptureMode            = 0x048A,
            bUseMechShut            = 0x048C,
            usWidth                 = 0x048E,
            usHeight                = 0x0490,
            Format                  = 0x0492,
            usMaxOut4KHzRate        = 0x0494,
            usMinOut4KHzRate        = 0x0496,
            OutClkPerPix88          = 0x0498,
            uBpp88                  = 0x049A,
            PVIMask                 = 0x049C,
            OIFMask                 = 0x049E,
            usJpegPacketSize        = 0x04A0,
            usJpegTotalPackets      = 0x04A2,
            uClockInd               = 0x04A4,
            usFrTimeType            = 0x04A6,
            FrRateQualityType       = 0x04A8,
            usMaxFrTimeMsecMult10   = 0x04AA,
            usMinFrTimeMsecMult10   = 0x04AC,
            sSaturation             = 0x04AE,
            sSharpBlur              = 0x04B0,
            sGlamour                = 0x04B2,
            sColorTemp              = 0x04B4,
            uDeviceGammaIndex       = 0x04B6,
        };
    }        
    namespace TC_CFGUSERSET
    {
        enum _regs
        {
            NColsHBLank             = 0x04B8,
            nLinesVBLank            = 0x04BA
        };
    }
    namespace TC_BRC
    {
        enum _regs
        {
            BRC_type                = 0x04BC,
            usPrevQuality           = 0x04BE,
            usCaptureQuality        = 0x04C0,
        };
    }
    namespace TC_THUMB
    {
        enum _regs
        {
            Thumb_bActive           = 0x04C2,
            Thumb_uWidth            = 0x04C4,
            Thumb_uHeight           = 0x04C6,
            Thumb_Format            = 0x04C8
        };
    }
    namespace TC_PZOOM
    {
        enum _regs
        {
            us88TargetZoom              = 0x04D4,
            us88ZoomStep                = 0x04D6,
            usZoomSpeed                 = 0x04D8,
            PrevZoomReqInputWidth       = 0x04DA,
            PrevZoomReqInputHeight      = 0x04DC,
            PrevZoomReqInputWidthOfs    = 0x04DE,
            PrevZoomReqInputHeightOfs   = 0x04E0,
            CapZoomReqInputWidth        = 0x04E2,
            CapZoomReqInputHeight       = 0x04E4,
            CapZoomReqInputWidthOfs     = 0x04E6,
            CapZoomReqInputHeightOfs    = 0x04E8,
            ePzoomState                 = 0x04EA
        };
    }
    namespace HIGH_FPS
    {
        enum _regs
        {
            RTA_SyncMode            = 0x053A,
            uConfigSetClocksDiv40   = 0x053C,
            uSetStreamClocksDiv40   = 0x053E,
            UseHighSpeedAng         = 0x0540
        };
    }
    namespace AE
    {
        enum _regs
        {
            TVAR_ae_BrAve           = 0x13C8,
            WeightTbl_16_0          = 0x13D6,
            WeightTbl_16_1          = 0x13D8,
            WeightTbl_16_2          = 0x13DA,
            WeightTbl_16_3          = 0x13DC,
            WeightTbl_16_4          = 0x13DE,
            WeightTbl_16_5          = 0x13E0,
            WeightTbl_16_6          = 0x13E2,
            WeightTbl_16_7          = 0x13E4,
            WeightTbl_16_8          = 0x13E6,
            WeightTbl_16_9          = 0x13E8,
            WeightTbl_16_10         = 0x13EA,
            WeightTbl_16_11         = 0x13EC,
            WeightTbl_16_12         = 0x13EE,
            WeightTbl_16_13         = 0x13F0,
            WeightTbl_16_14         = 0x13F2,
            WeightTbl_16_15         = 0x13F4,
            WeightTbl_16_16         = 0x13F6,
            WeightTbl_16_17         = 0x13F8,
            WeightTbl_16_18         = 0x13FA,
            WeightTbl_16_19         = 0x13FC,
            WeightTbl_16_20         = 0x13FE,
            WeightTbl_16_21         = 0x1400,
            WeightTbl_16_22         = 0x1402,
            WeightTbl_16_23         = 0x1404,
            WeightTbl_16_24         = 0x1406,
            WeightTbl_16_25         = 0x1408,
            WeightTbl_16_26         = 0x140A,
            WeightTbl_16_27         = 0x140C,
            WeightTbl_16_28         = 0x140E,
            WeightTbl_16_29         = 0x1410,
            WeightTbl_16_30         = 0x1412,
            WeightTbl_16_31         = 0x1414,
        };
        
    }
    namespace JPEG
    {
        enum _regs
        {
            BrcMinQuality               = 0x1692,
            BppAutoBrcSpoofPercentage   = 0x1698,
            BrcFactorForHalfSizes_0     = 0x169A,
            BrcFactorForHalfSizes_1     = 0x169C,
            BrcFactorForHalfSizes_2     = 0x169E,
            BrcInspectionCropToFull     = 0x16A0,
            QFvsFSbase_0                = 0x16A2,
            QFvsFSbase_1                = 0x16A4,
            QFvsFSbase_2                = 0x16A6,
            QFvsFSbase_3                = 0x16A8,
            QFvsFSbase_4                = 0x16AA,
            QFvsFSbase_5                = 0x16AC,
            QFvsFSbase_6                = 0x16AE,
            QFvsFSbase_7                = 0x16B0,
            QFvsFSbase_8                = 0x16B2,
            QFvsFSbase_9                = 0x16B4,
            HighQFvsFSbase_0            = 0x16B6,
            HighQFvsFSbase_1            = 0x16B8,            
            HighQFvsFSbase_2            = 0x16BA,            
            HighQFvsFSbase_3            = 0x16BC,            
            HighQFvsFSbase_4            = 0x16BE,            
            HighQFvsFSbase_5            = 0x16C0,            
            HighQFvsFSbase_6            = 0x16C2,            
            HighQFvsFSbase_7            = 0x16C4,            
            HighQFvsFSbase_8            = 0x16C6,            
            HighQFvsFSbase_9            = 0x16C8,            
            HighQFvsFSbase_10           = 0x16CA,
            pLumQT                      = 0x16CC,
            pChromQT                    = 0x16D0,
            useScaladoJPEG              = 0x16D4,
            MinQtblValue                = 0x16D6
        };
    }
}
#define S5K4EA_REG_0TC_CCFG_uCaptureMode            0x03D2
#define S5K4EA_REG_0TC_CCFG_bUseMechShut            0x03D4
#define S5K4EA_REG_0TC_CCFG_usWidth                 0x03D6
#define S5K4EA_REG_0TC_CCFG_usHeight                0x03D8
#define S5K4EA_REG_0TC_CCFG_Format                  0x03DA
#define S5K4EA_REG_0TC_CCFG_usMaxOut4KHzRate        0x03DC
#define S5K4EA_REG_0TC_CCFG_usMinOut4KHzRate        0x03DE
#define S5K4EA_REG_0TC_CCFG_OutClkPerPix88          0x03E0
#define S5K4EA_REG_0TC_CCFG_uBpp88                  0x03E2
#define S5K4EA_REG_0TC_CCFG_PVIMask                 0x03E4
#define S5K4EA_REG_0TC_CCFG_OFIMask                 0x03E6

/*================================================*/

/*========4EA Setting(Modify)=================*/
/*	FPS Setting	*/
#define S5K4EA_FrTime_MAX	S5K4EAFrTime_30fps
/*	Speed Setting	*/
#define S5K4EA_LANESPEED	S5K4EA_Speed_736Mbps
/*======================================*/
#if (S5K4EA_LANESPEED == S5K4EA_Speed_368Mbps)
// 368 Mbps(Pclk 46Mhz)
#define S5K4EA_PCLK_MIN	S5K4EA4Khz_46Mhz
#define S5K4EA_PCLK_MAX	S5K4EA4Khz_46Mhz
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_464Mbps)
// 464 Mbps (Pclk 58Mhz)
#define S5K4EA_PCLK_MIN	S5K4EA4Khz_58Mhz
#define S5K4EA_PCLK_MAX	S5K4EA4Khz_58Mhz
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_552Mbps)
// 552 Mbps(Pclk 69Mhz)
#define S5K4EA_PCLK_MIN	S5K4EA4Khz_69Mhz
#define S5K4EA_PCLK_MAX	S5K4EA4Khz_69Mhz
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_648Mbps)
// 648 Mbps(Pclk 81Mhz)
#define S5K4EA_PCLK_MIN	S5K4EA4Khz_81Mhz
#define S5K4EA_PCLK_MAX	S5K4EA4Khz_81Mhz
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_736Mbps)
// 736 Mbps(Pclk 92Mhz)
#define S5K4EA_PCLK_MIN	S5K4EA4Khz_91Mhz
#define S5K4EA_PCLK_MAX	S5K4EA4Khz_93Mhz
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_832Mbps)
// 832 Mbps(Pclk 104Mhz)
#define S5K4EA_PCLK_MIN	S5K4EA4Khz_104Mhz
#define S5K4EA_PCLK_MAX	S5K4EA4Khz_104Mhz
#elif (S5K4EA_LANESPEED == S5K4EA_Speed_920Mbps)
// 920 Mbps(Pclk 115Mhz)
#define S5K4EA_PCLK_MIN	S5K4EA4Khz_115Mhz
#define S5K4EA_PCLK_MAX	S5K4EA4Khz_115Mhz
#endif

#define NUN_OF_MIPI_LANES           2
#define CAMERA_RESOLUTION_WIDTH     S5K4EAGX_MODULE_HSIZE
#define CAMERA_RESOLUTION_HEIGHT    S5K4EAGX_MODULE_VSIZE



#endif //__S5K4EAGX_MODULE_H__
