
#ifndef __CSI_S_H__
#define __CSI_S_H__

//#include "typedef.h"
#include <mipicsi_reg.h>
#include "camera_typedef.h"


enum CSI_S_DATA_ALIGN
{
    BIT_ALIGN_24=0, BIT_ALIGN_32=1
};


enum CSI_S_WCLK_SRC
{
    PCLK_SRC=0, EXTCLK_SRC=1
};

enum CSI_S_DATA_LANE
{
    DATA_LANE_1=0, DATA_LANE_2=1,DATA_LANE_3=2, DATA_LANE_4=3
};

enum CSI_S_IMG_FMT
{
    FMT_YUV422=0, FMT_BAYER_8=1,FMT_BAYER_10=2, FMT_BAYER_12=3,
    FMT_USER_DEFINED_TYPE1=4, FMT_USER_DEFINED_TYPE2=5, FMT_USER_DEFINED_TYPE3=6,FMT_USER_DEFINED_TYPE4=7

};

enum CSI_S_INTR_SRC
{
    EVEN_BEFORE, EVEN_AFTER, ODD_BEFORE, ODD_AFTER,
    ERR_SOT_HS_1, ERR_SOT_HS_0, ERR_CTRL_1, ERR_CTRL_0,
    ERR_ECC, ERR_CRC, ERR_ID, ALLINT
};

#define CSI_PKTDATA_REG_START_OFFSET    (0x2000)    // BASE Address + 0x2000
#define CSI_PKTDATA_REG_SIZE            (0x2000)//(0x1FFF)    // ~ BASE Address + 0x3FFF

#define IS_ON(val, bitmask)  ((val) == ((val) & (bitmask)))

class CSI_S
{
public:    
    CSI_S(DWORD dwPhyBaseAddress);              // This will map physical address to virtual address
    ~CSI_S();
    void GetIntrSrc(CSI_S_INTR_SRC& eSrc);
    void ClearInterrupt(const CSI_S_INTR_SRC eSrc);
    void StopIp(void);
    void InitIp(const CSI_S_DATA_LANE eDataLane,CSI_S_IMG_FMT eImgType, 
                CSI_S_DATA_ALIGN eDataAlign ,CSI_S_WCLK_SRC eWCLKSrc,
                unsigned char eHSsettle,  DWORD eHorizon, DWORD eVertical, 
                DWORD dwLintv, DWORD dwSintv, DWORD dwEintv);
    BOOL CheckPacketHeaderECC();
    BOOL CheckPacketDataCRC();    
    void DUMPRegs(void);
    
protected:

    void ResetIp(void);
    void SetNumOfDataLane(const CSI_S_DATA_LANE eDataLane);
    void SetWrapperTiming(DWORD dwLintv, DWORD dwSintv, DWORD dwEintv);
    void SetImgFormat(CSI_S_IMG_FMT eFinImgType);
    void SetWClkSrc(CSI_S_WCLK_SRC eClkSrc);
    void SetDataAlign(CSI_S_DATA_ALIGN eAlign);
    void SetHSsettle(unsigned char eHSsettle);
    void SetImageResolution(DWORD Hor, DWORD Vert);
    void EnableInterrupt(void);
    void DisableInterrupt(void);
    void SystemOn(void);
    void SystemOff(void);
    void DphyOn(CSI_S_DATA_LANE eDataLane);
    void DphyOff(void);  
    void UpdateShadow(void);
   

    volatile MIPICSI_REG *m_pMIPICSI_Reg;
    volatile DWORD *m_pPKTDATA_Reg;
    
    
};

void InitBaseHwForMipiCsi_s(void);

#endif //__CSI_S_H__
