//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this sample source code is subject to the terms of the Microsoft
// license agreement under which you licensed this sample source code. If
// you did not accept the terms of the license agreement, you are not
// authorized to use this sample source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the LICENSE.RTF on your install media or the root of your tools installation.
// THE SAMPLE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
// This code is generated initially by dklee(dokyou.lee@samsung.com)

/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:    OV3640_module.h

Abstract:       OV3640 Camera module header

Functions:


Notes:


--*/


#ifndef __OV3640_MODULE_H__
#define __OV3640_MODULE_H__

//========================================================
//  OV3640 SYSLSI module definition

#include <bsp.h>
#include "module.h"
#include "camera_typedef.h"

//#define CAM_OV3640_DEVICE_ID      0x5a  // 8bit slave address for WRITE
#define CAM_OV3640_DEVICE_ID	0x78 //OV 3640
#define CAM_OV3640_I2C_CLOCK      100


//========================================================
//  OV3640 default mode
#define OV3640_MODULE_ITUXXX         CAM_ITU601
#define OV3640_MODULE_INTERLACE      0
#define OV3640_MODULE_MIPI           (FALSE)
#define OV3640_MODULE_YUVORDER       CAM_ORDER_YCBYCR
#define OV3640_MODULE_HSIZE          2048
#define OV3640_MODULE_VSIZE          1536
#define OV3640_MODULE_HOFFSET        0
#define OV3640_MODULE_VOFFSET        0
#define OV3640_MODULE_UVOFFSET       CAM_UVOFFSET_0
#define OV3640_MODULE_CLOCK          24000000
#define OV3640_MODULE_CODEC         CAM_FORMAT_YCBYCR422_1PLANE
#define OV3640_MODULE_HIGHRST       1       // This is affected by Electic circuit for reset or power control PIN, BB37->0, SMDK->1
#define OV3640_MODULE_INVPCLK        0
#define OV3640_MODULE_INVVSYNC       0
#define OV3640_MODULE_INVHREF        0

//========================================================
//  OV3640 infomation

class OV3640 : public CamModule
{
public:
    OV3640();    
    OV3640(ICamComm *CommIF);
    ~OV3640();    
    MODULE_STATUS Init();
    MODULE_STATUS Deinit();
    MODULE_STATUS InitSensor();
    MODULE_STATUS Power(BOOL bOnOff);
    MODULE_STATUS Standby(BOOL bActive);
    MODULE_STATUS Reset(BOOL bActive);

    MODULE_STATUS GetSupportFormat(MODULE_DESCRIPTOR *outModuleDesc);
    MODULE_STATUS SetFormatSize(CAMIF_IMG_SIZE Size);
    MODULE_STATUS SensorPrepare();
    MODULE_STATUS SensorStart();
};

#endif //__OV3640_MODULE_H__
