//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this sample source code is subject to the terms of the Microsoft
// license agreement under which you licensed this sample source code. If
// you did not accept the terms of the license agreement, you are not
// authorized to use this sample source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the LICENSE.RTF on your install media or the root of your tools installation.
// THE SAMPLE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
// This code is generated initially by dklee(dokyou.lee@samsung.com)

/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:    OV2655_module.h

Abstract:       OV2655 Camera module header

Functions:


Notes:


--*/


#ifndef __OV2655_MODULE_H__
#define __OV2655_MODULE_H__

//========================================================
//  OV2655 SYSLSI module definition

#include <bsp.h>
#include "module.h"
#include "camera_typedef.h"


//#define CAM_OV2655_DEVICE_ID      0x5a  // 8bit slave address for WRITE
#define CAM_OV2655_DEVICE_ID	0x60// OV2655  //0x78 //OV 3640
#define CAM_OV2655_I2C_CLOCK      100


#define CAM_TVP5150_DEVICE_ID 		0xB8  //0xBA
#define CAM_TVP5150_I2C_CLOCK  		100

#ifdef TVP5150

//========================================================
//  TVP5150 default mode
#define OV2655_MODULE_ITUXXX         CAM_ITU656
#define OV2655_MODULE_INTERLACE      0
#define OV2655_MODULE_MIPI           (FALSE)
#define OV2655_MODULE_YUVORDER       CAM_ORDER_CBYCRY
#define OV2655_MODULE_HSIZE           720//640
#define OV2655_MODULE_VSIZE          240//250//480
#define OV2655_MODULE_HOFFSET        0
#define OV2655_MODULE_VOFFSET        0
#define OV2655_MODULE_UVOFFSET       CAM_UVOFFSET_0
#define OV2655_MODULE_CLOCK          27000000
#define OV2655_MODULE_CODEC          CAM_FORMAT_CBYCRY422_1PLANE//CAM_FORMAT_YCBYCR422_1PLANE
#define OV2655_MODULE_HIGHRST        1       // This is affected by Electic circuit for reset or power control PIN, BB37->0, SMDK->1
#define OV2655_MODULE_INVPCLK        0
#define OV2655_MODULE_INVVSYNC       0
#define OV2655_MODULE_INVHREF        0

//========================================================
#else

#ifdef OV2655_1600_1200
// 1600*1200

//  OV2655 default mode
#define OV2655_MODULE_ITUXXX         CAM_ITU601
#define OV2655_MODULE_INTERLACE      0
#define OV2655_MODULE_MIPI           (FALSE)
#define OV2655_MODULE_YUVORDER      CAM_ORDER_YCBYCR// CAM_ORDER_CBYCRY   
#define OV2655_MODULE_HSIZE          1600//800//640
#define OV2655_MODULE_VSIZE          1200//600//480
#define OV2655_MODULE_HOFFSET        0
#define OV2655_MODULE_VOFFSET        0
#define OV2655_MODULE_UVOFFSET       CAM_UVOFFSET_0
#define OV2655_MODULE_CLOCK          24000000
#define OV2655_MODULE_CODEC          CAM_FORMAT_YCBYCR422_1PLANE
#define OV2655_MODULE_HIGHRST        1       // This is affected by Electic circuit for reset or power control PIN, BB37->0, SMDK->1
#define OV2655_MODULE_INVPCLK        0
#define OV2655_MODULE_INVVSYNC       0
#define OV2655_MODULE_INVHREF        0


#else   // 800*600

//  OV2655 default mode
#define OV2655_MODULE_ITUXXX         CAM_ITU601
#define OV2655_MODULE_INTERLACE      0
#define OV2655_MODULE_MIPI           (FALSE)
#define OV2655_MODULE_YUVORDER       CAM_ORDER_CBYCRY
#define OV2655_MODULE_HSIZE          800//640
#define OV2655_MODULE_VSIZE          600//480
#define OV2655_MODULE_HOFFSET        0
#define OV2655_MODULE_VOFFSET        0
#define OV2655_MODULE_UVOFFSET       CAM_UVOFFSET_0
#define OV2655_MODULE_CLOCK          24000000
#define OV2655_MODULE_CODEC          CAM_FORMAT_YCBYCR422_1PLANE
#define OV2655_MODULE_HIGHRST        1       // This is affected by Electic circuit for reset or power control PIN, BB37->0, SMDK->1
#define OV2655_MODULE_INVPCLK        0
#define OV2655_MODULE_INVVSYNC       0
#define OV2655_MODULE_INVHREF        0

#endif


#endif
class OV2655 : public CamModule
{
public:
    OV2655();
    OV2655(ICamComm *CommIF);
    ~OV2655();
    MODULE_STATUS Init();
    MODULE_STATUS Deinit();
    MODULE_STATUS InitSensor();
    MODULE_STATUS Power(BOOL bOnOff);
    MODULE_STATUS Standby(BOOL bActive);
    MODULE_STATUS Reset(BOOL bActive);

    MODULE_STATUS GetSupportFormat(MODULE_DESCRIPTOR *outModuleDesc);
    MODULE_STATUS SetFormatSize(CAMIF_IMG_SIZE Size);
    MODULE_STATUS SensorPrepare();
    MODULE_STATUS SensorStart();
};

#endif //__OV2655_MODULE_H__
