//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this sample source code is subject to the terms of the Microsoft
// license agreement under which you licensed this sample source code. If
// you did not accept the terms of the license agreement, you are not
// authorized to use this sample source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the LICENSE.RTF on your install media or the root of your tools installation.
// THE SAMPLE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
//
// Copyright (c) Samsung Electronics. Co. LTD.  All rights reserved.
//
/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.

Module Name:    sensorformats.h

Abstract:       redefine stream mode

Functions:


Notes:


--*/

#ifndef __SENSORFORMATS_H
#define __SENSORFORMATS_H

#ifndef mmioFOURCC    
#define mmioFOURCC( ch0, ch1, ch2, ch3 )          \
     ( (DWORD)(BYTE)(ch0) | ( (DWORD)(BYTE)(ch1) << 8 ) |  \
     ( (DWORD)(BYTE)(ch2) << 16 ) | ( (DWORD)(BYTE)(ch3) << 24 ) )
#endif  

#define BITRATE(DX,DY,DBITCOUNT,FRAMERATE)    (DX * abs(DY) * DBITCOUNT * FRAMERATE)
#define SAMPLESIZE(DX,DY,DBITCOUNT) (DX * abs(DY) * DBITCOUNT / 8)
#define JPEG_SAMPLESIZE                     (DEFAULT_STILL_WIDTH*DEFAULT_STILL_HEIGHT*STILL_BPP)

#define REFTIME_30FPS 333333
#define REFTIME_15FPS 666666
#define REFTIME_3FPS  3333333

//
// FourCC of the YUV formats
// For information about FourCC, go to:
//     http://www.webartz.com/fourcc/indexyuv.htm
//     http://www.fourcc.org
//

#define FOURCC_UYVY     mmioFOURCC('U', 'Y', 'V', 'Y')  // MSYUV: 1394 conferencing camera 4:4:4 mode 1 and 3, CbYCrY
#define FOURCC_YUY2     mmioFOURCC('Y', 'U', 'Y', '2')  // YCbYCr
#define FOURCC_YUYV     mmioFOURCC('Y', 'U', 'Y', 'V')  // YCbYCr
#define FOURCC_YVYU     mmioFOURCC('Y', 'V', 'Y', 'U')  // YCrYCb
#define FOURCC_YV12     mmioFOURCC('Y', 'V', '1', '2')  // 3 planar type
#define FOURCC_NV12     mmioFOURCC('N', 'V', '1', '2')  // 2 planar type
#define FOURCC_IJPG     mmioFOURCC('I', 'J', 'P', 'G')  // deal with YUV

#define MEDIASUBTYPE_RGB565 {0xe436eb7b, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70}
#define MEDIASUBTYPE_RGB555 {0xe436eb7c, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70}
#define MEDIASUBTYPE_RGB24  {0xe436eb7d, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70}
#define MEDIASUBTYPE_RGB32  {0xe436eb7e, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70}

#define MEDIASUBTYPE_YV12   {FOURCC_YV12, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71}
#define MEDIASUBTYPE_YUY2   {FOURCC_YUY2, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71}
#define MEDIASUBTYPE_NV12   {FOURCC_NV12, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71}
#define MEDIASUBTYPE_IJPG   {FOURCC_IJPG, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71}

#define MAKE_STREAM_MODE_YV12(StreamModeName, DX, DY, DBITCOUNT, FRAMERATE) \
    CS_DATARANGE_VIDEO StreamModeName =  \
    { \
        {    \
            sizeof (CS_DATARANGE_VIDEO),     \
            0, \
            SAMPLESIZE(DX,DY,DBITCOUNT),     \
            0,                               \
            STATIC_CSDATAFORMAT_TYPE_VIDEO,   \
            MEDIASUBTYPE_YV12, \
            STATIC_CSDATAFORMAT_SPECIFIER_VIDEOINFO \
        }, \
 \
        TRUE,                   \
        TRUE,                   \
        CS_VIDEOSTREAM_CAPTURE, \
        0,                      \
 \
        { \
            STATIC_CSDATAFORMAT_SPECIFIER_VIDEOINFO,  \
            CS_AnalogVideo_None, \
            DX,DY,    \
            DX,DY,    \
            DX,DY,    \
            1,        \
            1,        \
            1,        \
            1,        \
            DX, DY,   \
            DX, DY,   \
            DX,       \
            DY,       \
            0,        \
            0,        \
            0,        \
            0,        \
            REFTIME_##FRAMERATE##FPS,                      \
            REFTIME_##FRAMERATE##FPS,                      \
            BITRATE(DX,DY,DBITCOUNT,FRAMERATE) / 8,        \
            BITRATE(DX,DY,DBITCOUNT,FRAMERATE),            \
        },  \
 \
        { \
            0,0,DX,DY,                            \
            0,0,DX,DY,                            \
            BITRATE(DX,DY,DBITCOUNT,FRAMERATE), \
            0L,                                 \
            REFTIME_##FRAMERATE##FPS,                      \
            sizeof (CS_BITMAPINFOHEADER),       \
            DX,                                 \
            DY,                                 \
            3,                        \
            DBITCOUNT,                \
            FOURCC_YV12 | BI_SRCPREROTATE,      \
            SAMPLESIZE(DX,DY,DBITCOUNT), \
            0,                        \
            0,                        \
            0,                        \
            0,                        \
            0, 0, 0                   \
        } \
    }; 

#define MAKE_STREAM_MODE_YUY2(StreamModeName, DX, DY, DBITCOUNT, FRAMERATE) \
    CS_DATARANGE_VIDEO StreamModeName =  \
    { \
        {    \
            sizeof (CS_DATARANGE_VIDEO),     \
            0, \
            SAMPLESIZE(DX,DY,DBITCOUNT),     \
            0,                               \
            STATIC_CSDATAFORMAT_TYPE_VIDEO,   \
            MEDIASUBTYPE_YUY2, \
            STATIC_CSDATAFORMAT_SPECIFIER_VIDEOINFO \
        }, \
 \
        TRUE,                   \
        TRUE,                   \
        CS_VIDEOSTREAM_CAPTURE, \
        0,                      \
 \
        { \
            STATIC_CSDATAFORMAT_SPECIFIER_VIDEOINFO,  \
            CS_AnalogVideo_None, \
            DX,DY,    \
            DX,DY,    \
            DX,DY,    \
            1,        \
            1,        \
            1,        \
            1,        \
            DX, DY,   \
            DX, DY,   \
            DX,       \
            DY,       \
            0,        \
            0,        \
            0,        \
            0,        \
            REFTIME_##FRAMERATE##FPS,                      \
            REFTIME_##FRAMERATE##FPS,                      \
            BITRATE(DX,DY,DBITCOUNT,FRAMERATE) / 8,        \
            BITRATE(DX,DY,DBITCOUNT,FRAMERATE),            \
        },  \
 \
        { \
            0,0,0,0,                            \
            0,0,0,0,                            \
            BITRATE(DX,DY,DBITCOUNT,FRAMERATE), \
            0L,                                 \
            REFTIME_##FRAMERATE##FPS,                      \
            sizeof (CS_BITMAPINFOHEADER),       \
            DX,                                 \
            DY,                                 \
            1,                        \
            DBITCOUNT,                \
            FOURCC_YUY2 | BI_SRCPREROTATE,      \
            SAMPLESIZE(DX,DY,DBITCOUNT), \
            0,                        \
            0,                        \
            0,                        \
            0,                        \
            0, 0, 0                   \
        } \
    }; 

#define MAKE_STREAM_MODE_NV12(StreamModeName, DX, DY, DBITCOUNT, FRAMERATE) \
    CS_DATARANGE_VIDEO StreamModeName =  \
    { \
        {    \
            sizeof (CS_DATARANGE_VIDEO),    \
            0, \
            SAMPLESIZE(DX,DY,DBITCOUNT),    \
            0,                              \
            STATIC_CSDATAFORMAT_TYPE_VIDEO, \
            MEDIASUBTYPE_NV12, \
            STATIC_CSDATAFORMAT_SPECIFIER_VIDEOINFO \
        }, \
 \
        TRUE,                   \
        TRUE,                   \
        CS_VIDEOSTREAM_CAPTURE, \
        0,                      \
 \
        { \
            STATIC_CSDATAFORMAT_SPECIFIER_VIDEOINFO,  \
            CS_AnalogVideo_None, \
            DX,DY,    \
            DX,DY,    \
            DX,DY,    \
            1,        \
            1,        \
            1,        \
            1,        \
            DX, DY,   \
            DX, DY,   \
            DX,       \
            DY,       \
            0,        \
            0,        \
            0,        \
            0,        \
            REFTIME_##FRAMERATE##FPS,                      \
            REFTIME_##FRAMERATE##FPS,                      \
            BITRATE(DX,DY,DBITCOUNT,FRAMERATE) / 8,        \
            BITRATE(DX,DY,DBITCOUNT,FRAMERATE),            \
        },  \
 \
        { \
            0,0,DX,DY,                            \
            0,0,DX,DY,                            \
            BITRATE(DX,DY,DBITCOUNT,FRAMERATE), \
            0L,                                 \
            REFTIME_##FRAMERATE##FPS,                      \
            sizeof (CS_BITMAPINFOHEADER),       \
            DX,                                 \
            DY,                                 \
            2,                        \
            DBITCOUNT,                \
            FOURCC_NV12 | BI_SRCPREROTATE,      \
            SAMPLESIZE(DX,DY,DBITCOUNT), \
            0,                        \
            0,                        \
            0,                        \
            0,                        \
            0, 0, 0                   \
        } \
    }; 

#define MAKE_STREAM_MODE_RGB565(StreamModeName, DX, DY, DBITCOUNT, FRAMERATE) \
    CS_DATARANGE_VIDEO StreamModeName =  \
    { \
        {    \
            sizeof (CS_DATARANGE_VIDEO),     \
            0, \
            SAMPLESIZE(DX,DY,DBITCOUNT),     \
            0,                               \
            STATIC_CSDATAFORMAT_TYPE_VIDEO,   \
            MEDIASUBTYPE_RGB565, \
            STATIC_CSDATAFORMAT_SPECIFIER_VIDEOINFO \
        }, \
 \
        TRUE,                   \
        TRUE,                   \
        CS_VIDEOSTREAM_CAPTURE, \
        0,                      \
 \
        { \
            STATIC_CSDATAFORMAT_SPECIFIER_VIDEOINFO,  \
            CS_AnalogVideo_None, \
            DX,DY,    \
            DX,DY,    \
            DX,DY,    \
            1,        \
            1,        \
            1,        \
            1,        \
            DX, DY,   \
            DX, DY,   \
            DX,       \
            DY,       \
            0,        \
            0,        \
            0,        \
            0,        \
            REFTIME_##FRAMERATE##FPS,                      \
            REFTIME_##FRAMERATE##FPS,                      \
            BITRATE(DX,DY,DBITCOUNT,FRAMERATE) / 4,        \
            BITRATE(DX,DY,DBITCOUNT,FRAMERATE),            \
        },  \
 \
        { \
            0,0,0,0,                            \
            0,0,0,0,                            \
            BITRATE(DX,DY,DBITCOUNT,FRAMERATE), \
            0L,                                 \
            REFTIME_##FRAMERATE##FPS,           \
            sizeof (CS_BITMAPINFOHEADER),       \
            DX,                                 \
            DY,                                 \
            1,                                  \
            DBITCOUNT,                          \
            CS_BI_BITFIELDS | BI_SRCPREROTATE,  \
            SAMPLESIZE(DX,DY,DBITCOUNT),        \
            0,                                  \
            0,                                  \
            0,                                  \
            0,                                  \
            0xf800, 0x07e0, 0x001f              \
        } \
    }; 

#define MAKE_STREAM_MODE_IJPG(StreamModeName, DX, DY, DBITCOUNT, FRAMERATE) \
    CS_DATARANGE_VIDEO StreamModeName =  \
    { \
        {    \
            sizeof (CS_DATARANGE_VIDEO),     \
            0, \
            JPEG_SAMPLESIZE,     \
            0,                               \
            STATIC_CSDATAFORMAT_TYPE_VIDEO,   \
            MEDIASUBTYPE_IJPG, \
            STATIC_CSDATAFORMAT_SPECIFIER_VIDEOINFO \
        }, \
 \
        TRUE,                   \
        TRUE,                   \
        CS_VIDEOSTREAM_CAPTURE, \
        0,                      \
 \
        { \
            STATIC_CSDATAFORMAT_SPECIFIER_VIDEOINFO,  \
            CS_AnalogVideo_None, \
            DX,DY,    \
            DX,DY,    \
            DX,DY,    \
            1,        \
            1,        \
            1,        \
            1,        \
            DX, DY,   \
            DX, DY,   \
            DX,       \
            DY,       \
            0,        \
            0,        \
            0,        \
            0,        \
            REFTIME_##FRAMERATE##FPS,                      \
            REFTIME_##FRAMERATE##FPS,                      \
            BITRATE(DX,DY,DBITCOUNT,FRAMERATE) / 8,        \
            BITRATE(DX,DY,DBITCOUNT,FRAMERATE),            \
        },  \
        \
        { \
            0,0,0,0,                            \
            0,0,0,0,                            \
            BITRATE(DX,DY,DBITCOUNT,FRAMERATE), \
            0L,                                 \
            REFTIME_##FRAMERATE##FPS,                      \
            sizeof (CS_BITMAPINFOHEADER),       \
            DX,                                 \
            DY,                                 \
            1,                        \
            DBITCOUNT,                \
            FOURCC_IJPG | BI_SRCPREROTATE,      \
            JPEG_SAMPLESIZE, \
            0,                        \
            0,                        \
            0,                        \
            0,                        \
            0, 0, 0                   \
        } \
    }; 

MAKE_STREAM_MODE_RGB565(DCAM_StreamMode_RGB565_160x120_30, 160, 120, 16, 30);
MAKE_STREAM_MODE_RGB565(DCAM_StreamMode_RGB565_176x144_30, 176, 144, 16, 30);
MAKE_STREAM_MODE_RGB565(DCAM_StreamMode_RGB565_320x240_15, 320, 240, 16, 15);
MAKE_STREAM_MODE_RGB565(DCAM_StreamMode_RGB565_320x240_30, 320, 240, 16, 30);
MAKE_STREAM_MODE_RGB565(DCAM_StreamMode_RGB565_640x480_30, 640, 480, 16, 30);
MAKE_STREAM_MODE_RGB565(DCAM_StreamMode_RGB565_800x480_30, 800, 480, 16, 30);

MAKE_STREAM_MODE_YV12(DCAM_StreamMode_YV12_176x144_15, 176, -144, 12, 15);
MAKE_STREAM_MODE_YV12(DCAM_StreamMode_YV12_176x144_30, 176, -144, 12, 30);
MAKE_STREAM_MODE_YV12(DCAM_StreamMode_YV12_176x176_30, 176, -176, 12, 30);
MAKE_STREAM_MODE_YV12(DCAM_StreamMode_YV12_240x180_15, 240, -180, 12, 15);
MAKE_STREAM_MODE_YV12(DCAM_StreamMode_YV12_320x240_15, 320, -240, 12, 15);
MAKE_STREAM_MODE_YV12(DCAM_StreamMode_YV12_320x240_30, 320, -240, 12, 30);
MAKE_STREAM_MODE_YV12(DCAM_StreamMode_YV12_400x240_30, 400, -240, 12, 30);
MAKE_STREAM_MODE_YV12(DCAM_StreamMode_YV12_640x480_15, 640, -480, 12, 15);
MAKE_STREAM_MODE_YV12(DCAM_StreamMode_YV12_640x480_30, 640, -480, 12, 30);
MAKE_STREAM_MODE_YV12(DCAM_StreamMode_YV12_800x480_30, 800, -480, 12, 30);
MAKE_STREAM_MODE_YV12(DCAM_StreamMode_YV12_800x600_30, 800, -600, 12, 30);
MAKE_STREAM_MODE_YV12(DCAM_StreamMode_YV12_1280x720_30, 1280, -720, 12, 30);
MAKE_STREAM_MODE_YV12(DCAM_StreamMode_YV12_1280x1024_30, 1280, -1024, 12, 30);
MAKE_STREAM_MODE_YV12(DCAM_StreamMode_YV12_1600x1200_30, 1600, -1200, 12, 30);
MAKE_STREAM_MODE_YV12(DCAM_StreamMode_YV12_3264x2448_30, 3264, -2448, 12, 30);

MAKE_STREAM_MODE_YUY2(DCAM_StreamMode_YUY12_176x144_15, 176, -144, 16, 15);
MAKE_STREAM_MODE_YUY2(DCAM_StreamMode_YUY12_176x144_30, 176, -144, 16, 30);
MAKE_STREAM_MODE_YUY2(DCAM_StreamMode_YUY12_320x240_15, 320, -240, 16, 15);
MAKE_STREAM_MODE_YUY2(DCAM_StreamMode_YUY12_320x240_30, 320, -240, 16, 30);
MAKE_STREAM_MODE_YUY2(DCAM_StreamMode_YUY12_640x480_30, 640, -480, 16, 30);
MAKE_STREAM_MODE_YUY2(DCAM_StreamMode_YUY12_800x480_30, 800, -480, 16, 30);


MAKE_STREAM_MODE_NV12(DCAM_StreamMode_NV12_320x240_15, 320, -240, 12, 15);
MAKE_STREAM_MODE_NV12(DCAM_StreamMode_NV12_640x480_15, 640, -480, 12, 15);
MAKE_STREAM_MODE_NV12(DCAM_StreamMode_NV12_640x480_30, 640, -480, 12, 30);

MAKE_STREAM_MODE_IJPG(DCAM_StreamMode_IJPG_320x240_30, 320, -240, 12, 15);
MAKE_STREAM_MODE_IJPG(DCAM_StreamMode_IJPG_400x240_30, 400, -240, 12, 15);
MAKE_STREAM_MODE_IJPG(DCAM_StreamMode_IJPG_640x480_30, 640, -480, 12, 15);
MAKE_STREAM_MODE_IJPG(DCAM_StreamMode_IJPG_800x480_30, 800, -480, 12, 15);
MAKE_STREAM_MODE_IJPG(DCAM_StreamMode_IJPG_1280x960_30, 1280, -960, 12, 15);
MAKE_STREAM_MODE_IJPG(DCAM_StreamMode_IJPG_1600x1200_30, 1600, -1200, 12, 15);
MAKE_STREAM_MODE_IJPG(DCAM_StreamMode_IJPG_2048x1536_30, 2048, -1536, 12, 15);
MAKE_STREAM_MODE_IJPG(DCAM_StreamMode_IJPG_2560x1536_30, 2560, -1536, 12, 15);
MAKE_STREAM_MODE_IJPG(DCAM_StreamMode_IJPG_2560x1920_30, 2560, -1920, 12, 15);
MAKE_STREAM_MODE_IJPG(DCAM_StreamMode_IJPG_2592x1944_30, 2592, -1944, 12, 15);
MAKE_STREAM_MODE_IJPG(DCAM_StreamMode_IJPG_3264x1960_30, 3264, -1960, 12, 15);
MAKE_STREAM_MODE_IJPG(DCAM_StreamMode_IJPG_3264x2448_30, 3264, -2448, 12, 15);

#endif //__SENSORFORMATS_H
