/*-----------------------------------------------------------------------------
 * Copyright (c) Wolfson Microelectronics plc.  All rights reserved.
 *
 * This software as well as any related documentation is furnished under 
 * license and may only be used or copied in accordance with the terms of the 
 * license. The information in this file is furnished for informational use 
 * only, is subject to change without notice, and should not be construed as 
 * a commitment by Wolfson Microelectronics plc. Wolfson Microelectronics plc
 * assumes no responsibility or liability for any errors or inaccuracies that
 * may appear in this document or any software that may be provided in
 * association with this document. 
 *
 * Except as permitted by such license, no part of this document may be 
 * reproduced, stored in a retrieval system, or transmitted in any form or by 
 * any means without the express written consent of Wolfson Microelectronics plc. 
 *
 *---------------------------------------------------------------------------*/
#ifndef _WM8976_H_
#define _WM8976_H_

//modified by terry 20110929 for WM8976 
#define I2C_CODEC_GROUP_NAME    L"I2C1:"
#define I2C_CODEC_ID            0x34
#define I2C_CODEC_SPEED         100


// WM8976 Codec-chip Initialization Value 
unsigned int WM8580_Codec_Init_Table[][2] =\
{
  	{0x00,0x00},//R0 software reset 
   	{0x03,0xed},//R1 power management 1--PLL 0ff 
	{0x05,0x80},//R2 power management 2
	{0x06,0x6F},//R3 power management 3
	{0x08,0x10},//R4 audio interface control -- 16BIT  i2s
	{0x0d,0x4c},//R6 clock generation control //   0b1:master    0b0:slave
	{0x48,0x07},//R36 PLL N value
  	{0x4A,0x21},//R37 PLL K value 1 [23:20]
  	{0x4d,0x61},//R38 PLL K value 2 [17:9]
  	{0x4E,0x26},//R39 PLL K value 3 [8:0]
	{0x56,0x10},//R43 beep control 
  	{0x64,0x01},//R50 left channel output mixer control
	{0x66,0X01},//R51 right channel output mixer control 
	{0x69,0x39},//R52 LOUT1 volume control 
  	{0x6B,0x39},//R53 ROUT1 volume control 
  	{0x6D,0x3f},//R54 LOUT2 volume control (spk)
  	{0x6F,0x3f},//R55 ROUT2 volume control (spk)
};


//open SPK(out2) and out1 only
// л
unsigned int WM8580_Codec_OpenOUT2_Table[][2] =
{
	{104,0x40},//R52(0x34) unmute out1l
  	{106,0x40},//R53 unmute out1r 
  	{108,0x07/*0x3f*/},//R54 unmute out2l,vol max. lqm changed vol.10-12-01
  	{110,0x07/*0x3F*/},//R55 unmute out2r,vol max
  	{112,0x5f},//{112,0x07},//R56 mute out3
  	{114,0x5f},//R57   mute out4

	
};

//open out1 only
// л
unsigned int WM8580_Codec_OpenOUT1_Table[][2] =
{
	{104,0x1f},//R52(0x34) unmute out1l
  	{106,0x1f},//R53 unmute out1r 
  	{108,0x40/*0x3f*/},//R54 unmute out2l,vol max. lqm changed vol.10-12-01
  	{110,0x40/*0x3F*/},//R55 unmute out2r,vol max
  	{112,0x5f},//{112,0x07},//R56 mute out3
  	{114,0x5f},//R57   mute out4
	
};



//open SPK(out2) and out1 only
// лȺͶ
unsigned int WM8580_Codec_OpenOUT1_OUT2_Table[][2] =
{
	{104,0x1f},//R52(0x34) unmute out1l
  	{106,0x1f},//R53 unmute out1r 
  	{108,0x07/*0x3f*/},//R54 unmute out2l,vol max. lqm changed vol.10-12-01
  	{110,0x07/*0x3F*/},//R55 unmute out2r,vol max
  	{112,0x5f},//{112,0x07},//R56 mute out3
  	{114,0x5f},//R57   mute out4

	
};

//open SPK and out4 only
unsigned int WM8580_Codec_OpenOUT2_OUT4_Table[][2] =
{
	{104,0x40},//R52 mute out1l
  	{106,0x40},//R53 mute out1r 
  	{108,0x3f},//R54 unmute out2l,vol max
  	{110,0x3F},//R55 unmute out2r,vol max
  	{112,0x47},//R56  mute out3
  	{114,0x1f},//R57   unmute out4
};

//-----------------------------------------------------

#endif // _WM8976_H_




