#pragma once

#include <WINDOWS.h>
#include <ModeInterfaceLayer.h>
#include <register_map.h>
#include "dma_controller.h"
#include <bsp_args.h>

typedef class OutNormalMode : public OutModeInterfaceLayer
{
private:
    DWORD                   m_dwElapsedTime;
    DWORD                   m_dwTeaserTime;

    volatile PDMAC_REG      m_pDMAC0Reg;
    volatile PDMAC_REG      m_pDMAC1Reg;
    volatile PDMAC_REG      m_pDMACReg;
    volatile PCMU_CLK_REG   m_pSysConReg;
    volatile PASS_CLK_REG   m_pASSClkReg;
    volatile PASS_CBOX2_REG m_pASSCommBoxReg;
    volatile BSP_ARGS *     m_pBSPArgs;
    volatile PIIS_REG       m_pIISReg;
    DMA_CH_CONTEXT          m_DMACtxt;
    
private:
    BOOL    MapRegister(VOID);
    BOOL    UnmapRegister(VOID);
    BOOL    IsBufferInXfer(DWORD dwBufNum);
    BOOL    StateChange(DWORD IntSrc);
 
public:
    OutNormalMode(OutputDeviceContext *pDevCtxt, InModeInterfaceLayer** ppInMode, PCB_MODEOP pStart, PCB_MODEOP pStop);
    ~OutNormalMode();

    BOOL    Init(LPWSTR lpActivePath);
    BOOL    Deinit(VOID);
    BOOL    SetPowerState(CEDEVICE_POWER_STATE PowerState);
    BOOL    ULPASet(VOID);
    BOOL    ULPAClr(VOID);
    BOOL    StartTransfer(VOID);
    BOOL    PauseTransfer(DWORD dwParam);
    BOOL    ResumeTransfer(VOID);
    BOOL    StopTransfer(BOOL bMediumOff);
    VOID    InterruptThread(VOID);
} *POutNormalMode;

typedef class InNormalMode : public InModeInterfaceLayer
{
private:
    volatile PDMAC_REG      m_pDMAC0Reg;
    volatile PDMAC_REG      m_pDMAC1Reg;
    volatile PDMAC_REG      m_pDMACReg;
    volatile PCMU_CLK_REG   m_pSysConReg;
    volatile PASS_CLK_REG   m_pASSClkReg;
    volatile BSP_ARGS *     m_pBSPArgs;
    volatile PIIS_REG       m_pIISReg;
    DMA_CH_CONTEXT          m_DMACtxt;
    
private:
    BOOL    MapRegister(VOID);
    BOOL    UnmapRegister(VOID);
 
public:
    InNormalMode(InputDeviceContext *pDevCtxt, OutModeInterfaceLayer** ppOutMode, PCB_MODEOP pStart, PCB_MODEOP pStop);
    ~InNormalMode();

    BOOL    Init(LPWSTR lpActivePath);
    BOOL    Deinit(VOID);
    BOOL    SetPowerState(CEDEVICE_POWER_STATE PowerState);
    BOOL    StartTransfer(VOID);
    BOOL    ResumeTransfer(VOID);
    BOOL    StopTransfer(BOOL bMediumOff);
    VOID    InterruptThread(VOID);
} *PInNormalMode;

