#pragma once

#include <WINDOWS.h>
#include <ModeInterfaceLayer.h>
#include <register_map.h>
#include <iis_interface.h>
#include <bsp_args.h>

typedef class OutLowPowerableMode : public OutModeInterfaceLayer
{
protected:
    BOOL                    m_bLowPower;
    BOOL                    m_bOnIncBuf;
    BOOL                    m_bOnDecBuf;
    DWORD                   m_dwDPIdleCnt;
    DWORD                   m_dwTeaserTime;

    volatile PPMU_MISC_REG  m_pMISCReg;
    volatile PIIS_REG       m_pIISReg;
    volatile PASS_CLK_REG   m_pASSClkReg;
    volatile PASS_CBOX3_REG m_pASSCommBoxReg;
    volatile BSP_ARGS *     m_pBSPArgs;
    
private:
    BOOL    MapRegister(VOID);
    BOOL    UnmapRegister(VOID);
    BOOL    IncreaseBufSize(DWORD dwParam);
    BOOL    DecreaseBufSize(DWORD dwParam);
    BOOL    IsBufferInXfer(DWORD dwBufNum);
    BOOL    StateChange(IIS_INTR_SRC IntSrc);
    
public:
    OutLowPowerableMode(BOOL bEnableLowPower, OutputDeviceContext *pDevCtxt, InModeInterfaceLayer** ppInMode, PCB_MODEOP pStart, PCB_MODEOP pStop);
    ~OutLowPowerableMode();

    BOOL    Init(LPWSTR lpActivePath);
    BOOL    Deinit(VOID);
    BOOL    SetPowerState(CEDEVICE_POWER_STATE PowerState);
    BOOL    StartTransfer(VOID);
    BOOL    PauseTransfer(DWORD dwParam);
    BOOL    ResumeTransfer(VOID);
    BOOL    StopTransfer(BOOL bMediumOff);
    VOID    InterruptThread(VOID);
} *POutLowPowerableMode;

