//--------------------------------------------------------------------------------------------------------------------
#include <BSP.h>
#include <I2CEMUL_TYPE.h>
#include <OAL_I2CEMUL.h>
#include <mmilib.h>

extern I2C_EMUL_MAPGPIO *I2CEMULMapGpioLIst[I2C_MAX_GROUP];
extern I2C_EMUL_UNMAPGPIO *I2CEMULUnmapGpioList[I2C_MAX_GROUP];
extern I2CEMUL_GPIO I2CEMULGpioList[I2C_MAX_GROUP];

VOID I2C_EMUL_MapVirtualGPIO5(PVOID pGpioBaseAddr)
{
	volatile S5PV210_GPIO_REG* pRegGpio = (volatile S5PV210_GPIO_REG *)pGpioBaseAddr;

	if (pRegGpio == NULL) 
	{
		RETAILMSG(TRUE, (TEXT("[I2CEMUL] GROUP5 INIT FAIL\n\r")));
	}

#if (BSP_HW_ID>=04)
	//---SCL PARAMETER SETTING : GPH2[5]----------------------------------------------------------------------------
	I2CEMULGpioList[I2CEMUL_G4].pSCLCON_REG = &pRegGpio->GPH2CON; //  = (SCLCON & ~(MASK << INDEX)) | (X << INDEX)
	I2CEMULGpioList[I2CEMUL_G4].dwSCLCONIndex = 20;
	I2CEMULGpioList[I2CEMUL_G4].dwSCLCONMask = 0xF;
	
	I2CEMULGpioList[I2CEMUL_G4].pSCLPUD_REG = &pRegGpio->GPH2PUD;
	I2CEMULGpioList[I2CEMUL_G4].dwSCLPUDIndex = 10;
	I2CEMULGpioList[I2CEMUL_G4].dwSCLPUDMask = 0x3;

	I2CEMULGpioList[I2CEMUL_G4].pSCLDAT_REG = &pRegGpio->GPH2DAT;
	I2CEMULGpioList[I2CEMUL_G4].dwSCLDATIndex =5;

	//---SDA PARAMETER SETTING : GPH2[4]----------------------------------------------------------------------------
	I2CEMULGpioList[I2CEMUL_G4].pSDACON_REG = &pRegGpio->GPH2CON;
	I2CEMULGpioList[I2CEMUL_G4].dwSDACONIndex = 16;
	I2CEMULGpioList[I2CEMUL_G4].dwSDACONMask = 0xF;
	
	I2CEMULGpioList[I2CEMUL_G4].pSDAPUD_REG = &pRegGpio->GPH2PUD;
	I2CEMULGpioList[I2CEMUL_G4].dwSDAPUDIndex = 8;
	I2CEMULGpioList[I2CEMUL_G4].dwSDAPUDMask = 0x3;	

	I2CEMULGpioList[I2CEMUL_G4].pSDADAT_REG = &pRegGpio->GPH2DAT;
	I2CEMULGpioList[I2CEMUL_G4].dwSDADATIndex = 4;
#else	//Pins are reversed...
	//---SCL PARAMETER SETTING : GPH2[4]----------------------------------------------------------------------------
	I2CEMULGpioList[I2CEMUL_G4].pSCLCON_REG = &pRegGpio->GPH2CON; //  = (SCLCON & ~(MASK << INDEX)) | (X << INDEX)
	I2CEMULGpioList[I2CEMUL_G4].dwSCLCONIndex = 16;//20;
	I2CEMULGpioList[I2CEMUL_G4].dwSCLCONMask = 0xF;
	
	I2CEMULGpioList[I2CEMUL_G4].pSCLPUD_REG = &pRegGpio->GPH2PUD;
	I2CEMULGpioList[I2CEMUL_G4].dwSCLPUDIndex = 8;//10;
	I2CEMULGpioList[I2CEMUL_G4].dwSCLPUDMask = 0x3;

	I2CEMULGpioList[I2CEMUL_G4].pSCLDAT_REG = &pRegGpio->GPH2DAT;
	I2CEMULGpioList[I2CEMUL_G4].dwSCLDATIndex =4;// 5;

	//---SDA PARAMETER SETTING : GPH2[5]----------------------------------------------------------------------------
	I2CEMULGpioList[I2CEMUL_G4].pSDACON_REG = &pRegGpio->GPH2CON;
	I2CEMULGpioList[I2CEMUL_G4].dwSDACONIndex = 20;//16;
	I2CEMULGpioList[I2CEMUL_G4].dwSDACONMask = 0xF;
	
	I2CEMULGpioList[I2CEMUL_G4].pSDAPUD_REG = &pRegGpio->GPH2PUD;
	I2CEMULGpioList[I2CEMUL_G4].dwSDAPUDIndex = 10;//8;
	I2CEMULGpioList[I2CEMUL_G4].dwSDAPUDMask = 0x3;	

	I2CEMULGpioList[I2CEMUL_G4].pSDADAT_REG = &pRegGpio->GPH2DAT;
	I2CEMULGpioList[I2CEMUL_G4].dwSDADATIndex = 5;//4;
#endif
	//---ADD TO LIST--------------------------------------------------------------------------------------
}

VOID I2C_EMUL_UnmapVirtualGPIO5(VOID)
{
	//NOT IMPLEMENTED FOR FUTURE
	I2CEMULUnmapGpioList[I2CEMUL_G4] = I2C_EMUL_UnmapVirtualGPIO5;
}



