//--------------------------------------------------------------------------------------------------------------------
#include <BSP.h>
#include <I2CEMUL_TYPE.h>
#include <OAL_I2CEMUL.h>
#include <mmilib.h>

extern I2C_EMUL_MAPGPIO *I2CEMULMapGpioLIst[I2C_MAX_GROUP];
extern I2C_EMUL_UNMAPGPIO *I2CEMULUnmapGpioList[I2C_MAX_GROUP];
extern I2CEMUL_GPIO I2CEMULGpioList[I2C_MAX_GROUP];

VOID I2C_EMUL_MapVirtualGPIO2(PVOID pGpioBaseAddr)
{
	volatile S5PV210_GPIO_REG* pRegGpio = (volatile S5PV210_GPIO_REG *)pGpioBaseAddr;

	if (pRegGpio == NULL) 
	{
		RETAILMSG(TRUE, (TEXT("[I2CEMUL] GROUP2 INIT FAIL\n\r")));
	}
	
	//---SCL PARAMETER SETTING:GPD[6]---------------------------------------------------------------------------
	I2CEMULGpioList[I2CEMUL_G1].pSCLCON_REG = &pRegGpio->GPDCON; //  = (SCLCON & ~(MASK << INDEX)) | (X << INDEX)
	I2CEMULGpioList[I2CEMUL_G1].dwSCLCONIndex = 24;
	I2CEMULGpioList[I2CEMUL_G1].dwSCLCONMask = 0xF;
	
	I2CEMULGpioList[I2CEMUL_G1].pSCLPUD_REG = &pRegGpio->GPDPUD;
	I2CEMULGpioList[I2CEMUL_G1].dwSCLPUDIndex = 12;
	I2CEMULGpioList[I2CEMUL_G1].dwSCLPUDMask = 0x3;

	I2CEMULGpioList[I2CEMUL_G1].pSCLDAT_REG = &pRegGpio->GPDDAT;
	I2CEMULGpioList[I2CEMUL_G1].dwSCLDATIndex = 6;

	//---SDA PARAMETER SETTING----------------------------------------------------------------------------
	I2CEMULGpioList[I2CEMUL_G1].pSDACON_REG = &pRegGpio->GPDCON;
	I2CEMULGpioList[I2CEMUL_G1].dwSDACONIndex = 20;
	I2CEMULGpioList[I2CEMUL_G1].dwSDACONMask = 0xF;
	
	I2CEMULGpioList[I2CEMUL_G1].pSDAPUD_REG = &pRegGpio->GPDPUD;
	I2CEMULGpioList[I2CEMUL_G1].dwSDAPUDIndex = 10;
	I2CEMULGpioList[I2CEMUL_G1].dwSDAPUDMask = 0x3;	

	I2CEMULGpioList[I2CEMUL_G1].pSDADAT_REG = &pRegGpio->GPDDAT;
	I2CEMULGpioList[I2CEMUL_G1].dwSDADATIndex = 5;

	//---ADD TO LIST--------------------------------------------------------------------------------------
}

VOID I2C_EMUL_UnmapVirtualGPIO2(VOID)
{
	//NOT IMPLEMENTED FOR FUTURE
	I2CEMULUnmapGpioList[I2CEMUL_G1] = I2C_EMUL_UnmapVirtualGPIO2;
}



