/*------------------------------------------------------------------------------

        data type header for i2c gpio emulation api v1.0

        file name       : i2c_gpio_emul_datatype.h
        function        : data type header for i2c gpio emulation api
------------------------------------------------------------------------------*/
#ifndef __I2CEMULTYPE_H_
#define __I2CEMULTYPE_H_

#include <windows.h>
#include <Bsp_args.h>

#ifndef LOW
        #define LOW             0
#endif

#ifndef HIGH
        #define HIGH            1
#endif

#define SDA_IN   1
#define SDA_OUT  0
#define SCL_IN    1
#define SCL_OUT  0

typedef struct __I2CEMUL_GPIO
{
        volatile DWORD*         pSCLCON_REG;
        DWORD                           dwSCLCONIndex;
        DWORD                           dwSCLCONMask;

        volatile DWORD*         pSCLPUD_REG;
        DWORD                           dwSCLPUDIndex;
        DWORD                           dwSCLPUDMask;

        volatile DWORD*         pSCLDAT_REG;
        DWORD                           dwSCLDATIndex;
        
        volatile DWORD*         pSDACON_REG;
        DWORD                           dwSDACONIndex;
        DWORD                           dwSDACONMask;

        volatile DWORD*         pSDAPUD_REG;
        DWORD                           dwSDAPUDIndex;
        DWORD                           dwSDAPUDMask;

        volatile DWORD*         pSDADAT_REG;
        DWORD                           dwSDADATIndex;

        BYTE                            btSCLState;
        BYTE                            btSDAState;

        BSP_ARGS                        *pBSPArgs;
        DWORD                           dwSpeed;
        BYTE                            btSlaveAddress; 
} I2CEMUL_GPIO;

typedef VOID (I2C_EMUL_MAPGPIO)( PVOID);
typedef VOID (I2C_EMUL_UNMAPGPIO)(VOID);

#endif __I2CEMULTYPE_H_