/*------------------------------------------------------------------------------
        header for i2c cpu1 emulation api v1.0 : hw & os dependent code

        file name       : i2c_cpu1_emul_api_dependent.h
        function        : internal header for i2c cpu1 emulation api hw & os dependent code
------------------------------------------------------------------------------*/
#include <windows.h>
#include <I2CEMUL_TYPE.h>

#define I2C_EMUL_DBG_MODE                       FALSE

#if I2C_EMUL_DBG_MODE == TRUE
#define I2C_EMUL_DBGPRINT(x)            RETAILMSG(1,(TEXT(x)))
#define I2C_EMUL_DBGPRINT1(x,y)         RETAILMSG(1,(TEXT(x),y))
#define I2C_EMUL_DBGPRINT2(x,y,z)       RETAILMSG(1,(TEXT(x),y,z))
#else
#define I2C_EMUL_DBGPRINT(x)            RETAILMSG(0,(TEXT(x)))
#define I2C_EMUL_DBGPRINT1(x,y)         RETAILMSG(0,(TEXT(x),y))
#define I2C_EMUL_DBGPRINT2(x,y,z)       RETAILMSG(0,(TEXT(x),y,z))
#endif

//------------------------------------------------------------------------------
// hw dependent
//------------------------------------------------------------------------------
VOID I2C_EMUL_LineInit(BYTE btGroup);
BOOL I2C_EMUL_SCLHIGH(BYTE btGroup);
BOOL I2C_EMUL_SCLLOW(BYTE btGroup);
BOOL I2C_EMUL_SDAHIGH(BYTE btGroup);
BOOL I2C_EMUL_SDALOW(BYTE btGroup);

VOID I2C_EMUL_ConfigSCL(BYTE btGroup, BYTE bMode);
VOID I2C_EMUL_ConfigSDA(BYTE btGroup, BYTE bMode);
VOID I2C_EMUL_SetSCL(BYTE btGroup, BYTE bLevel);
VOID I2C_EMUL_SetSDA(BYTE btGroup, BYTE bLevel);
BYTE I2C_EMUL_GetSCL(BYTE btGroup);
BYTE I2C_EMUL_GetSDA(BYTE btGroup);

