/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.
Copyright (c) 2001  Microsoft Corporation

Module Name:    cfnand.h

Abstract:        FLASH Media Driver Interface Samsung S5PV210 CPU with NAND Flash 
                controller.
  
Environment:    As noted, this media driver works on behalf of the FAL to directly
                access the underlying FLASH hardware.  Consquently, this module 
                needs to be linked with FLASHFAL.LIB to produce the device driver 
                named FLASHDRV.DLL.

-----------------------------------------------------------------------------*/
#ifndef _S5PV210_DEVBOARD_
#define _S5PV210_DEVBOARD_

#include "FMD_LB.h"
#include "nand.h"

#define BW_X08                              0
#define BW_X16                              1
#define BW_X32                              2


/*****************************************************************************/
/* Internal Data Structure Definition                                        */
/*****************************************************************************/
typedef struct
{
	UINT8			ucMID;					// Manufacturer ID
	UINT8			ucDID;					// Device ID
	UINT8			ucType;					// SLC / MLC
	
	UINT16			usNumberOfBlocks;		// Number of blocks
	UINT16			usPagesPerBlock;		// Number of pages per block
	UINT16			usBytesPerPage;			// Number of bytes per page
	UINT16			usMainBytesPerPage;		// Main area size per page
	UINT16			usSpareBytesPerPage;	// Spare area size per page

	DWORD			dwTACLS;
	DWORD			dwTWRPH0;
	DWORD			dwTWRPH1;
} NAND_FLASH_SPEC;


static NAND_FLASH_SPEC		g_supportedNAND[] = 
{
	{0xEC, 0xDA, SLC_NAND, 2048, 64, 2112, 2048, 64, 7, 7, 7},		// Samsung 2Gbit SLC - K9F2G08U0A
	{0xEC, 0xF1, SLC_NAND, 1024, 64, 2112, 2048, 64, 7, 7, 7},		// Samsung 1Gbit SLC - K91FG08U0C
	{0xEC, 0xDC, SLC_NAND, 4096, 64, 2112, 2048, 64, 7, 7, 7},		// Samsung 4Gbit SLC - K9F4G08  ADDED BY TERRY
	{0x00, 0x00, SLC_NAND, 0, 0, 0, 0, 0}
};

#define POS_BADBLOCK		(0x00)
#define POS_OEMRESERVED	    (0x01)

#endif _S5PV210_DEVBOARD_

