/******************************************************************************
 *
 * Copyright (c) 2006 SAMSUNG Co. Ltd,
 * All rights reserved.
 *
 * File: menu.h
 *
 * Description: Simple menu system for boot loader
 *
 *****************************************************************************/
#pragma once


typedef void (*PFN_TITLE_HANDLER)(void *arg);
typedef int (*PFN_FUNCTION_HANDLER)(void *arg);
typedef void (*PFN_SUB_FUNCTION)(void *arg);

typedef struct _MENU_ITEM MENU_ITEM;

typedef struct _MENU_ITEM
{
	char cMenuKey;						// Shortcut key for the menu
	char *szMenuName;					// Menu name to display. Ignored if there's TitleHandler function.
	PFN_TITLE_HANDLER pfnTitleHandler;	// Dynamic Menu name display function.

	PFN_FUNCTION_HANDLER pfnHandler;	// Handler function. NULL if menu has sub menu.

	MENU_ITEM *pSubMenu;				// Sub menu item. NULL if no sub menu is there.
	PFN_SUB_FUNCTION pfnPreFunction;	// Function to be executed before displaying sub menu.
	PFN_SUB_FUNCTION pfnPostFunction;	// Function to be executed when exiting sub menu.

	void *menuArg;						// arg which will pass to menu functions.
}MENU_ITEM;

extern int DisplayMenu(char *pMenuTitle, PFN_TITLE_HANDLER pfnTitleHandler, MENU_ITEM *pMenuList, void *menuArg);
// Returns number from user input.  Set hexInput to 1 when the user inputs hex numbers.
extern UINT32 OEMReadNumber(int hexInput);
// Basically same as OEMReadNumber, but it truncates return value if it exceeds the the range.
extern UINT32 OEMReadNumberMax(int hexInput, UINT32 min, UINT32 max);

extern int EbootMainMenu(void);

extern void Hex2Str(DWORD hex, unsigned char *str, unsigned short strSize);
extern void Dec2Str(DWORD dec, unsigned char *str, unsigned short strSize);


