
/**************************************************************************

Module Name:  ACT8937.h

Abstract:


**************************************************************************/

#ifndef __ACT8937__
#define __ACT8937__

#define PMIC8937_SLAVE_ADDR 91
#define Opt_Rd					1 
#define Opt_Wr					0 



//I2C Control Register
#define SYS_CTRL            0x0
#define SYS_SCRATCH            0x1

#define REG1_VSET1            0x20
#define REG1_VSET2            0x21
#define REG1_CTRL	          0x22 

#define REG2_VSET1            0x30
#define REG2_VSET2            0x31
#define REG2_CTRL	          0x32 

#define REG3_VSET1            0x40
#define REG3_VSET2            0x41
#define REG3_CTRL	          0x42 

#define REG4_VSET            0x50
#define REG4_CTRL            0x51

#define REG5_VSET            0x54
#define REG5_CTRL            0x55

#define REG6_VSET            0x60
#define REG6_CTRL            0x61

#define REG7_VSET            0x64
#define REG7_CTRL            0x65


#define APCH_RESERVED        0x70
#define APCH_CTRL71			 0x71
#define APCH_CTRL78			 0x78
#define APCH_CTRL79			 0x79
#define APCH_CTRL7A			 0x7A


/*********************************************************/
//SYS_CTRL Reg bits
#define SYS_CTRL_TRST				(0x01 << 7)
#define SYS_CTRL_nSYSMODE			(0x01 << 6)
#define SYS_CTRL_nSYSLEVMSK			(0x01 << 5)
#define SYS_CTRL_nSYSSTAT     		(0x01 << 4)
#define SYS_CTRL_SYSLEV				(0x0F << 0)
/*********************************************************/
//SYS_SCRATCH Reg bits
//#define SYS_SCRATCH			(0x0F << 0)


/*********************************************************/
//REG1_VSET1 Reg bits
#define REG1_VSET1_VALUE     (0x3F << 0)
/*********************************************************/
//REG1_VSET2 Reg bits
#define REG1_VSET2_VALUE     (0x3F << 0)
/*********************************************************/
//REG1_CTRL Reg bits
#define REG1_CTRL_ON	     (0x01 << 7)
#define REG1_CTRL_PHASE	     (0x01 << 6)
#define REG1_CTRL_MODE	     (0x01 << 5)
#define REG1_CTRL_nFLTMSK    (0x01 << 1)
#define REG1_CTRL_OK	     (0x01 << 0)
/*********************************************************/


//REG2_VSET1 Reg bits
#define REG2_VSET1_VALUE     (0x3F << 0)
/*********************************************************/
//REG2_VSET2 Reg bits
#define REG2_VSET2_VALUE     (0x3F << 0)
/*********************************************************/
//REG2_CTRL Reg bits
#define REG2_CTRL_ON	     (0x01 << 7)
#define REG2_CTRL_PHASE	     (0x01 << 6)
#define REG2_CTRL_MODE	     (0x01 << 5)
#define REG2_CTRL_DELAY	     (0x07 << 2)
#define REG2_CTRL_nFLTMSK    (0x01 << 1)
#define REG2_CTRL_OK	     (0x01 << 0)
/*********************************************************/


//REG3_VSET1 Reg bits
#define REG3_VSET1_VALUE     (0x3F << 0)
/*********************************************************/
//REG3_VSET2 Reg bits
#define REG3_VSET2_VALUE     (0x3F << 0)
/*********************************************************/
//REG3_CTRL Reg bits
#define REG3_CTRL_ON	     (0x01 << 7)
#define REG3_CTRL_PWRSTAT    (0x01 << 6)
#define REG3_CTRL_MODE	     (0x01 << 5)
#define REG3_CTRL_DELAY	     (0x07 << 2)
#define REG3_CTRL_nFLTMSK    (0x01 << 1)
#define REG3_CTRL_OK	     (0x01 << 0)
/*********************************************************/


//REG4_VSET Reg bits
#define REG4_VSET_VALUE     (0x3F << 0)
/*********************************************************/
//REG4_CTRL Reg bits
#define REG4_CTRL_ON	     (0x01 << 7)
#define REG4_CTRL_DIS	     (0x01 << 6)
#define REG4_CTRL_LOWIQ	     (0x01 << 5)
#define REG4_CTRL_DELAY	     (0x07 << 2)
#define REG4_CTRL_nFLTMSK    (0x01 << 1)
#define REG4_CTRL_OK	     (0x01 << 0)
/*********************************************************/


//REG5_VSET Reg bits
#define REG5_VSET_VALUE     (0x3F << 0)
/*********************************************************/
//REG5_CTRL Reg bits
#define REG5_CTRL_ON	     (0x01 << 7)
#define REG5_CTRL_DIS	     (0x01 << 6)
#define REG5_CTRL_LOWIQ	     (0x01 << 5)
//#define REG5_CTRL_DELAY	     (0x07 << 2)
#define REG5_CTRL_nFLTMSK    (0x01 << 1)
#define REG5_CTRL_OK	     (0x01 << 0)
/*********************************************************/


//REG6_VSET Reg bits
#define REG6_VSET_VALUE     (0x3F << 0)
/*********************************************************/
//REG6_CTRL Reg bits
#define REG6_CTRL_ON	     (0x01 << 7)
#define REG6_CTRL_DIS	     (0x01 << 6)
#define REG6_CTRL_LOWIQ	     (0x01 << 5)
//#define REG6_CTRL_DELAY	     (0x07 << 2)
#define REG6_CTRL_nFLTMSK    (0x01 << 1)
#define REG6_CTRL_OK	     (0x01 << 0)
/*********************************************************/



//REG7_VSET Reg bits
#define REG7_VSET_VALUE     (0x3F << 0)
/*********************************************************/
//REG7_CTRL Reg bits
#define REG7_CTRL_ON	     (0x01 << 7)
#define REG7_CTRL_DIS	     (0x01 << 6)
#define REG7_CTRL_LOWIQ	     (0x01 << 5)
//#define REG7_CTRL_DELAY	     (0x07 << 2)
#define REG7_CTRL_nFLTMSK    (0x01 << 1)
#define REG7_CTRL_OK	     (0x01 << 0)
/*********************************************************/


//APCH_CTRL71 Reg bits
#define APCH_CTRL71_SUSCHG	(0x01 << 7)
#define APCH_CTRL71_PRETIMO	(0x01 << 4)
#define APCH_CTRL71_TOTTIMO	(0x01 << 2)
#define APCH_CTRL71_OVPSET	(0x01 << 0)
/*********************************************************/


//APCH_CTRL78 Reg bits
#define APCH_CTRL78_TIMRSTAT	(0x01 << 7)
#define APCH_CTRL78_TEMPSTAT	(0x01 << 6)
#define APCH_CTRL78_INSTAT		(0x01 << 5)
#define APCH_CTRL78_CHGSTAT		(0x01 << 4)
#define APCH_CTRL78_TIMRDAT		(0x01 << 3)
#define APCH_CTRL78_TEMPDAT		(0x01 << 2)
#define APCH_CTRL78_INDAT		(0x01 << 1)
#define APCH_CTRL78_CHGDAT		(0x01 << 0)
/*********************************************************/


//APCH_CTRL79 Reg bits
#define APCH_CTRL79_TIMRTOT		(0x01 << 7)
#define APCH_CTRL79_TEMPIN		(0x01 << 6)
#define APCH_CTRL79_INCON		(0x01 << 5)
#define APCH_CTRL79_CHGEOC		(0x01 << 4)
#define APCH_CTRL79_TIMRPRE		(0x01 << 3)
#define APCH_CTRL79_TEMPOUT		(0x01 << 2)
#define APCH_CTRL79_INDIS		(0x01 << 1)
#define APCH_CTRL79_CHGSTT		(0x01 << 0)
/*********************************************************/


//APCH_CTRL7A Reg bits
//#define APCH_CTRL7A_TIMRTOT		(0x01 << 7)
//#define APCH_CTRL7A_TEMPIN		(0x01 << 6)
//#define APCH_CTRL7A_INCON			(0x01 << 5)
#define APCH_CTRL7A_CSTATE			(0x03 << 4)
//#define APCH_CTRL7A_TIMRPRE		(0x01 << 3)
//#define APCH_CTRL7A_TEMPOUT		(0x01 << 2)
#define APCH_CTRL7A_ACINSTAT		(0x01 << 1)
//#define APCH_CTRL7A_CHGSTT		(0x01 << 0)



//DVSARM 1~4
#define DVS_0_600    (0x00)
#define DVS_0_625    (0x01)
#define DVS_0_650    (0x02)
#define DVS_0_675    (0x03)
#define DVS_0_700    (0x04)
#define DVS_0_725    (0x05)
#define DVS_0_750    (0x06)
#define DVS_0_775    (0x07)

#define DVS_0_800    (0x08)
#define DVS_0_825    (0x09)
#define DVS_0_850    (0x0A)
#define DVS_0_875    (11)
#define DVS_0_900    (12)
#define DVS_0_925    (13)
#define DVS_0_950    (14)
#define DVS_0_975    (15)

#define DVS_1_000    (16)
#define DVS_1_025    (17)
#define DVS_1_050    (18)
#define DVS_1_075    (19)
#define DVS_1_100    (20)
#define DVS_1_125    (21)
#define DVS_1_150    (22)
#define DVS_1_175    (23)

#define DVS_1_200    (24)
#define DVS_1_250    (25)
#define DVS_1_300    (26)
#define DVS_1_350    (27)
#define DVS_1_400    (28)
#define DVS_1_450    (29)
#define DVS_1_500    (30)
#define DVS_1_550    (31)


#define DVS_1_600    (32)
#define DVS_1_650    (33)
#define DVS_1_700    (34)
#define DVS_1_750    (35)
#define DVS_1_800    (36)
#define DVS_1_850    (37)
#define DVS_1_900    (38)
#define DVS_1_950    (39)


#define DVS_2_000    (40)
#define DVS_2_050    (41)
#define DVS_2_100    (42)
#define DVS_2_150    (43)
#define DVS_2_200    (44)
#define DVS_2_250    (45)
#define DVS_2_300    (46)
#define DVS_2_350    (47)


#define DVS_2_400    (48)
#define DVS_2_500    (49)
#define DVS_2_600    (50)
#define DVS_2_700    (51)
#define DVS_2_800    (52)
#define DVS_2_900    (53)
#define DVS_3_000    (54)
#define DVS_3_100    (55)

#define DVS_3_200    (56)
#define DVS_3_300    (57)
#define DVS_3_400    (58)
#define DVS_3_500    (59)
#define DVS_3_600    (60)
#define DVS_3_700    (61)
#define DVS_3_800    (62)
#define DVS_3_900    (63)

/*
#define DVS_L0_ARM          (DVS_1_300)
#define DVS_L1_ARM          (DVS_1_200)
#define DVS_L2_ARM          (DVS_1_100)
#define DVS_L3_ARM          (DVS_1_000)

#define DVS_L0_INT          (DVS_1_200)
#define DVS_L1_INT          (DVS_1_000)
*/

#endif //__SYSTEM_FUNCTION__
