/*************************************************************************/
//                                                                                                                        
// Copyright (c) 2000-2004  Smit Company                    
//               ڹ΢ڣ޹˾  Ȩ    
//               2000-2007                                                                                         
// PROPRIETARY RIGHTS of smit Company are involved in the  
// subject matter of this material.  All manufacturing, reproduction, use,                      
// and sales rights pertaining to this subject matter are governed by the                       
// license agreement.  The recipient of this software implicitly accepts                            
// the terms of the license.                                                                                            
// ĵǹ΢˾ʲ,κʿĶ
//ʹñϱ        
// ӦȨ,еκͽӦķԼ.                  
//
//޸:200855
//:κ(denis wei)
/*************************************************************************/


#ifndef __LCDDRAW_H_
#define __LCDDRAW_H_

typedef union {												
	DWORD DWord;
	BYTE  Index;
	struct {
		BYTE	B;
		BYTE	G;
		BYTE	R;
		BYTE	Dummy;
	} RGB;
	struct {
		BYTE	Cb;
		BYTE	Y;
		BYTE	Cr;
		BYTE	Dummy;
	} YC;
} T_COLOR;

typedef enum
{
 COLOR_RGB8PL,
 COLOR_RGB14D,
 COLOR_RGB15D,
 COLOR_RGB16D,
 COLOR_YC8PL,
 COLOR_YC14D,
 COLOR_YC15D,
 COLOR_YC16D,
 COLOR_YC422,
 MAX_LCD_COLOR
} LcdColorType;

typedef union {														
	WORD Word;
	BYTE Index;
	struct {									/* RGB 14 bitް\		RGB 14 bit data structure	*/
		WORD	A1		: 1;
		WORD	B		: 4;
		WORD	G		: 5;
		WORD	R		: 5;
		WORD	A0		: 1;
	} RGB14D;
	struct {									/* RGB 15 bitް\		RGB 15 bit data structure	*/
		WORD	B		: 5;
		WORD	G		: 5;
		WORD	R		: 5;
		WORD	A0		: 1;
	} RGB15D;
	struct{									/* RGB 16 bitް\		RGB 16 bit data structure	*/
		WORD	B		: 5;
		WORD	G		: 6;
		WORD	R		: 5;
	} RGB16D;
} LCD_COLOR;

typedef struct {						
	WORD	Sx;							/* (W)Start drawing X-coordinate					*/
	WORD	Sy;							/* (W)Start drawing Y-coordinate					*/
	T_COLOR Color;					/* (W)Drawing Color 		  	  				*/
} LCDDRAW_DOT;

typedef struct {						
	UCHAR		Format;					/* (W/R)Color format							*/
	WORD		Width;					/* (W/R)Drawing area width(dot)					*/
	WORD		Height;					/* (W/R)Drawing area height(dot)				*/
	DWORD		TopAddr;				/* (W/R)Top VRAM address 						*/
} LCDDRAW_AREA;	

typedef struct {						
	WORD	Sx;							/* (W)Start drawing  X-coordinate					*/
	WORD	Sy;							/* (W)Start drawing  Y-coordinate					*/
	WORD	Ex;							/* (W)End drawing  X-coordinate						*/
	WORD	Ey;							/* (W)End drawing  Y-coordinate 						*/
	T_COLOR	Color;						/* (W)Drawing Color 	  	   	 					*/
} LCDDRAW_LINE;	

typedef struct {						
	BYTE *fontname;
	BYTE *fontaddress;
	BYTE fontXsize;
	BYTE fontYsize;
} LCDDRAW_FONT;	

typedef struct {	
	WORD	TotalX;
	WORD	TotalY;
	WORD	Sx;							/* (W)Start drawing  X-coordinate					*/
	WORD	Sy;							/* (W)Start drawing  Y-coordinate					*/
	T_COLOR Frontcolor;					/* (W)Drawing Color */
	T_COLOR Backcolor;
} LCDDRAW_STATUS;	

typedef struct {						
	WORD	Sx;							/* (W)Start drawing  X-coordinate					*/
	WORD	Sy;							/* (W)Start drawing  Y-coordinate					*/
	T_COLOR Frontcolor;					/* (W)Drawing Color */
	T_COLOR Backcolor;
	BYTE 	CHAR;
} LCDDRAW_CHAR;	

typedef struct {						
	WORD	Sx;							/* (W)Start drawing  X-coordinate					*/
	WORD	Sy;							/* (W)Start drawing  Y-coordinate					*/
	T_COLOR Frontcolor;					/* (W)Drawing Color */
	T_COLOR Backcolor;
	BYTE 	*STRING;
} LCDDRAW_STRING;	

void LcdDrawTest(void);
void LcdDrawInit();
void LcdSetStringPosition(WORD xpostion,WORD yposition);
void LcdSetStringColor(T_COLOR *frontcolor,T_COLOR *backcolor);
void LcdDrawString (LPCSTR sz, ...);
int LcdDrawChar(LCDDRAW_CHAR *tLcdDrawChar);
int LcdDrawDot(LCDDRAW_DOT *tLcdDrawDot);
int LcdDrawLine(LCDDRAW_LINE *tLcdDrawLine);
int LcdDrawBackGroundColor(T_COLOR tLcdColor);
int LcdDrawPicture(DWORD PitureImageAddress );
void LcdDrawProgressBar(int x, int y, int progress);
// Added by hxy 2008.06.04 16:00.
// Added by hxy 2008.06.04 16:00.
DWORD LcdGetCurrentX( void );
DWORD LcdGetCurrentY( void );
// end added

// end added

#endif
