/*************************************************************************/
//                                                                                                                        
// Copyright (c) 2000-2004  Smit Company                    
//               ڹ΢ڣ޹˾  Ȩ    
//               2000-2007                                                                                         
// PROPRIETARY RIGHTS of smit Company are involved in the  
// subject matter of this material.  All manufacturing, reproduction, use,                      
// and sales rights pertaining to this subject matter are governed by the                       
// license agreement.  The recipient of this software implicitly accepts                            
// the terms of the license.                                                                                            
// ĵǹ΢˾ʲ,κʿĶ
//ʹñϱ        
// ӦȨ,еκͽӦķԼ.                  
//
//޸:200855
//:κ(denis wei)
/*************************************************************************/


#include <windows.h>
#include <bsp.h>
#include <ethdbg.h>
#include <fmd.h>
//#include "loader.h"

#include "lcddraw.h"

extern DWORD g_dwFB_UA_BASE;
extern DWORD g_ExtSetMode;	// add by victor
/* // lqm changed for test.10-01-22
extern DWORD g_LcdXSize;
extern DWORD g_LcdYSize;
*/
 DWORD g_LcdXSize=272;
 DWORD g_LcdYSize=480;

//start from 0x20(ASCII)
// !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'abcdefghijklmnopqrstuvwxyz{|}~
const BYTE tOSDFont[][16]=
{
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*" ",0*/

{0x00,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x18,0x18,0x00,0x00},/*"!",1*/

{0x00,0x12,0x36,0x24,0x48,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*""",2*/

{0x00,0x00,0x00,0x24,0x24,0x24,0xFE,0x48,0x48,0x48,0xFE,0x48,0x48,0x48,0x00,0x00},/*"#",3*/

{0x00,0x00,0x10,0x38,0x54,0x54,0x50,0x30,0x18,0x14,0x14,0x54,0x54,0x38,0x10,0x10},/*"$",4*/

{0x00,0x00,0x00,0x44,0xA4,0xA8,0xA8,0xA8,0x54,0x1A,0x2A,0x2A,0x2A,0x44,0x00,0x00},/*"%",5*/

{0x00,0x00,0x00,0x30,0x48,0x48,0x48,0x50,0x6E,0xA4,0x94,0x88,0x89,0x76,0x00,0x00},/*"&",6*/

{0x00,0x60,0x60,0x20,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"'",7*/

{0x00,0x02,0x04,0x08,0x08,0x10,0x10,0x10,0x10,0x10,0x10,0x08,0x08,0x04,0x02,0x00},/*"(",8*/

{0x00,0x40,0x20,0x10,0x10,0x08,0x08,0x08,0x08,0x08,0x08,0x10,0x10,0x20,0x40,0x00},/*")",9*/

{0x00,0x00,0x00,0x00,0x10,0x10,0xD6,0x38,0x38,0xD6,0x10,0x10,0x00,0x00,0x00,0x00},/*"*",10*/

{0x00,0x00,0x00,0x00,0x10,0x10,0x10,0x10,0xFE,0x10,0x10,0x10,0x10,0x00,0x00,0x00},/*"+",11*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x60,0x20,0xC0},/*",",12*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"-",13*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x60,0x00,0x00},/*".",14*/

{0x00,0x00,0x01,0x02,0x02,0x04,0x04,0x08,0x08,0x10,0x10,0x20,0x20,0x40,0x40,0x00},/*"/",15*/

{0x00,0x00,0x00,0x18,0x24,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x24,0x18,0x00,0x00},/*"0",16*/

{0x00,0x00,0x00,0x10,0x70,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x7C,0x00,0x00},/*"1",17*/

{0x00,0x00,0x00,0x3C,0x42,0x42,0x42,0x04,0x04,0x08,0x10,0x20,0x42,0x7E,0x00,0x00},/*"2",18*/

{0x00,0x00,0x00,0x3C,0x42,0x42,0x04,0x18,0x04,0x02,0x02,0x42,0x44,0x38,0x00,0x00},/*"3",19*/

{0x00,0x00,0x00,0x04,0x0C,0x14,0x24,0x24,0x44,0x44,0x7E,0x04,0x04,0x1E,0x00,0x00},/*"4",20*/

{0x00,0x00,0x00,0x7E,0x40,0x40,0x40,0x58,0x64,0x02,0x02,0x42,0x44,0x38,0x00,0x00},/*"5",21*/

{0x00,0x00,0x00,0x1C,0x24,0x40,0x40,0x58,0x64,0x42,0x42,0x42,0x24,0x18,0x00,0x00},/*"6",22*/

{0x00,0x00,0x00,0x7E,0x44,0x44,0x08,0x08,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00},/*"7",23*/

{0x00,0x00,0x00,0x3C,0x42,0x42,0x42,0x24,0x18,0x24,0x42,0x42,0x42,0x3C,0x00,0x00},/*"8",24*/

{0x00,0x00,0x00,0x18,0x24,0x42,0x42,0x42,0x26,0x1A,0x02,0x02,0x24,0x38,0x00,0x00},/*"9",25*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00},/*":",26*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x20},/*";",27*/

{0x00,0x00,0x00,0x02,0x04,0x08,0x10,0x20,0x40,0x20,0x10,0x08,0x04,0x02,0x00,0x00},/*"<",28*/

{0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00},/*"=",29*/

{0x00,0x00,0x00,0x40,0x20,0x10,0x08,0x04,0x02,0x04,0x08,0x10,0x20,0x40,0x00,0x00},/*">",30*/

{0x00,0x00,0x00,0x3C,0x42,0x42,0x62,0x02,0x04,0x08,0x08,0x00,0x18,0x18,0x00,0x00},/*"?",31*/

{0x00,0x00,0x00,0x38,0x44,0x5A,0xAA,0xAA,0xAA,0xAA,0xB4,0x42,0x44,0x38,0x00,0x00},/*"@",32*/

{0x00,0x00,0x00,0x10,0x10,0x18,0x28,0x28,0x24,0x3C,0x44,0x42,0x42,0xE7,0x00,0x00},/*"A",33*/

{0x00,0x00,0x00,0xF8,0x44,0x44,0x44,0x78,0x44,0x42,0x42,0x42,0x44,0xF8,0x00,0x00},/*"B",34*/

{0x00,0x00,0x00,0x3E,0x42,0x42,0x80,0x80,0x80,0x80,0x80,0x42,0x44,0x38,0x00,0x00},/*"C",35*/

{0x00,0x00,0x00,0xF8,0x44,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x44,0xF8,0x00,0x00},/*"D",36*/

{0x00,0x00,0x00,0xFC,0x42,0x48,0x48,0x78,0x48,0x48,0x40,0x42,0x42,0xFC,0x00,0x00},/*"E",37*/

{0x00,0x00,0x00,0xFC,0x42,0x48,0x48,0x78,0x48,0x48,0x40,0x40,0x40,0xE0,0x00,0x00},/*"F",38*/

{0x00,0x00,0x00,0x3C,0x44,0x44,0x80,0x80,0x80,0x8E,0x84,0x44,0x44,0x38,0x00,0x00},/*"G",39*/

{0x00,0x00,0x00,0xE7,0x42,0x42,0x42,0x42,0x7E,0x42,0x42,0x42,0x42,0xE7,0x00,0x00},/*"H",40*/

{0x00,0x00,0x00,0x7C,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x7C,0x00,0x00},/*"I",41*/

{0x00,0x00,0x00,0x3E,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x88,0xF0},/*"J",42*/

{0x00,0x00,0x00,0xEE,0x44,0x48,0x50,0x70,0x50,0x48,0x48,0x44,0x44,0xEE,0x00,0x00},/*"K",43*/

{0x00,0x00,0x00,0xE0,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x42,0xFE,0x00,0x00},/*"L",44*/

{0x00,0x00,0x00,0xEE,0x6C,0x6C,0x6C,0x6C,0x54,0x54,0x54,0x54,0x54,0xD6,0x00,0x00},/*"M",45*/

{0x00,0x00,0x00,0xC7,0x62,0x62,0x52,0x52,0x4A,0x4A,0x4A,0x46,0x46,0xE2,0x00,0x00},/*"N",46*/

{0x00,0x00,0x00,0x38,0x44,0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x44,0x38,0x00,0x00},/*"O",47*/

{0x00,0x00,0x00,0xFC,0x42,0x42,0x42,0x42,0x7C,0x40,0x40,0x40,0x40,0xE0,0x00,0x00},/*"P",48*/

{0x00,0x00,0x00,0x38,0x44,0x82,0x82,0x82,0x82,0x82,0xB2,0xCA,0x4C,0x38,0x06,0x00},/*"Q",49*/

{0x00,0x00,0x00,0xFC,0x42,0x42,0x42,0x7C,0x48,0x48,0x44,0x44,0x42,0xE3,0x00,0x00},/*"R",50*/

{0x00,0x00,0x00,0x3E,0x42,0x42,0x40,0x20,0x18,0x04,0x02,0x42,0x42,0x7C,0x00,0x00},/*"S",51*/

{0x00,0x00,0x00,0xFE,0x92,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x38,0x00,0x00},/*"T",52*/

{0x00,0x00,0x00,0xE7,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x3C,0x00,0x00},/*"U",53*/

{0x00,0x00,0x00,0xE7,0x42,0x42,0x44,0x24,0x24,0x28,0x28,0x18,0x10,0x10,0x00,0x00},/*"V",54*/

{0x00,0x00,0x00,0xD6,0x92,0x92,0x92,0x92,0xAA,0xAA,0x6C,0x44,0x44,0x44,0x00,0x00},/*"W",55*/

{0x00,0x00,0x00,0xE7,0x42,0x24,0x24,0x18,0x18,0x18,0x24,0x24,0x42,0xE7,0x00,0x00},/*"X",56*/

{0x00,0x00,0x00,0xEE,0x44,0x44,0x28,0x28,0x10,0x10,0x10,0x10,0x10,0x38,0x00,0x00},/*"Y",57*/

{0x00,0x00,0x00,0x7E,0x84,0x04,0x08,0x08,0x10,0x20,0x20,0x42,0x42,0xFC,0x00,0x00},/*"Z",58*/

{0x00,0x1E,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x1E,0x00},/*"[",59*/

{0x00,0x00,0x40,0x40,0x20,0x20,0x10,0x10,0x10,0x08,0x08,0x04,0x04,0x04,0x02,0x02},/*"\",60*/

{0x00,0x78,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x78,0x00},/*"]",61*/

{0x00,0x1C,0x22,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"^",62*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF},/*"_",63*/

{0x00,0x60,0x60,0x20,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"'",64*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x42,0x1E,0x22,0x42,0x42,0x3F,0x00,0x00},/*"a",65*/

{0x00,0x00,0x00,0xC0,0x40,0x40,0x40,0x58,0x64,0x42,0x42,0x42,0x64,0x58,0x00,0x00},/*"b",66*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x22,0x40,0x40,0x40,0x22,0x1C,0x00,0x00},/*"c",67*/

{0x00,0x00,0x00,0x06,0x02,0x02,0x02,0x1E,0x22,0x42,0x42,0x42,0x26,0x1B,0x00,0x00},/*"d",68*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x42,0x7E,0x40,0x40,0x42,0x3C,0x00,0x00},/*"e",69*/

{0x00,0x00,0x00,0x0F,0x11,0x10,0x10,0x7E,0x10,0x10,0x10,0x10,0x10,0x7C,0x00,0x00},/*"f",70*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x44,0x44,0x38,0x40,0x3C,0x42,0x42,0x3C},/*"g",71*/

{0x00,0x00,0x00,0xC0,0x40,0x40,0x40,0x5C,0x62,0x42,0x42,0x42,0x42,0xE7,0x00,0x00},/*"h",72*/

{0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x70,0x10,0x10,0x10,0x10,0x10,0x7C,0x00,0x00},/*"i",73*/

{0x00,0x00,0x00,0x0C,0x0C,0x00,0x00,0x1C,0x04,0x04,0x04,0x04,0x04,0x04,0x44,0x78},/*"j",74*/

{0x00,0x00,0x00,0xC0,0x40,0x40,0x40,0x4E,0x48,0x50,0x68,0x48,0x44,0xEE,0x00,0x00},/*"k",75*/

{0x00,0x00,0x00,0x70,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x7C,0x00,0x00},/*"l",76*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x49,0x49,0x49,0x49,0x49,0xED,0x00,0x00},/*"m",77*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xDC,0x62,0x42,0x42,0x42,0x42,0xE7,0x00,0x00},/*"n",78*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x42,0x42,0x42,0x42,0x42,0x3C,0x00,0x00},/*"o",79*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xD8,0x64,0x42,0x42,0x42,0x44,0x78,0x40,0xE0},/*"p",80*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x22,0x42,0x42,0x42,0x22,0x1E,0x02,0x07},/*"q",81*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xEE,0x32,0x20,0x20,0x20,0x20,0xF8,0x00,0x00},/*"r",82*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3E,0x42,0x40,0x3C,0x02,0x42,0x7C,0x00,0x00},/*"s",83*/

{0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x7C,0x10,0x10,0x10,0x10,0x10,0x0C,0x00,0x00},/*"t",84*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC6,0x42,0x42,0x42,0x42,0x46,0x3B,0x00,0x00},/*"u",85*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE7,0x42,0x24,0x24,0x28,0x10,0x10,0x00,0x00},/*"v",86*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xD7,0x92,0x92,0xAA,0xAA,0x44,0x44,0x00,0x00},/*"w",87*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6E,0x24,0x18,0x18,0x18,0x24,0x76,0x00,0x00},/*"x",88*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE7,0x42,0x24,0x24,0x28,0x18,0x10,0x10,0xE0},/*"y",89*/

{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x44,0x08,0x10,0x10,0x22,0x7E,0x00,0x00},/*"z",90*/

{0x00,0x03,0x04,0x04,0x04,0x04,0x04,0x08,0x04,0x04,0x04,0x04,0x04,0x04,0x03,0x00},/*"{",91*/

{0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08},/*"|",92*/

{0x00,0x60,0x10,0x10,0x10,0x10,0x10,0x08,0x10,0x10,0x10,0x10,0x10,0x10,0x60,0x00},/*"}",93*/

{0x30,0x4C,0x43,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},/*"~",94*/
};

char *szLcdSprintf;

static LCDDRAW_AREA		CurrentLcdDrawArea;
static LCDDRAW_FONT		CurrentLcdDrawFont;
static LCDDRAW_STATUS	CurrentLcdDrawStatus;

VOID LcdDrawSingleByte(UINT8 ch);

void LcdDrawInit(void)
{
	T_COLOR color;
	CurrentLcdDrawArea.Format = COLOR_RGB16D;
	CurrentLcdDrawArea.Height = (WORD)g_LcdXSize;	// "WORD" is added by lqm.
	CurrentLcdDrawArea.Width = (WORD)g_LcdYSize;	// "WORD" is added by lqm.
	CurrentLcdDrawArea.TopAddr = g_dwFB_UA_BASE;
	color.RGB.R =255;
	color.RGB.G =0;
	color.RGB.B =0;		//BLUE SCREEN
	LcdDrawBackGroundColor(color);

	CurrentLcdDrawFont.fontaddress = (BYTE *)tOSDFont;
	CurrentLcdDrawFont.fontname="songti";
	CurrentLcdDrawFont.fontXsize=8;
	CurrentLcdDrawFont.fontYsize=16;

	color.RGB.R =255;		//RED
	color.RGB.G =0;
	color.RGB.B =0;	//BLUE
	CurrentLcdDrawStatus.Backcolor = color;//lqm changed.
	color.RGB.R =255;
	color.RGB.G =255;//255;
	color.RGB.B =0;	//yellow
	CurrentLcdDrawStatus.Frontcolor = color;// lqm changed to blue.
	CurrentLcdDrawStatus.Sx = 2;
	CurrentLcdDrawStatus.Sy = 2;
	
	//CurrentLcdDrawStatus.TotalX = /*(WORD)*/g_LcdXSize/CurrentLcdDrawFont.fontXsize;// "WORD" is added by lqm.
	//CurrentLcdDrawStatus.TotalY = /*(WORD)*/g_LcdYSize/CurrentLcdDrawFont.fontYsize;// "WORD" is added by lqm.
	CurrentLcdDrawStatus.TotalX = (WORD)g_LcdYSize/CurrentLcdDrawFont.fontXsize;// lqm changed.
	CurrentLcdDrawStatus.TotalY = (WORD)g_LcdXSize/CurrentLcdDrawFont.fontYsize;// lqm changed.	
}



// Added by hxy 2008.06.04 16:00.
DWORD LcdGetCurrentX( void )
{
	return 	CurrentLcdDrawStatus.Sx;	
}

DWORD LcdGetCurrentY( void )
{
	return 	CurrentLcdDrawStatus.Sy;
}
// end added

void LcdDrawScreenTest(void)
{
	T_COLOR color;
	BYTE KeySelect = 0;

	while(TRUE)
	{
		KeySelect = 0;
		EdbgOutputDebugString ( "B) draw bluescreen\r\n");
		EdbgOutputDebugString ( "G) draw greenscreen\r\n");
		EdbgOutputDebugString ( "R) draw redscreen\r\n");
		EdbgOutputDebugString ( "ESC) return\r\n");
		while (! ( ( (KeySelect == 'b') || (KeySelect == 'B') ) ||
				(KeySelect == 0x1b) ||
	                   ( (KeySelect == 'g') || (KeySelect == 'G') ) ||
	                   ( (KeySelect == 'r') || (KeySelect == 'R') ) ))
	        {
	            KeySelect = OEMReadDebugByte();
	        }
		 EdbgOutputDebugString ( "%c\r\n", KeySelect);
		 switch(KeySelect)
	        {
	        	case 'b': 
			case 'B': 
				color.RGB.R =0;
				color.RGB.G =0;
				color.RGB.B =255;		//BLUE SCREEN
				LcdDrawBackGroundColor(color);
				break;
	        	case 'g': 
			case 'G':
				color.RGB.R =0;
				color.RGB.G =255;
				color.RGB.B =0;		//GREEN SCREEN
				LcdDrawBackGroundColor(color);
				break;
			case 'r': 
			case 'R':
				color.RGB.R =255;
				color.RGB.G =0;
				color.RGB.B =0;		//RED SCREEN
				LcdDrawBackGroundColor(color);
				break;
			case 0x1b:
				goto LcdDrawScreenTestDone;
			default:
            			break;
		}
	}
	LcdDrawScreenTestDone:
		return;
}

void LcdDrawDotTest(void)
{
	T_COLOR color;
	LCDDRAW_DOT dot;
	BYTE KeySelect = 0;

	color.RGB.R =255;
	color.RGB.G =0;
	color.RGB.B =0;		//RED
	dot.Color = color;

	while(TRUE)
	{
		KeySelect = 0;
		EdbgOutputDebugString ( "1) draw dot1\r\n");
		EdbgOutputDebugString ( "2) draw dot2\r\n");
		EdbgOutputDebugString ( "3) draw dot3\r\n");
		EdbgOutputDebugString ( "4) draw dot4\r\n");
		EdbgOutputDebugString ( "ESC) return\r\n");
		while (! ( ( (KeySelect >= '1') && (KeySelect <= '4') ) ||
				(KeySelect == 0x1b) ||
	                   ( (KeySelect == 'r') || (KeySelect == 'R') ) ))
	        {
	            KeySelect = OEMReadDebugByte();
	        }
		 EdbgOutputDebugString ( "%c\r\n", KeySelect);
		 switch(KeySelect)
	        {
	        	case '1': 
				dot.Sx = 20;
				dot.Sy = 20;
				LcdDrawDot(&dot);
				break;
			case '2': 
				dot.Sx = 400;
				dot.Sy = 240;
				LcdDrawDot(&dot);
				break;
			case '3': 
				dot.Sx = 400;
				dot.Sy = 20;
				LcdDrawDot(&dot);
				break;
			case '4': 
				dot.Sx = 20;
				dot.Sy = 240;
				LcdDrawDot(&dot);
				break;
			case 0x1b:
				goto LcdDrawDotTestDone;
			default:
            			break;
		}
	}
	LcdDrawDotTestDone:
		return;
}

void LcdDrawLineTest(void)
{
	T_COLOR color;
	LCDDRAW_LINE line;
	BYTE KeySelect = 0;

	color.RGB.R =0;
	color.RGB.G =255;
	color.RGB.B =0;		//GREEN
	line.Color = color;

	while(TRUE)
	{
		KeySelect = 0;
		EdbgOutputDebugString ( "1) draw line1\r\n");
		EdbgOutputDebugString ( "2) draw line2\r\n");
		EdbgOutputDebugString ( "3) draw line3\r\n");
		EdbgOutputDebugString ( "4) draw lin4\r\n");
		EdbgOutputDebugString ( "ESC) return\r\n");
		while (! ( ( (KeySelect >= '1') && (KeySelect <= '4') ) ||
				(KeySelect == 0x1b) ||
	                   ( (KeySelect == 'r') || (KeySelect == 'R') ) ))
	        {
	            KeySelect = OEMReadDebugByte();
	        }
		 EdbgOutputDebugString ( "%c\r\n", KeySelect);
		 switch(KeySelect)
	        {
	        	case '1': 
				line.Sx = 50;
				line.Sy = 50;
				line.Ex = 400;
				line.Ey = 50;
				LcdDrawLine(&line);
				break;
			case '2': 
				line.Sx = 50;
				line.Sy = 50;
				line.Ex = 50;
				line.Ey = 250;
				LcdDrawLine(&line);
				break;
			case '3': 
				line.Sx = 50;
				line.Sy = 50;
				line.Ex = 400;
				line.Ey = 250;
				LcdDrawLine(&line);
				break;
			case '4': 
				line.Sx = 400;
				line.Sy = 50;
				line.Ex = 400;
				line.Ey = 250;
				LcdDrawLine(&line);
				break;
			case 0x1b:
				goto LcdDrawDotTestDone;
			default:
            			break;
		}
	}
	LcdDrawDotTestDone:
		return;
}

void LcdDrawCharTest(void)
{
	T_COLOR color;
	LCDDRAW_CHAR mychar;
	BYTE KeySelect = 0;

/*
	color.RGB.R =255;
	color.RGB.G =255;
	color.RGB.B =255;		//white
	mychar.Frontcolor = color;

	color.RGB.R =0;
	color.RGB.G =0;
	color.RGB.B =0;		//black
	mychar.Backcolor = color;
*/
	color.RGB.R =255;
	color.RGB.G =255;
	color.RGB.B =0;		//yellow
	mychar.Frontcolor = color;

	LcdDrawString("lcd draw test string");

	while(TRUE)
	{
		KeySelect = 0;
		EdbgOutputDebugString ( "1) draw char1\r\n");
		EdbgOutputDebugString ( "2) draw char2\r\n");
		EdbgOutputDebugString ( "3) draw char3\r\n");
		EdbgOutputDebugString ( "4) draw char4\r\n");
		EdbgOutputDebugString ( "ESC) return\r\n");
		while (! ( ( (KeySelect >= '1') && (KeySelect <= '4') ) ||
				(KeySelect == 0x1b) ||
	                   ( (KeySelect == 'r') || (KeySelect == 'R') ) ))
	        {
	            KeySelect = OEMReadDebugByte();
	        }
		 EdbgOutputDebugString ( "%c\r\n", KeySelect);
		 switch(KeySelect)
	        {
	        	case '1': 
				mychar.CHAR = '1';
				mychar.Sx = 5;
				mychar.Sy = 5;
				LcdDrawChar(&mychar);
				break;
			case '2': 
				mychar.CHAR = 'A';
				mychar.Sx = 5;
				mychar.Sy = 7;
				LcdDrawChar(&mychar);
				break;
			case '3': 
				mychar.CHAR = '?';
				mychar.Sx = 5;
				mychar.Sy = 9;
				LcdDrawChar(&mychar);
				break;
			case '4': 
				mychar.CHAR = 'B';
				mychar.Sx = 5;
				mychar.Sy = 11;
				LcdDrawChar(&mychar);
				break;
			case 0x1b:
				goto LcdDrawDotTestDone;
			default:
            			break;
		}
	}
	LcdDrawDotTestDone:
		return;
}

void LcdDrawStringTest(void)
{
	T_COLOR frontcolor;
	T_COLOR backcolor;
	BYTE KeySelect = 0;
	while(TRUE)
	{
		KeySelect = 0;
		EdbgOutputDebugString ( "1) draw string1\r\n");
		EdbgOutputDebugString ( "2) draw string2\r\n");
		EdbgOutputDebugString ( "3) draw string3\r\n");
		EdbgOutputDebugString ( "4) draw string4\r\n");
		EdbgOutputDebugString ( "ESC) return\r\n");
		while (! ( ( (KeySelect >= '1') && (KeySelect <= '4') ) ||
				(KeySelect == 0x1b) ||
	                   ( (KeySelect == 'r') || (KeySelect == 'R') ) ))
	        {
	            KeySelect = OEMReadDebugByte();
	        }
		 EdbgOutputDebugString ( "%c\r\n", KeySelect);
		 switch(KeySelect)
	        {
	        	case '1':
				frontcolor.RGB.R =255;
				frontcolor.RGB.G =255;
				frontcolor.RGB.B =0;		//yellow

				backcolor.RGB.R =0;
				backcolor.RGB.G =0;
				backcolor.RGB.B =255;		//blue
				LcdSetStringColor(&frontcolor,&backcolor);
				LcdSetStringPosition(0,0);
				LcdDrawString("I LOVE YOU BABY!!!");
				break;
			case '2':
				frontcolor.RGB.R =0;
				frontcolor.RGB.G =0;
				frontcolor.RGB.B =0;		//black

				backcolor.RGB.R =0;
				backcolor.RGB.G =0;
				backcolor.RGB.B =255;		//blue
				LcdSetStringColor(&frontcolor,&backcolor);
				LcdSetStringPosition(0,3);
				LcdDrawString("0123456789abcdefghijklmnopqrst");
				break;
			case '3': 
				frontcolor.RGB.R =255;
				frontcolor.RGB.G =0;
				frontcolor.RGB.B =0;		//red

				backcolor.RGB.R =0;
				backcolor.RGB.G =0;
				backcolor.RGB.B =0;		//black
				LcdSetStringColor(&frontcolor,&backcolor);
				LcdSetStringPosition(10,5);
				LcdDrawString("()+-<>:'/,.!@#$%^&*-=[]?:");
				break;
			case '4': 
				frontcolor.RGB.R =0;
				frontcolor.RGB.G =255;
				frontcolor.RGB.B =0;		//green

				backcolor.RGB.R =0;
				backcolor.RGB.G =0;
				backcolor.RGB.B =0;		//black
				LcdSetStringColor(&frontcolor,&backcolor);
				LcdSetStringPosition(10,15);
				LcdDrawString("Please Insert SDCARD!");

				LcdSetStringPosition(0,7);
				LcdDrawString("R=%x",frontcolor.RGB.R);
				LcdSetStringPosition(0,8);
				LcdDrawString("G=%x",frontcolor.RGB.G);
				LcdSetStringPosition(0,9);
				LcdDrawString("B=%x",frontcolor.RGB.B);
				break;
			case 0x1b:
				goto LcdDrawDotTestDone;
			default:
            			break;
		}
	}
	LcdDrawDotTestDone:
		return;
}

void LcdDrawTest(void)
{
	BYTE KeySelect = 0;

	while(TRUE)
	{
		KeySelect = 0;
		EdbgOutputDebugString ( "\r\nLCD DRAW TEST  MENU:\r\n");
		EdbgOutputDebugString ( "2006-08-22 VER1.0\r\n");
		EdbgOutputDebugString ( "B) draw backscreen\r\n");
		EdbgOutputDebugString ( "D) draw dot\r\n");
		EdbgOutputDebugString ( "L) draw line\r\n");
		EdbgOutputDebugString ( "C) draw char\r\n");
		EdbgOutputDebugString ( "S) draw string\r\n");
		EdbgOutputDebugString ( "ESC) return\r\n");
		while (! ( ( (KeySelect == 'b') || (KeySelect == 'B') ) ||
				(KeySelect == 0x1b) ||
				 ( (KeySelect == 'd') || (KeySelect == 'D') ) ||
		               ( (KeySelect == 'l') || (KeySelect == 'L') ) ||
		               ( (KeySelect == 'c') || (KeySelect == 'C') ) ||
		               ( (KeySelect == 's') || (KeySelect == 'S') ) ))
		    {
		        KeySelect = OEMReadDebugByte();
			//	if(KeySelect!=0xff)
			//		EdbgOutputDebugString("%c\r\n", KeySelect);
		    }
		 EdbgOutputDebugString("%c\r\n", KeySelect);
		 switch(KeySelect)
		    {
		    	case 'b': 
			case 'B':
				EdbgOutputDebugString("DRAW SCREEN\r\n");
				LcdDrawScreenTest();
				break;
			case 'D': 
			case 'd':
				EdbgOutputDebugString("DRAW DOT\r\n");
				LcdDrawDotTest();
				break;
		    	case 'L': 
			case 'l':
				EdbgOutputDebugString("DRAW LINE\r\n");
				LcdDrawLineTest();
				break;
			case 'C': 
			case 'c':
				EdbgOutputDebugString("DRAW CHAR\r\n");
				LcdDrawCharTest();
				break;
			case 'S': 
			case 's':
				EdbgOutputDebugString("DRAW STRING\r\n");
				LcdDrawStringTest();
				break;
			case 0x1b:
				goto LcdDrawTestDone;
			default:
            			break;
			
		}
	}
	LcdDrawTestDone:
		return;
}

LCD_COLOR ColorCnv(BYTE Format,T_COLOR tColor)
{
	LCD_COLOR tA7Color;

	/*--------------Convert color	----------------------------------------*/
	switch (Format)
	{
		case COLOR_RGB14D:
			tA7Color.RGB14D.R = tColor.RGB.R >> 3;
			tA7Color.RGB14D.G = tColor.RGB.G >> 3;
			tA7Color.RGB14D.B = tColor.RGB.B >> 4;
			break;
		case COLOR_RGB15D:
			tA7Color.RGB15D.R = tColor.RGB.R >> 3;
			tA7Color.RGB15D.G = tColor.RGB.G >> 3;
			tA7Color.RGB15D.B = tColor.RGB.B >> 3;
			break;
		case COLOR_RGB16D:
			tA7Color.RGB16D.R = tColor.RGB.R >> 3;
			tA7Color.RGB16D.G = tColor.RGB.G >> 2;
			tA7Color.RGB16D.B = tColor.RGB.B >> 3;
			break;
	}

	return tA7Color;
}

void LcdSetStringPosition(WORD hpostion,WORD vposition)
{
	CurrentLcdDrawStatus.Sx = hpostion;
	CurrentLcdDrawStatus.Sy = vposition;
}

void LcdSetStringColor(T_COLOR *frontcolor,T_COLOR *backcolor)
{
	CurrentLcdDrawStatus.Frontcolor = *frontcolor;
	CurrentLcdDrawStatus.Backcolor = *backcolor;
}

void LcdLoadFont()
{
	
}

/*****************************************************************************
*
*
*   @func   void    |   LcdDrawByte | Sends a byte out of the monitor port.
*
*   @rdesc  none
*
*   @parm   unsigned int |   c |
*               Byte to send.
*
*/
static void
LcdDrawByte(   unsigned char c)
{
    if (szLcdSprintf)
        *szLcdSprintf++ = c;
    else
    	{
		//OEMWriteDebugByte(c);
		LcdDrawSingleByte(c);
    	}
}

/*****************************************************************************
*
*
*   @func   void    |   pOutputNumHex | Print the hex representation of a number through the monitor port.
*
*   @rdesc  none
*
*   @parm   unsigned long |   n |
*               The number to print.
*
*   @parm   long | depth |
*               Minimum number of digits to print.
*
*/
static void LcdDrawNumHex (unsigned long n, long depth)
{
    if (depth) 
   {
        depth--;
    }
    
    if ((n & ~0xf) || depth) {
        LcdDrawNumHex(n >> 4, depth);
        n &= 0xf;
    }
    
    if (n < 10) 
   {
        LcdDrawByte((unsigned char)(n + '0'));
    }
    else 
   { 
      LcdDrawByte((unsigned char)(n - 10 + 'A'));
    }
}

/*****************************************************************************
*
*
*   @func   void    |   OutputString | Sends an unformatted string to the monitor port.
*
*   @rdesc  none
*
*   @parm   const unsigned char * |   s |
*               points to the string to be printed.
*
*   @comm
*           backslash n is converted to backslash r backslash n
*/
static void LcdDrawStringSingle (const unsigned char *s)
{
    while (*s) 
   {        
        if (*s == '\n')
	 {
            //OEMWriteDebugByte('\r');
            LcdDrawSingleByte('\r');
        }
        //OEMWriteDebugByte(*s++);
        LcdDrawSingleByte(*s++);
    }
}

/*****************************************************************************
*
*
*   @func   void    |   pOutputNumDecimal | Print the decimal representation of a number through the monitor port.
*
*   @rdesc  none
*
*   @parm   unsigned long |   n |
*               The number to print.
*
*/
static void LcdDrawNumDecimal (unsigned long n)
{
    if (n >= 10) {
        LcdDrawNumDecimal(n / 10);
        n %= 10;
    }
    LcdDrawByte((unsigned char)(n + '0'));
}

/*****************************************************************************
*
*
*   @func   void    | EdbgOutputDebugString | Simple formatted debug output string routine
*
*   @rdesc  none
*
*   @parm   LPCSTR  |   sz,... |
*               Format String:
*
*               @flag Format string | type
*               @flag u | unsigned
*               @flag d | int
*               @flag c | char
*               @flag s | string
*               @flag x | 4-bit hex number
*               @flag B | 8-bit hex number
*               @flag H | 16-bit hex number
*               @flag X | 32-bit hex number
*
*   @comm
*           Same as FormatString, but output to serial port instead of buffer.
*/
void LcdDrawString (LPCSTR sz, ...)
{
    unsigned char    c;
    va_list         vl;
    
    va_start(vl, sz);
    
    while (*sz) {
        c = *sz++;
        switch (c) {
        case '%':
            c = *sz++;
            switch (c) { 
            case 'x':
                LcdDrawNumHex(va_arg(vl, unsigned long), 0);
                break;
            case 'B':
                LcdDrawNumHex(va_arg(vl, unsigned long), 2);
                break;
            case 'H':
                LcdDrawNumHex(va_arg(vl, unsigned long), 4);
                break;
            case 'X':
                LcdDrawNumHex(va_arg(vl, unsigned long), 8);
                break;
            case 'd':
                {
                    long    l;
                
                    l = va_arg(vl, long);
                    if (l < 0) { 
                        LcdDrawByte('-');
                        l = - l;
                    }
                    LcdDrawNumDecimal((unsigned long)l);
                }
                break;
            case 'u':
                LcdDrawNumDecimal(va_arg(vl, unsigned long));
                break;
            case 's':
                LcdDrawStringSingle(va_arg(vl, char *));
                break;
            case '%':
                LcdDrawByte('%');
                break;
            case 'c':
                c = va_arg(vl, unsigned char);
                LcdDrawByte(c);
                break;
                
            default:
                LcdDrawByte(' ');
                break;
            }
            break;
        case '\r':
            if (*sz == '\n')
                sz ++;
            c = '\n';
            // fall through
        case '\n':
            LcdDrawByte('\r');
            // fall through
        default:
            LcdDrawByte(c);
        }
    }
    
    va_end(vl);
}

VOID LcdDrawSingleByte(UINT8 ch)
{
	LCDDRAW_CHAR mychar;
    mychar.CHAR = ch;
	mychar.Sx=CurrentLcdDrawStatus.Sx;
	mychar.Sy=CurrentLcdDrawStatus.Sy;
	mychar.Frontcolor=CurrentLcdDrawStatus.Frontcolor;
	mychar.Backcolor=CurrentLcdDrawStatus.Backcolor;
	LcdDrawChar(&mychar);

	CurrentLcdDrawStatus.Sx++;
	
	if(CurrentLcdDrawStatus.Sx>CurrentLcdDrawStatus.TotalX)
	{
		CurrentLcdDrawStatus.Sx = 0;
		CurrentLcdDrawStatus.Sy++;
		if(CurrentLcdDrawStatus.Sy>CurrentLcdDrawStatus.TotalY)
			CurrentLcdDrawStatus.Sy = 0;
	}
}

int LcdDrawChar(LCDDRAW_CHAR *tLcdDrawChar)
{
	int i,j;
	LCDDRAW_DOT tLcdDrawDot;
	for(i=0;i<CurrentLcdDrawFont.fontYsize;i++)
	{
		for(j=0;j<CurrentLcdDrawFont.fontXsize;j++)
		{	
			if(((tOSDFont[tLcdDrawChar->CHAR-0x20][i]<<j)&0x80)==0x80)
				tLcdDrawDot.Color = tLcdDrawChar->Frontcolor;
			else
				tLcdDrawDot.Color = tLcdDrawChar->Backcolor;
			tLcdDrawDot.Sx = (tLcdDrawChar->Sx*CurrentLcdDrawFont.fontXsize)+j;
			tLcdDrawDot.Sy = (tLcdDrawChar->Sy*CurrentLcdDrawFont.fontYsize)+i;
			LcdDrawDot(&tLcdDrawDot);
		}
	}
	return 1;
}

int LcdDrawLine(LCDDRAW_LINE *tLcdDrawLine)
{
	int i_wx,i_wy,i_d;
	int i_diff;
	int i_x1,i_x2,i_y1,i_y2;
	LCDDRAW_DOT tLcdDrawDot;
	
	tLcdDrawDot.Color = tLcdDrawLine->Color;
	i_wx = abs(tLcdDrawLine->Sx - tLcdDrawLine->Ex);
	i_wy = abs(tLcdDrawLine->Sy - tLcdDrawLine->Ey);
	
	if(i_wx >= i_wy)
	{													/*x-coordinate >= y-coordinate	*/
		if((tLcdDrawLine->Sy <= tLcdDrawLine->Ey) &&		/*Upper left to lower right	 	*/
			(tLcdDrawLine->Sx <= tLcdDrawLine->Ex))
		{		
			i_x1 = tLcdDrawLine->Sx;						
			i_x2 = tLcdDrawLine->Ex;
			i_y1 = tLcdDrawLine->Sy;
			i_y2 = tLcdDrawLine->Ey;
			i_d = 1;
		} else 
		{										
		if((tLcdDrawLine->Sy <= tLcdDrawLine->Ey) &&		/*Upper right to lower left		*/
			(tLcdDrawLine->Sx > tLcdDrawLine->Ex))
		{		
			i_x1 = tLcdDrawLine->Ex;						
			i_x2 = tLcdDrawLine->Sx;
			i_y1 = tLcdDrawLine->Ey;
			i_y2 = tLcdDrawLine->Sy;
			i_d = -1;
		} else 
		{										/*--------------------------------------------------*/
		if((tLcdDrawLine->Sy > tLcdDrawLine->Ey) &&		/* E	Lower left to upper right		*/
			(tLcdDrawLine->Sx <= tLcdDrawLine->Ex)){		/* Ww̏ꍇ  									*/
			i_x1 = tLcdDrawLine->Sx;						/*--------------------------------------------------*/
			i_x2 = tLcdDrawLine->Ex;
			i_y1 = tLcdDrawLine->Sy;
			i_y2 = tLcdDrawLine->Ey;
			i_d = -1;
		} else
		{										/*--------------------------------------------------*/
		if((tLcdDrawLine->Sy > tLcdDrawLine->Ey) &&		/* E獶	Lower right to upper left		*/
			(tLcdDrawLine->Sx > tLcdDrawLine->Ex)){		/* Ww̏ꍇ  									*/
			i_x1 = tLcdDrawLine->Ex;						/*--------------------------------------------------*/
			i_x2 = tLcdDrawLine->Sx;
			i_y1 = tLcdDrawLine->Ey;
			i_y2 = tLcdDrawLine->Sy;
			i_d = 1;
		}}}}
		/*----------	ޯĕ`ݒ	Setting of dot drawing	--------------------------------------------*/
		i_diff = i_wx/2;
		for (;i_x1 <= i_x2; i_x1++) {					/*--------------------------------------------------*/
			tLcdDrawDot.Sx = i_x1;						/* x Wݒ		Setting of x-coordinate			*/
			tLcdDrawDot.Sy = i_y1;						/* y Wݒ		Setting of y-coordinate			*/
			if (LcdDrawDot(&tLcdDrawDot) == 0)		/* s				Execution						*/
										 return 0;	/*--------------------------------------------------*/
			i_diff -= i_wy;								/*--------------------------------------------------*/
			if(i_diff<0){								/* i_y1lZo		Calcurate i_y1 value			*/
				i_diff += i_wx;							/*													*/
				i_y1 += i_d;							/*													*/
			}											/*--------------------------------------------------*/
		}												/*--------------------------------------------------*/
	} else {											/* c̐̏ꍇ	x-coordinate < y-coordinate		*/
		/*-----	ƗpWݒ  Setting of coordinate  -----------------------------------------------------*/
														/*--------------------------------------------------*/
		if((tLcdDrawLine->Sy <= tLcdDrawLine->Ey) &&		/* ォE	Upper left to lower right		*/
			(tLcdDrawLine->Sx <= tLcdDrawLine->Ex)){		/* Ww̏ꍇ  									*/
			i_x1 = tLcdDrawLine->Sx;						/*--------------------------------------------------*/
			i_x2 = tLcdDrawLine->Ex;
			i_y1 = tLcdDrawLine->Sy;
			i_y2 = tLcdDrawLine->Ey;
			i_d = 1;
		} else {										/*--------------------------------------------------*/
		if((tLcdDrawLine->Sy <= tLcdDrawLine->Ey) &&		/* Eォ獶	Upper right to lower left		*/
			(tLcdDrawLine->Sx > tLcdDrawLine->Ex)){		/* Ww̏ꍇ  									*/
			i_x1 = tLcdDrawLine->Sx;						/*--------------------------------------------------*/
			i_x2 = tLcdDrawLine->Ex;
			i_y1 = tLcdDrawLine->Sy;
			i_y2 = tLcdDrawLine->Ey;
			i_d = -1;
		} else {										/*--------------------------------------------------*/
		if((tLcdDrawLine->Sy > tLcdDrawLine->Ey) &&		/* E	Lower left to upper right		*/
			(tLcdDrawLine->Sx <= tLcdDrawLine->Ex)){		/* Ww̏ꍇ 									*/
			i_x1 = tLcdDrawLine->Ex;						/*--------------------------------------------------*/
			i_x2 = tLcdDrawLine->Sx;
			i_y1 = tLcdDrawLine->Ey;
			i_y2 = tLcdDrawLine->Sy;
			i_d = -1;
		} else {										/*--------------------------------------------------*/
		if((tLcdDrawLine->Sy > tLcdDrawLine->Ey) &&		/* E獶	Lower right to upper left		*/
			(tLcdDrawLine->Sx > tLcdDrawLine->Ex)){		/* Ww̏ꍇ  									*/
			i_x1 = tLcdDrawLine->Ex;						/*--------------------------------------------------*/
			i_x2 = tLcdDrawLine->Sx;
			i_y1 = tLcdDrawLine->Ey;
			i_y2 = tLcdDrawLine->Sy;
			i_d = 1;
		}}}}

		/*----------	ޯĕ`ݒ Setting of dot drawing	------------------------------------------------*/
		i_diff = i_wy/2;
		for (;i_y1 <= i_y2; i_y1++) {					/*--------------------------------------------------*/
			tLcdDrawDot.Sx = i_x1;						/* x Wݒ		Setting of x-coordinate			*/
			tLcdDrawDot.Sy = i_y1;						/* y Wݒ		Setting of y-coordinate			*/
			if (LcdDrawDot(&tLcdDrawDot) == 0)		/* s				Execution						*/
										 return 0;	/*--------------------------------------------------*/
			i_diff -= i_wx;								/*--------------------------------------------------*/
			if(i_diff<0){								/* i_x1lZo		 Calcurate i_x1					*/
				i_diff += i_wy;							/*													*/
				i_x1 += i_d;							/*													*/
			}											/*--------------------------------------------------*/
		}
	}
	return 1;
}

int LcdDrawDot(LCDDRAW_DOT *tLcdDrawDot)
{
	int color;
	WORD x;
	WORD y;
	ULONG C;
	color = ColorCnv(COLOR_RGB16D,tLcdDrawDot->Color).Word;
	x = tLcdDrawDot->Sx;
	y = tLcdDrawDot->Sy;
	if(x>(CurrentLcdDrawArea.Width-1))
		return 0;
	if(y>(CurrentLcdDrawArea.Height-1))
		return 0;
	C = x + y * CurrentLcdDrawArea.Width;
	*((PUSHORT)(CurrentLcdDrawArea.TopAddr + C * 2)) = (USHORT)(color);
	return 1;
}

int LcdDrawBackGroundColor(T_COLOR tLcdColor)
{
	int color;
	ULONG x,y,C;
	color = ColorCnv(COLOR_RGB16D,tLcdColor).Word;

	//RETAILMSG(1, (TEXT("backR = %x\r\n"),tLcdColor.RGB.R));
	//RETAILMSG(1, (TEXT("backG = %x\r\n"),tLcdColor.RGB.G));
	//RETAILMSG(1, (TEXT("backB = %x\r\n"),tLcdColor.RGB.B));
	//RETAILMSG(1, (TEXT("Backcolor = %x\r\n"),color));

	for (y = 0; y < CurrentLcdDrawArea.Height; y++) 
	{
        	for (x = 0; x < CurrentLcdDrawArea.Width; x++) 
		{
        		//C = x + (_BOOT_BMP_YSIZE-1 - y) * _BOOT_BMP_XSIZE;
        		C = x + y * CurrentLcdDrawArea.Width;
			*((PUSHORT)(CurrentLcdDrawArea.TopAddr + C * 2)) = (USHORT)(color);
			

			//*((PUCHAR)(IMAGE_FRAMEBUFFER_UA_BASE + C * 2 + 1)) = (UCHAR)(R & 0xf8) | (G >> 5);
        		//*((PUCHAR)(IMAGE_FRAMEBUFFER_UA_BASE + C * 2 + 0)) = (UCHAR)((G<<3) & 0xe0) | (B >> 3);
        
          	}
	}
    	//memset((void *)IMAGE_FRAMEBUFFER_UA_BASE, color, (CurrentLcdDrawArea.Height*CurrentLcdDrawArea.Width*2));
    	return 1;
}

int LcdDrawPicture(DWORD PitureImageAddress )
{
	/*ULONG x;
	ULONG y;
	ULONG R;
	ULONG G;
	ULONG B;*/
	ULONG C;

	PUCHAR addr1;
	PUCHAR addr2;

	USHORT x;
	USHORT y;
	USHORT R;
	USHORT G;
	USHORT B;
	ULONG temp1;
	ULONG temp2;
	
    for (y = 0; y < CurrentLcdDrawArea.Height; y++) 
	{
		for (x = 0; x < CurrentLcdDrawArea.Width; x++) 
		{
        	/*
        	C = x + (CurrentLcdDrawArea.Height-1 - y) * CurrentLcdDrawArea.Width;
			addr1 = (PUCHAR)PitureImageAddress + 0x36 + y * CurrentLcdDrawArea.Width * 3 + x * 3;
			B = *addr1;
			G = *(addr1+1);
			R = *(addr1+2);
			addr2 = (PUCHAR)(CurrentLcdDrawArea.TopAddr + C * 2);
			* addr2 = (UCHAR)((G<<3) & 0xe0) | (B >> 3);
			*(addr2+1) = (UCHAR)(R & 0xf8) | (G >> 5);
			*/
			C = x + (CurrentLcdDrawArea.Height-1 - y) * CurrentLcdDrawArea.Width;
			temp1 = y * CurrentLcdDrawArea.Width;
			temp1 +=(temp1<<1);
			temp2 = (x<<1)+x;
			addr1 = (PUCHAR)PitureImageAddress + 0x36 + temp1 + temp2;
			B = *(addr1++);
			G = *(addr1++);
			R = *addr1;
			addr2 = (PUCHAR)(CurrentLcdDrawArea.TopAddr + (C << 1));
			* addr2 = (UCHAR)((G<<3) & 0xe0) | (B >> 3);
			*(addr2+1) = (UCHAR)(R & 0xf8) | (G >> 5);
         	}
	}

	return 1;
}

void GUI_PutChar8_8(int x, int y, char ch)
{
	LCDDRAW_CHAR mychar;
    T_COLOR frontcolor;
    T_COLOR backcolor;
	int i,j;
	LCDDRAW_DOT tLcdDrawDot;

	frontcolor.RGB.R =255;
	frontcolor.RGB.G =255;
	frontcolor.RGB.B =255;		//red

	backcolor.RGB.R =0;
	backcolor.RGB.G =0;
	backcolor.RGB.B =255;		//black
//	LcdSetStringColor(&frontcolor,&backcolor);

    mychar.CHAR = ch;
	mychar.Sx = x;
	mychar.Sy = y;
	mychar.Frontcolor=frontcolor;
	mychar.Backcolor=backcolor;
//	LcdDrawChar(&mychar);


	for(i=0;i<CurrentLcdDrawFont.fontYsize;i++)
	{
		for(j=0;j<CurrentLcdDrawFont.fontXsize;j++)
		{	
			if(((tOSDFont[mychar.CHAR-0x20][i]<<j)&0x80)==0x80)
				tLcdDrawDot.Color = mychar.Frontcolor;
			else
				tLcdDrawDot.Color = mychar.Backcolor;
			tLcdDrawDot.Sx = (x)+j;
			tLcdDrawDot.Sy = (y)+i;
			LcdDrawDot(&tLcdDrawDot);
		}
	}    
}

void GUI_HLine(int x1, int y1, int x2, unsigned int  color)
{
	LCDDRAW_LINE line;

	line.Color.RGB.R = 255;
	line.Color.RGB.G = 255;
	line.Color.RGB.B = 0;
   
	line.Sx = x1;
	line.Sy = y1;
	line.Ex = x2;
	line.Ey = y1;
    LcdDrawLine(&line);
}

void GUI_VLine(int x1, int y1, int y2, unsigned int color)
{
	LCDDRAW_LINE line;

	line.Color.RGB.R = 255;
	line.Color.RGB.G = 255;
	line.Color.RGB.B = 0;

	line.Sx = x1;
	line.Sy = y1;
	line.Ex = x1;
	line.Ey = y2;
    LcdDrawLine(&line);
}

/*
    LCD
*/
void LcdDrawProgressBar(int x, int y, int progress)
{
	int i;
	char ch;

	if (progress < 0) progress = 0;
	if (progress >100)progress = 100;

	// -\|/	
	i = progress%4;
	if (i == 0) ch = '-';	//GUI_PutChar8_8(x, y+1, '-');
	else if (i==1) ch = '/';	//GUI_PutChar8_8(x, y+1, '\\');	
	else if (i==2) ch = '|';	//GUI_PutChar8_8(x, y+1, '|');
	else if (i==3) ch = '\\';	//GUI_PutChar8_8(x, y+1, '/');				
	GUI_PutChar8_8(x, y+1, ch);	
							 
	// draw rec
	GUI_HLine(x+10, y, x+210, 0xffff);
	GUI_HLine(x+10, y+18, x+210, 0xffff);		
	GUI_VLine(x+10, y, y+18, 0xffff);
	GUI_VLine(x+210,y, y+18, 0xffff);				
		
	// draw progress
	for(i=0; i<progress; i++) {
		GUI_VLine(i*2+x+10, y+1, y+17, 0xffe0);					
		GUI_VLine(i*2+x+11, y+1, y+17, 0xffe0);						
	}		
		
	// print %
	i = (progress/100)%10;
	if (i == 0) 
		ch=' ';
	else
		ch = (i+'0');		
	GUI_PutChar8_8(x+212, y+1, ch);	
	
	i = (progress/10)%10;		 		
	if (i == 0) 
		ch=' ';
	else
		ch = (i+'0');		
		
	if (progress==100) ch='0';		
	GUI_PutChar8_8(x+220, y+1, ch);							

	i = progress % 10;
	ch = (i+'0');		
	GUI_PutChar8_8(x+228, y+1, ch);			
		
	// print %	
	GUI_PutChar8_8(x+236, y+1, '%');				

}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
masked by denis_wei
void  GUI_LoadPicture()
{ 
    FMD_ReadSector(LOGOBMP_SECTOR, (PUCHAR)(g_dwFB_UA_BASE), NULL, 320*240*2);		    	
}
*/
